/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Build;
import android.util.Log;
import com.lib.sdk.bean.StringUtils;
import com.utils.BaseThreadPool;
import com.utils.CheckNetWork;
import com.utils.XMWifiManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class XMWiFiConnectManager {
    private static String MYLOG = XMWiFiConnectManager.class.getClass().getSimpleName();
    private HashMap<String, ScanResult> enableWiFi = null;
    private Context context;
    private XMWifiManager wifiManager;
    private IntentFilter wifiFilter = null;
    private String tryConnectSSID;
    private static final String TAG = "zyy----------";
    private BroadcastReceiver wifiConnectReceiver = new BroadcastReceiver(){

        public void onReceive(Context arg0, Intent intent) {
            if (intent.getAction() == "android.net.conn.CONNECTIVITY_CHANGE") {
                if (null != XMWiFiConnectManager.this.wifiStateLs && null != XMWiFiConnectManager.this.wifiManager) {
                    WifiInfo wifiInfo = XMWiFiConnectManager.this.wifiManager.getWifiInfo();
                    if (null == wifiInfo) {
                        return;
                    }
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    XMWiFiConnectManager.this.wifiStateLs.onNetWorkState(info.getDetailedState(), info.getType(), wifiInfo.getSSID());
                    Log.d((String)XMWiFiConnectManager.TAG, (String)("state  :" + info.toString()));
                    Log.d((String)XMWiFiConnectManager.TAG, (String)("state  :" + wifiInfo.getSSID()));
                }
            } else if (intent.getAction() == "android.net.wifi.STATE_CHANGE") {
                if (null != XMWiFiConnectManager.this.wifiStateLs && null != XMWiFiConnectManager.this.wifiManager) {
                    WifiInfo wifiInfo = XMWiFiConnectManager.this.wifiManager.getWifiInfo();
                    if (null == wifiInfo) {
                        return;
                    }
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    XMWiFiConnectManager.this.wifiStateLs.onNetWorkChange(info.getDetailedState(), info.getType(), wifiInfo.getSSID());
                }
            } else if (intent.getAction() == "android.net.wifi.WIFI_STATE_CHANGED") {
                int wifiState = intent.getIntExtra("wifi_state", 0);
                if (XMWiFiConnectManager.this.wifiStateLs != null) {
                    XMWiFiConnectManager.this.wifiStateLs.onIsWiFiAvailable(wifiState == 3);
                }
            }
        }
    };
    private OnWifiStateListener wifiStateLs;

    public XMWiFiConnectManager(Context context, XMWifiManager wifiManager) {
        this.initData(context, wifiManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData(Context context, final XMWifiManager wifiManager) {
        this.context = context;
        this.wifiManager = wifiManager;
        this.enableWiFi = new HashMap();
        BroadcastReceiver broadcastReceiver = this.wifiConnectReceiver;
        synchronized (broadcastReceiver) {
            if (this.wifiFilter == null) {
                this.wifiFilter = new IntentFilter();
                this.wifiFilter.addAction("android.net.wifi.STATE_CHANGE");
                this.wifiFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
                this.wifiFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
                if (Build.VERSION.SDK_INT >= 33) {
                    context.registerReceiver(this.wifiConnectReceiver, this.wifiFilter, 2);
                } else {
                    context.registerReceiver(this.wifiConnectReceiver, this.wifiFilter);
                }
            } else {
                this.release();
            }
        }
        BaseThreadPool.getInstance().doTaskBySinglePool(new Thread(){

            @Override
            public void run() {
                wifiManager.startScan(0, 1000);
                List<ScanResult> lists = wifiManager.getWifiList();
                for (ScanResult result : lists) {
                    XMWiFiConnectManager.this.enableWiFi.put(result.SSID, result);
                }
                super.run();
            }
        }, 4);
    }

    public XMWifiManager getWifiManager() {
        return this.wifiManager;
    }

    public void setWifiStateListener(OnWifiStateListener ls) {
        this.wifiStateLs = ls;
    }

    public int getXMDeviceWifiCount() {
        this.wifiManager.startScan(1, 1000);
        List<ScanResult> wifiList = this.wifiManager.getWifiList();
        int count = 0;
        for (int i = 0; i < wifiList.size(); ++i) {
            if (!XMWifiManager.isXMDeviceWifi(wifiList.get((int)i).SSID)) continue;
            ++count;
        }
        return count;
    }

    public int routerToDevAP(String pwd, boolean bScan) {
        int network_state = CheckNetWork.NetWorkUseful(this.context);
        if (network_state == 0 && !this.wifiManager.openWifi()) {
            return -4;
        }
        String router_ssid = this.wifiManager.getSSID();
        if (!XMWifiManager.isXMDeviceWifi(router_ssid)) {
            List<ScanResult> wifiList;
            if (bScan) {
                this.wifiManager.startScan(1, 1000);
            }
            if ((wifiList = this.wifiManager.getWifiList()) != null && wifiList.size() > 0) {
                Collections.sort(wifiList, new Comparator<ScanResult>(){

                    @Override
                    public int compare(ScanResult arg0, ScanResult arg1) {
                        return (arg0.level + "").compareTo(arg1.level + "");
                    }
                });
                this.tryConnectSSID = wifiList.get((int)0).SSID;
                WifiConfiguration wcg = null;
                wcg = StringUtils.isStringNULL(pwd) ? this.wifiManager.createWifiInfo(this.tryConnectSSID, "", 1) : this.wifiManager.createWifiInfo(this.tryConnectSSID, pwd, 3);
                if (null != wcg && this.wifiManager.addNetwork(wcg)) {
                    return 1;
                }
                return 0;
            }
            return -3;
        }
        return -2;
    }

    public int routerToDevAP(String ssid, String pwd, boolean bScan) {
        this.tryConnectSSID = ssid;
        int network_state = CheckNetWork.NetWorkUseful(this.context);
        if (network_state == 0 && !this.wifiManager.openWifi()) {
            return -4;
        }
        String router_ssid = this.wifiManager.getSSID();
        if (!StringUtils.contrast(ssid, router_ssid) && XMWifiManager.isXMDeviceWifi(ssid)) {
            if (this.tryConnectSSID == null) {
                List<ScanResult> wifiList;
                if (bScan) {
                    this.wifiManager.startScan(1, 1000);
                }
                if ((wifiList = this.wifiManager.getWifiList()) != null && wifiList.size() > 0) {
                    Collections.sort(wifiList, new Comparator<ScanResult>(){

                        @Override
                        public int compare(ScanResult arg0, ScanResult arg1) {
                            return (arg0.level + "").compareTo(arg1.level + "");
                        }
                    });
                    this.tryConnectSSID = wifiList.get((int)0).SSID;
                } else {
                    return -3;
                }
            }
            WifiConfiguration wcg = null;
            wcg = StringUtils.isStringNULL(pwd) ? this.wifiManager.createWifiInfo(this.tryConnectSSID, "", 1) : this.wifiManager.createWifiInfo(this.tryConnectSSID, pwd, 3);
            if (this.wifiManager.addNetwork(wcg)) {
                return 1;
            }
            return 0;
        }
        return -2;
    }

    public int connectSSIDNoPwd(String ssid) {
        int network_state = CheckNetWork.NetWorkUseful(this.context);
        if (network_state == 0 && !this.wifiManager.openWifi()) {
            return -4;
        }
        String router_ssid = this.wifiManager.getSSID();
        if (!StringUtils.contrast(ssid, router_ssid)) {
            WifiConfiguration wcg = null;
            wcg = this.wifiManager.createWifiInfoNoUseExsit(ssid, "", 1);
            if (this.wifiManager.addNetwork(wcg)) {
                return 1;
            }
            return 0;
        }
        return 1;
    }

    public boolean devAPToRouter(String ssid, String password, int type) {
        if (ssid == null) {
            return false;
        }
        int network_state = CheckNetWork.NetWorkUseful(this.context);
        if (network_state == 0 && !this.wifiManager.openWifi()) {
            return false;
        }
        String cur_ssid = this.wifiManager.getSSID();
        if (!cur_ssid.equals(ssid)) {
            WifiConfiguration wcg = this.wifiManager.createWifiInfo(ssid, password, type);
            if (this.wifiManager.addNetwork(wcg)) {
                this.wifiManager.removeNetWork(cur_ssid);
                return true;
            }
            this.wifiManager.removeNetWork(cur_ssid);
            return false;
        }
        return false;
    }

    private boolean checkEnable(String ssid) {
        return this.enableWiFi.containsKey(ssid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BroadcastReceiver broadcastReceiver = this.wifiConnectReceiver;
        synchronized (broadcastReceiver) {
            if (this.wifiFilter != null) {
                this.context.unregisterReceiver(this.wifiConnectReceiver);
                this.wifiFilter = null;
            }
        }
    }

    public String getTryConnectSSID() {
        return this.tryConnectSSID;
    }

    public static interface OnWifiStateListener {
        public static final int DISCONNECT = 0;
        public static final int CONNECTING = 1;
        public static final int CONNECTED = 2;

        public void onNetWorkState(NetworkInfo.DetailedState var1, int var2, String var3);

        public void onIsWiFiAvailable(boolean var1);

        public void onNetWorkChange(NetworkInfo.DetailedState var1, int var2, String var3);
    }
}

