/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.utils.RomUtils;
import com.utils.XUtils;
import com.xm.ui.widget.XTitleBar;
import demo.xm.com.libxmfunsdk.R;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtils {
    @TargetApi(value=19)
    public static void transparentStatusBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    @TargetApi(value=19)
    public static void transparentStatusBar(Dialog dialog) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = dialog.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = dialog.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    public static void setStatusBarColor(Activity activity, int colorId) {
        if (activity == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = activity.getWindow();
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(activity.getResources().getColor(colorId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setStatusBarColor(Dialog dialog, int colorId) {
        if (dialog == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                Window window = dialog.getWindow();
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
                window.setStatusBarColor(dialog.getContext().getResources().getColor(colorId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setLightStatusBar(Activity activity, boolean dark) {
        switch (RomUtils.getLightStatusBarAvailableRomType()) {
            case 1: {
                StatusBarUtils.MIUISetStatusBarLightMode(activity, dark);
                break;
            }
            case 2: 
            case 3: {
                StatusBarUtils.setAndroidNativeLightStatusBar(activity, dark);
                break;
            }
        }
    }

    public static void setLightStatusBar(Dialog dialog, boolean dark) {
        switch (RomUtils.getLightStatusBarAvailableRomType()) {
            case 1: {
                StatusBarUtils.MIUISetStatusBarLightMode(dialog, dark);
                break;
            }
            case 2: 
            case 3: {
                StatusBarUtils.setAndroidNativeLightStatusBar(dialog, dark);
                break;
            }
        }
    }

    public static boolean MIUISetStatusBarLightMode(Activity activity, boolean dark) {
        if (activity == null) {
            return false;
        }
        boolean result = false;
        try {
            Window window = activity.getWindow();
            if (window != null) {
                Class<?> clazz = window.getClass();
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
                if (Build.VERSION.SDK_INT >= 23 && RomUtils.isMiUIV7OrAbove()) {
                    if (dark) {
                        activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                    } else {
                        activity.getWindow().getDecorView().setSystemUiVisibility(1280);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean MIUISetStatusBarLightMode(Dialog dialog, boolean dark) {
        if (dialog == null) {
            return false;
        }
        boolean result = false;
        try {
            Window window = dialog.getWindow();
            if (window != null) {
                Class<?> clazz = window.getClass();
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
                if (Build.VERSION.SDK_INT >= 23 && RomUtils.isMiUIV7OrAbove()) {
                    if (dark) {
                        dialog.getWindow().getDecorView().setSystemUiVisibility(9216);
                    } else {
                        dialog.getWindow().getDecorView().setSystemUiVisibility(1280);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean setFlymeLightStatusBar(Activity activity, boolean dark) {
        if (activity == null) {
            return false;
        }
        boolean result = false;
        try {
            if (activity != null) {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                activity.getWindow().setAttributes(lp);
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static boolean setFlymeLightStatusBar(Dialog dialog, boolean dark) {
        if (dialog == null) {
            return false;
        }
        boolean result = false;
        try {
            WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            dialog.getWindow().setAttributes(lp);
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void setAndroidNativeLightStatusBar(Activity activity, boolean dark) {
        if (activity == null) {
            return;
        }
        try {
            View decor = activity.getWindow().getDecorView();
            if (dark) {
                decor.setSystemUiVisibility(9216);
            } else {
                decor.setSystemUiVisibility(1280);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setAndroidNativeLightStatusBar(Dialog dialog, boolean dark) {
        if (dialog == null) {
            return;
        }
        try {
            View decor = dialog.getWindow().getDecorView();
            if (dark) {
                decor.setSystemUiVisibility(9216);
            } else {
                decor.setSystemUiVisibility(1280);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setRootView(Activity activity) {
        try {
            ViewGroup parent = (ViewGroup)activity.findViewById(R.id.xm_root_layout);
            if (parent != null) {
                parent.setFitsSystemWindows(false);
                parent.setClipToPadding(false);
                StatusBarUtils.adapterTitleBar((Context)activity, parent);
            } else {
                parent = (ViewGroup)activity.findViewById(0x1020002);
                if (parent != null) {
                    parent.setFitsSystemWindows(false);
                    parent.setClipToPadding(false);
                    StatusBarUtils.adapterTitleBar((Context)activity, parent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setRootView(ViewGroup rootView) {
        try {
            if (rootView != null) {
                rootView.setFitsSystemWindows(false);
                rootView.setClipToPadding(false);
                StatusBarUtils.adapterTitleBar(rootView.getContext(), rootView);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean adapterTitleBar(Context context, ViewGroup viewGroup) {
        if (Build.VERSION.SDK_INT < 23) {
            return false;
        }
        int childCount = viewGroup.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            boolean isOk;
            View child = viewGroup.getChildAt(i);
            if (child instanceof FrameLayout) {
                return false;
            }
            if (child instanceof XTitleBar) {
                if (i == 0) {
                    child.setPadding(0, XUtils.getStatusBarHeight(context), 0, 0);
                } else {
                    viewGroup.setPadding(0, XUtils.getStatusBarHeight(context), 0, 0);
                }
                return true;
            }
            if (!(child instanceof ViewGroup) || !(isOk = StatusBarUtils.adapterTitleBar(context, (ViewGroup)child))) continue;
            return true;
        }
        return false;
    }
}

