/*
 * Decompiled with CFR 0.152.
 */
package com.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import demo.xm.com.libxmfunsdk.R;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetworkCheckManager {
    private static final String TAG = NetworkCheckManager.class.getSimpleName();
    private static final int TYPE_NONE = 0;
    private static final int TYPE_WIFI = 1;
    private static final int TYPE_CELLULAR = 2;
    private volatile boolean wifiAvailable = false;
    private volatile boolean cellularAvailable = false;
    private final ConnectivityManager cm;
    private final Context context;
    private final ConnectivityManager.NetworkCallback wifiCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            NetworkCheckManager.this.wifiAvailable = true;
        }

        public void onLost(@NonNull Network network) {
            NetworkCheckManager.this.wifiAvailable = false;
        }
    };
    private final ConnectivityManager.NetworkCallback cellularCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(@NonNull Network network) {
            super.onAvailable(network);
            NetworkCheckManager.this.cellularAvailable = true;
        }

        public void onLost(@NonNull Network network) {
            super.onLost(network);
            NetworkCheckManager.this.cellularAvailable = false;
        }
    };
    private static NetworkCheckManager instance;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private CountDownTimer timer;
    private volatile int pingState = -200;
    private volatile boolean isPing = false;
    private volatile int quality = 0;
    ExecutorService executor = Executors.newSingleThreadExecutor();

    private NetworkCheckManager(Context context) {
        this.context = context.getApplicationContext();
        this.cm = (ConnectivityManager)ContextCompat.getSystemService((Context)context, ConnectivityManager.class);
        this.registerNetworkCallback();
    }

    public static synchronized NetworkCheckManager getInstance(Context context) {
        if (instance == null) {
            instance = new NetworkCheckManager(context);
        }
        return instance;
    }

    public void checkNetworkNow(NetworkCallbackNow callback) {
        this.checkNetworkNow("www.baidu.com", 5, callback);
    }

    public void checkNetworkNow(int timeout, NetworkCallbackNow callback) {
        this.checkNetworkNow("www.baidu.com", timeout, callback);
    }

    public void checkNetworkNow(String ip, NetworkCallbackNow callback) {
        this.checkNetworkNow(ip, 5, callback);
    }

    public void checkNetworkNow(String ip, int timeout, NetworkCallbackNow callback) {
        this.executor.execute(new PingRunnable(ip, timeout, (state, time) -> {
            NetworkResult result = new NetworkResult();
            result.setAvailable(state == 0);
            if (state == 0) {
                if (time <= 3000L) {
                    result.setQuality(0);
                } else if ((double)time <= (double)(timeout * 1000) * 0.8) {
                    result.setQuality(1);
                } else {
                    result.setQuality(2);
                }
            } else {
                result.setQuality(3);
            }
            this.handler.post(() -> callback.onResult(result));
        }));
    }

    public void checkNetwork(NetworkCallback callback) {
        this.checkNetwork("www.baidu.com", 30, callback);
    }

    public void checkNetwork(String ip, NetworkCallback callback) {
        this.checkNetwork(ip, 30, callback);
    }

    public void checkNetwork(int timeout, NetworkCallback callback) {
        this.checkNetwork("www.baidu.com", timeout, callback);
    }

    public void checkNetwork(final String ip, final int timeout, final NetworkCallback callback) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new CountDownTimer((long)timeout * 1000L, 1000L){

            public void onTick(long millisUntilFinished) {
                NetworkCheckManager.this.checkAvailable(ip, timeout, callback);
                callback.onProgress(100 - (int)((long)(100 / timeout) * (millisUntilFinished / 1000L)));
            }

            public void onFinish() {
                NetworkCheckManager.this.release();
            }
        };
        this.timer.start();
    }

    public void release() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private void checkAvailable(String ip, int timeout, NetworkCallback callback) {
        NetworkResult result = new NetworkResult();
        if (!this.wifiAvailable && !this.cellularAvailable) {
            result.setAvailable(false);
            result.setConnectivity(false);
            result.setNetworkCapability(0);
            this.pingState = -200;
        } else if (this.wifiAvailable && !this.cellularAvailable) {
            result.setAvailable(false);
            result.setConnectivity(true);
            result.setNetworkCapability(1);
        } else if (!this.wifiAvailable && this.cellularAvailable) {
            result.setAvailable(false);
            result.setConnectivity(true);
            result.setNetworkCapability(2);
        }
        this.ping(ip, timeout);
        if (this.pingState == 0) {
            result.setQuality(this.quality);
            if (this.quality == 0) {
                result.setReason(this.context.getString(R.string.libfunsdk_network_connect_nice));
            } else if (this.quality == 1) {
                result.setReason(this.context.getString(R.string.libfunsdk_network_connect_low));
            } else {
                result.setReason(this.context.getString(R.string.libfunsdk_network_connect_poor));
            }
            result.setAvailable(true);
        } else {
            result.setAvailable(false);
            result.setQuality(3);
            result.setReason(this.context.getString(R.string.libfunsdk_network_connect_non));
        }
        callback.onResult(result);
    }

    private void registerNetworkCallback() {
        Log.e((String)TAG, (String)"registerNetworkCallback ");
        NetworkRequest wifiRequest = new NetworkRequest.Builder().addTransportType(1).build();
        this.cm.registerNetworkCallback(wifiRequest, this.wifiCallback);
        NetworkRequest phoneRequest = new NetworkRequest.Builder().addTransportType(0).build();
        this.cm.registerNetworkCallback(phoneRequest, this.cellularCallback);
    }

    private void ping(String ip, int timeout) {
        if (!this.isPing) {
            this.isPing = true;
            this.executor.execute(new PingRunnable(ip, timeout, (state, time) -> {
                Class<NetworkCheckManager> clazz = NetworkCheckManager.class;
                synchronized (NetworkCheckManager.class) {
                    this.pingState = state;
                    Log.d((String)TAG, (String)("Ping state-->" + state + " Ping time-->" + time + " Thread-->" + Thread.currentThread().getName()));
                    this.isPing = false;
                    // ** MonitorExit[var5_4] (shouldn't be in output)
                    this.quality = time <= 3000L ? 0 : ((double)time <= (double)(timeout * 1000) * 0.6 ? 1 : ((double)time > (double)(timeout * 1000) * 0.6 && time <= (long)timeout * 1000L ? 2 : 3));
                    return;
                }
            }));
        } else {
            Log.d((String)TAG, (String)"has ping , leave");
        }
    }

    public static class NetworkResult {
        public static final int QUALITY_NICE = 0;
        public static final int QUALITY_LOW = 1;
        public static final int QUALITY_POOR = 2;
        public static final int QUALITY_LOOSE = 3;
        private int quality;
        private boolean isAvailable;
        private boolean isConnectivity;
        private int networkCapability;
        private String reason;

        public boolean isAvailable() {
            return this.isAvailable;
        }

        public void setAvailable(boolean available) {
            this.isAvailable = available;
        }

        public int getNetworkCapability() {
            return this.networkCapability;
        }

        public void setNetworkCapability(int networkCapability) {
            this.networkCapability = networkCapability;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public boolean isConnectivity() {
            return this.isConnectivity;
        }

        public void setConnectivity(boolean connectivity) {
            this.isConnectivity = connectivity;
        }

        public int getQuality() {
            return this.quality;
        }

        public void setQuality(int quality) {
            this.quality = quality;
        }
    }

    public static abstract class NetworkCallbackNow
    implements NetworkCallback {
        @Override
        public void onProgress(int progress) {
        }
    }

    public static interface NetworkCallback {
        public void onProgress(int var1);

        public void onResult(NetworkResult var1);
    }

    static interface PingCallback {
        public void notice(int var1, long var2);
    }

    static class PingRunnable
    implements Runnable {
        private final String ip;
        private final int timeout;
        private final PingCallback callback;

        public PingRunnable(String ip, int timeout, PingCallback callback) {
            this.ip = ip;
            this.timeout = timeout;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                String content;
                long startTime = System.currentTimeMillis();
                Log.d((String)TAG, (String)"start ping----");
                Process p = Runtime.getRuntime().exec("ping -c 4 -w " + this.timeout + " " + this.ip);
                InputStream input = p.getInputStream();
                BufferedReader in = new BufferedReader(new InputStreamReader(input));
                StringBuilder stringBuffer = new StringBuilder();
                while ((content = in.readLine()) != null) {
                    stringBuffer.append(content);
                }
                Log.d((String)TAG, (String)("result content : " + stringBuffer));
                long pingTime = System.currentTimeMillis() - startTime;
                Log.e((String)TAG, (String)(" End Ping time" + pingTime));
                this.callback.notice(p.waitFor(), pingTime);
            }
            catch (Exception ignored) {
                this.callback.notice(-200, 0L);
            }
        }
    }
}

