/*
 * Decompiled with CFR 0.152.
 */
package com.manager.websocket;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.manager.websocket.WebSocketInfo;
import com.utils.LogUtils;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;

public class XMWebSocketManager {
    private Context context;
    private boolean isPrintLog;
    private String url;
    private WebSocketInfo webSocketInfo;
    private OkHttpClient client;
    private SSLSocketFactory sslSocketFactory;
    private X509TrustManager trustManager;
    private WebSocket webSocket;
    private static XMWebSocketManager xmWebSocketManager;
    private HashMap<Object, XMWebSocketListener> xmWebSocketListenerHashMap;

    private XMWebSocketManager(Context context) {
        this.context = context;
    }

    public static XMWebSocketManager getInstance(Context context) {
        if (xmWebSocketManager == null) {
            xmWebSocketManager = new XMWebSocketManager(context);
        }
        return xmWebSocketManager;
    }

    public void setClient(OkHttpClient client) {
        this.client = client;
    }

    public void setPrintLog(boolean isPrintLog) {
        this.isPrintLog = isPrintLog;
    }

    public void connectWebSocket(String url) {
        if (this.client == null) {
            throw new NullPointerException("client null");
        }
        if (url == null) {
            throw new NullPointerException("url null");
        }
        this.url = url;
        if (this.webSocket == null) {
            this.webSocketInfo = new WebSocketInfo();
            this.webSocket = this.client.newWebSocket(this.createRequest(url), new WebSocketListener(){

                public void onOpen(WebSocket webSocket, Response response) {
                    super.onOpen(webSocket, response);
                    XMWebSocketManager.this.dealWithWebSocketCallback(XMWebSocketManager.this.createConnect());
                    XMWebSocketManager.this.printLog("WebSocket\u8fde\u63a5\u6210\u529f");
                }

                public void onMessage(WebSocket webSocket, String text) {
                    super.onMessage(webSocket, text);
                    XMWebSocketManager.this.dealWithWebSocketCallback(XMWebSocketManager.this.createReceiveStringMsg(text));
                    XMWebSocketManager.this.printLog("\u63a5\u6536\u6570\u636e:" + text);
                }

                public void onMessage(WebSocket webSocket, ByteString bytes) {
                    super.onMessage(webSocket, bytes);
                    XMWebSocketManager.this.dealWithWebSocketCallback(XMWebSocketManager.this.createReceiveByteStringMsg(bytes));
                }

                public void onClosed(WebSocket webSocket, int code, String reason) {
                    super.onClosed(webSocket, code, reason);
                    XMWebSocketManager.this.dealWithWebSocketCallback(XMWebSocketManager.this.createClose());
                    XMWebSocketManager.this.printLog("WebSocket\u88ab\u5173\u95ed\u4e86");
                }

                public void onFailure(WebSocket webSocket, Throwable throwable, Response response) {
                    super.onFailure(webSocket, throwable, response);
                    XMWebSocketManager.this.closeWebSocket();
                    XMWebSocketManager.this.dealWithWebSocketCallback(XMWebSocketManager.this.createPrepareReconnect());
                    if (response != null) {
                        XMWebSocketManager.this.printLog("WebSocket\u8bbf\u95ee\u5931\u8d25:[" + throwable.getMessage() + "][" + response.message() + "]");
                    } else {
                        XMWebSocketManager.this.printLog("WebSocket\u8bbf\u95ee\u5931\u8d25:[" + throwable.getMessage() + "]");
                    }
                }
            });
        } else {
            this.dealWithWebSocketCallback(this.createConnect());
        }
    }

    public void closeWebSocket() {
        if (this.webSocket != null) {
            this.webSocket.close(1000, "userClose");
            this.webSocket.cancel();
        }
        this.webSocket = null;
    }

    public boolean isWebSocketConnected() {
        return this.webSocket != null;
    }

    public boolean sendData(String msg) {
        if (this.webSocket == null) {
            return false;
        }
        return this.webSocket.send(msg);
    }

    private Request createRequest(String url) {
        return new Request.Builder().get().url(url).build();
    }

    private WebSocketInfo createConnect() {
        if (this.webSocketInfo == null) {
            this.webSocketInfo = new WebSocketInfo();
        }
        this.webSocketInfo.setWebSocket(this.webSocket).setConnect(true).setState(1);
        return this.webSocketInfo;
    }

    private WebSocketInfo createReconnect() {
        if (this.webSocketInfo == null) {
            this.webSocketInfo = new WebSocketInfo();
        }
        this.webSocketInfo.setWebSocket(this.webSocket).setReconnect(true).setConnect(true).setState(2);
        return this.webSocketInfo;
    }

    private WebSocketInfo createPrepareReconnect() {
        if (this.webSocketInfo == null) {
            this.webSocketInfo = new WebSocketInfo();
        }
        this.webSocketInfo.setWebSocket(this.webSocket).setPrepareReconnect(true).setConnect(false).setState(3);
        return this.webSocketInfo;
    }

    private WebSocketInfo createReceiveStringMsg(String stringMsg) {
        WebSocketInfo webSocketInfo = new WebSocketInfo();
        webSocketInfo.setWebSocket(this.webSocket).setConnect(true).setStrMsg(stringMsg).setState(4);
        return webSocketInfo;
    }

    private WebSocketInfo createReceiveByteStringMsg(ByteString byteMsg) {
        WebSocketInfo webSocketInfo = new WebSocketInfo();
        webSocketInfo.setWebSocket(this.webSocket).setConnect(true).setByteMsg(byteMsg).setState(4);
        return webSocketInfo;
    }

    private WebSocketInfo createClose() {
        if (this.webSocketInfo == null) {
            this.webSocketInfo = new WebSocketInfo();
        }
        this.webSocketInfo.setState(0).setConnect(false);
        return this.webSocketInfo;
    }

    private void printLog(String log) {
        if (this.isPrintLog) {
            LogUtils.debugInfo("[APP_WEB_SOCKET]->", log);
        }
    }

    public void release() {
        if (this.xmWebSocketListenerHashMap != null) {
            this.xmWebSocketListenerHashMap.clear();
            this.xmWebSocketListenerHashMap = null;
        }
        this.closeWebSocket();
        this.client = null;
        this.webSocketInfo = null;
        xmWebSocketManager = null;
    }

    public void addXMWebSocketListener(XMWebSocketListener xmWebSocketListener) {
        if (xmWebSocketListener == null) {
            return;
        }
        if (this.xmWebSocketListenerHashMap == null) {
            this.xmWebSocketListenerHashMap = new HashMap();
        }
        this.xmWebSocketListenerHashMap.put(xmWebSocketListener.hashCode(), xmWebSocketListener);
    }

    private void dealWithWebSocketCallback(final WebSocketInfo webSocketInfo) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (XMWebSocketManager.this.xmWebSocketListenerHashMap != null) {
                    for (Map.Entry entry : XMWebSocketManager.this.xmWebSocketListenerHashMap.entrySet()) {
                        if (entry == null || entry.getValue() == null) continue;
                        ((XMWebSocketListener)entry.getValue()).onWebSocketState(webSocketInfo);
                    }
                }
            }
        });
    }

    public static interface XMWebSocketListener {
        public void onWebSocketState(WebSocketInfo var1);
    }
}

