/*
 * Decompiled with CFR 0.152.
 */
package com.manager.tts;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.manager.tts.serverinteraction.TTSManagerServerInteraction;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

public class TTSManager {
    private static final String MATCH_SPECIAL_CHARACTER = "[`~!@#$%^&*()+=|{}':;',\\\\[\\\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
    private TTSManagerServerInteraction ttsManagerServerInteraction;
    private OnTTSManagerListener listener;

    public TTSManager(@NonNull OnTTSManagerListener listener) {
        this.listener = listener;
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://tts.xmcsrv.net/").build();
        this.ttsManagerServerInteraction = (TTSManagerServerInteraction)retrofit.create(TTSManagerServerInteraction.class);
    }

    public boolean textToAudio(String content, VOICE_TYPE voiceType) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        content = this.filterSpecialCharacter(content);
        String voice = voiceType == VOICE_TYPE.Female ? "female" : "male";
        try {
            Call<ResponseBody> call = this.ttsManagerServerInteraction.textToAudio(content, voice);
            call.enqueue((Callback)new Callback<ResponseBody>(){

                public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                    if (response == null) {
                        TTSManager.this.listener.onTTSResult(-1, null, 0);
                        return;
                    }
                    if (response.code() != 200) {
                        TTSManager.this.listener.onTTSResult(-1, null, 0);
                        return;
                    }
                    ResponseBody responseBody = (ResponseBody)response.body();
                    if (responseBody == null) {
                        TTSManager.this.listener.onTTSResult(-1, null, 0);
                        return;
                    }
                    try {
                        byte[] data = responseBody.bytes();
                        int dataSize = data != null ? data.length : 0;
                        TTSManager.this.listener.onTTSResult(0, data, dataSize);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }

                public void onFailure(Call<ResponseBody> call, Throwable t) {
                    TTSManager.this.listener.onTTSResult(-1, null, 0);
                }
            });
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private String filterSpecialCharacter(String str) {
        try {
            Pattern pattern = Pattern.compile(MATCH_SPECIAL_CHARACTER);
            Matcher matcher = pattern.matcher(str);
            return matcher.replaceAll("").trim();
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static interface OnTTSManagerListener {
        public void onTTSResult(int var1, byte[] var2, int var3);
    }

    public static enum VOICE_TYPE {
        Male,
        Female;

    }
}

