/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.playback;

import android.graphics.Bitmap;
import android.os.Message;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.H264_DVR_FILE_DATA;
import com.lib.sdk.struct.H264_DVR_FINDINFO;
import com.lib.sdk.struct.SDK_SearchByTime;
import com.lib.sdk.struct.SDK_SearchByTimeResult;
import com.manager.device.media.MediaManager;
import com.manager.device.media.attribute.RecordPlayerAttribute;
import com.manager.device.media.playback.RecordManager;
import com.manager.image.BaseImageManager;
import com.manager.image.DevImageManager;
import com.utils.TimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class DevRecordManager
extends RecordManager {
    private H264_DVR_FINDINFO fileInfo = new H264_DVR_FINDINFO();
    private List<H264_DVR_FILE_DATA> fileDataList;
    private DevImageManager devImageManager;

    public DevRecordManager(ViewGroup playView, RecordPlayerAttribute playerAttribute) {
        super(playView, playerAttribute);
        this.fileInfo.st_0_nChannelN0 = playerAttribute.getChnnel();
        this.fileInfo.st_1_nFileType = playerAttribute.getFileType();
        this.fileInfo.st_6_StreamType = playerAttribute.getStreamType();
    }

    public void setRecordFileType(int recordFileType) {
        if (this.fileInfo != null) {
            this.fileInfo.st_1_nFileType = recordFileType;
        }
    }

    @Override
    public int searchFile() {
        if (!this.isSearching) {
            if (this.fileDataList != null) {
                this.fileDataList.clear();
            }
            this.stopDevSearchPic();
            int iret = FunSDK.DevFindFile((int)this.userId, (String)this.getDevId(), (byte[])G.ObjToBytes((Object)this.fileInfo), (int)2000, (int)10000, (int)0);
            this.isSearching = true;
            return iret;
        }
        return 0;
    }

    @Override
    public int searchFileByTime(int[] time) {
        this.fileInfo.st_3_endTime.st_0_dwYear = this.fileInfo.st_2_startTime.st_0_dwYear = time[0];
        this.fileInfo.st_3_endTime.st_1_dwMonth = this.fileInfo.st_2_startTime.st_1_dwMonth = time[1];
        this.fileInfo.st_3_endTime.st_2_dwDay = this.fileInfo.st_2_startTime.st_2_dwDay = time[2];
        SDK_SearchByTime search_info = new SDK_SearchByTime();
        search_info.st_6_nHighStreamType = 0;
        search_info.st_7_nLowStreamType = this.fileInfo.st_6_StreamType;
        if (this.fileInfo.st_0_nChannelN0 < 32) {
            search_info.st_1_nLowChannel = 1 << this.fileInfo.st_0_nChannelN0;
        } else {
            search_info.st_0_nHighChannel = 1 << this.fileInfo.st_0_nChannelN0 - 32;
        }
        search_info.st_2_nFileType = this.fileInfo.st_1_nFileType;
        search_info.st_3_stBeginTime.st_0_year = time[0];
        search_info.st_3_stBeginTime.st_1_month = time[1];
        search_info.st_3_stBeginTime.st_2_day = time[2];
        if (time.length > 3) {
            search_info.st_3_stBeginTime.st_4_hour = time[3];
            search_info.st_3_stBeginTime.st_5_minute = time[4];
            search_info.st_3_stBeginTime.st_6_second = time[5];
        } else {
            search_info.st_3_stBeginTime.st_4_hour = 0;
            search_info.st_3_stBeginTime.st_5_minute = 0;
            search_info.st_3_stBeginTime.st_6_second = 0;
        }
        search_info.st_4_stEndTime.st_0_year = time[0];
        search_info.st_4_stEndTime.st_1_month = time[1];
        search_info.st_4_stEndTime.st_2_day = time[2];
        search_info.st_4_stEndTime.st_4_hour = 23;
        search_info.st_4_stEndTime.st_5_minute = 59;
        search_info.st_4_stEndTime.st_6_second = 59;
        FunSDK.DevFindFileByTime((int)this.userId, (String)this.getDevId(), (byte[])G.ObjToBytes((Object)search_info), (int)10000, (int)0);
        return 0;
    }

    @Override
    public int searchFileByTime(@NonNull Calendar startTime, @NonNull Calendar endTime) {
        return this.searchFileByTime(startTime, endTime, 2000);
    }

    public int searchFileByTime(@NonNull Calendar startTime, @NonNull Calendar endTime, int searchMaxFileNum) {
        if (this.fileDataList != null) {
            this.fileDataList.clear();
        }
        int[] begin = new int[]{startTime.get(1), startTime.get(2) + 1, startTime.get(5), startTime.get(11), startTime.get(12), startTime.get(13)};
        int[] end = new int[]{endTime.get(1), endTime.get(2) + 1, endTime.get(5), endTime.get(11), endTime.get(12), endTime.get(13)};
        this.fileInfo.st_2_startTime.st_0_dwYear = begin[0];
        this.fileInfo.st_2_startTime.st_1_dwMonth = begin[1];
        this.fileInfo.st_2_startTime.st_2_dwDay = begin[2];
        this.fileInfo.st_2_startTime.st_3_dwHour = begin[3];
        this.fileInfo.st_2_startTime.st_4_dwMinute = begin[4];
        this.fileInfo.st_2_startTime.st_5_dwSecond = begin[5];
        this.fileInfo.st_3_endTime.st_0_dwYear = end[0];
        this.fileInfo.st_3_endTime.st_1_dwMonth = end[1];
        this.fileInfo.st_3_endTime.st_2_dwDay = end[2];
        this.fileInfo.st_3_endTime.st_3_dwHour = end[3];
        this.fileInfo.st_3_endTime.st_4_dwMinute = end[4];
        this.fileInfo.st_3_endTime.st_5_dwSecond = end[5];
        int ret = FunSDK.DevFindFile((int)this.userId, (String)this.getDevId(), (byte[])G.ObjToBytes((Object)this.fileInfo), (int)searchMaxFileNum, (int)10000, (int)0);
        return ret;
    }

    @Override
    public MediaManager setChnId(int chnId) {
        this.fileInfo.st_0_nChannelN0 = chnId;
        return super.setChnId(chnId);
    }

    @Override
    public int startPlay(Calendar startTimes, Calendar endTimes) {
        if (startTimes == null || endTimes == null) {
            return 0;
        }
        super.start();
        int[] sTime = new int[]{startTimes.get(1), startTimes.get(2) + 1, startTimes.get(5), startTimes.get(11), startTimes.get(12), startTimes.get(13)};
        int[] eTime = new int[]{endTimes.get(1), endTimes.get(2) + 1, endTimes.get(5), endTimes.get(11), endTimes.get(12), endTimes.get(13)};
        this.fileInfo.st_2_startTime.st_0_dwYear = sTime[0];
        this.fileInfo.st_2_startTime.st_1_dwMonth = sTime[1];
        this.fileInfo.st_2_startTime.st_2_dwDay = sTime[2];
        this.fileInfo.st_2_startTime.st_3_dwHour = sTime[3];
        this.fileInfo.st_2_startTime.st_4_dwMinute = sTime[4];
        this.fileInfo.st_2_startTime.st_5_dwSecond = sTime[5];
        this.fileInfo.st_3_endTime.st_0_dwYear = sTime[0];
        this.fileInfo.st_3_endTime.st_1_dwMonth = sTime[1];
        this.fileInfo.st_3_endTime.st_2_dwDay = sTime[2];
        this.fileInfo.st_3_endTime.st_3_dwHour = eTime[3];
        this.fileInfo.st_3_endTime.st_4_dwMinute = eTime[4];
        this.fileInfo.st_3_endTime.st_5_dwSecond = eTime[5];
        this.fileInfo.st_6_StreamType = ((RecordPlayerAttribute)this.playerAttribute).getStreamType();
        int lPlayHandle = FunSDK.MediaNetRecordPlayByTime((int)this.userId, (String)this.getDevId(), (byte[])G.ObjToBytes((Object)this.fileInfo), (Object)this.surfaceView, (int)0);
        if (this.playMode == 1) {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)this.userId);
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10014, (int)this.userId);
        } else if (this.playMode == 2) {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10016, (int)this.userId);
        } else {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)this.userId);
        }
        FunSDK.SetIntAttr((int)lPlayHandle, (int)10012, (int)100);
        ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(lPlayHandle);
        this.setPlayState(7);
        return 0;
    }

    @Override
    public int seekToTime(int nTimes, int absTime) {
        super.start();
        if (((RecordPlayerAttribute)this.playerAttribute).getPlayHandle() == 0) {
            this.fileInfo.st_2_startTime.st_3_dwHour = nTimes / 3600;
            this.fileInfo.st_2_startTime.st_4_dwMinute = nTimes % 3600 / 60;
            this.fileInfo.st_2_startTime.st_5_dwSecond = nTimes % 3600 % 60;
            this.fileInfo.st_3_endTime.st_3_dwHour = 23;
            this.fileInfo.st_3_endTime.st_4_dwMinute = 59;
            this.fileInfo.st_3_endTime.st_5_dwSecond = 59;
            this.fileInfo.st_6_StreamType = ((RecordPlayerAttribute)this.playerAttribute).getStreamType();
            int lPlayHandle = FunSDK.MediaNetRecordPlayByTime((int)this.userId, (String)this.getDevId(), (byte[])G.ObjToBytes((Object)this.fileInfo), (Object)this.surfaceView, (int)0);
            if (this.playMode == 1) {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)this.userId);
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10014, (int)this.userId);
            } else if (this.playMode == 2) {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10016, (int)this.userId);
            } else {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)this.userId);
            }
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10012, (int)100);
            ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(lPlayHandle);
            this.setPlayState(7);
        } else {
            this.stopRecord();
            this.setPlaySpeed(0);
            FunSDK.MediaSeekToTime((int)((RecordPlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0, (int)absTime, (int)0);
            this.setPlayState(17);
        }
        return 0;
    }

    @Override
    public byte[] getRecordTimes(int arg1, byte[] pData, String dataJson, int chnNum) {
        if (null == pData) {
            return null;
        }
        SDK_SearchByTimeResult info = new SDK_SearchByTimeResult();
        G.BytesToObj((Object)info, (byte[])pData);
        return info.st_1_ByTimeInfo[0].st_1_cRecordBitMap;
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 5101: {
                boolean hasRecords = false;
                if (msg.arg1 >= 0) {
                    int i;
                    if (this.fileDataList == null) {
                        this.fileDataList = new ArrayList<H264_DVR_FILE_DATA>();
                    }
                    this.fileDataList.clear();
                    Object[] datas = new H264_DVR_FILE_DATA[msg.arg1];
                    for (i = 0; i < datas.length; ++i) {
                        datas[i] = new H264_DVR_FILE_DATA();
                    }
                    G.BytesToObj((Object[])datas, (byte[])ex.pData);
                    for (i = 0; i < datas.length; ++i) {
                        hasRecords = true;
                        this.fileDataList.add((H264_DVR_FILE_DATA)datas[i]);
                    }
                    if (null == this.mediaManagerLs) break;
                    ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).searchResult(this.playerAttribute, hasRecords ? datas : null);
                    break;
                }
                if (null == this.mediaManagerLs) break;
                ((MediaManager.OnRecordManagerListener)this.mediaManagerLs).searchResult(this.playerAttribute, null);
            }
        }
        return super.OnFunSDKResult(msg, ex);
    }

    public List<H264_DVR_FILE_DATA> getFileDataList() {
        return this.fileDataList;
    }

    public H264_DVR_FILE_DATA getContain(String time) {
        if (StringUtils.isStringNULL(time) || this.fileDataList == null || this.fileDataList.isEmpty()) {
            return null;
        }
        Calendar searchCalendar = TimeUtils.getNormalFormatCalender((String)time);
        long searchTime = searchCalendar.getTimeInMillis() / 1000L;
        for (H264_DVR_FILE_DATA info : this.fileDataList) {
            if (info == null) continue;
            long sTime = info.getLongStartTime();
            long eTime = info.getLongEndTime();
            if (searchTime < sTime || searchTime > eTime) continue;
            return info;
        }
        return this.fileDataList.get(0);
    }

    @Override
    public void initVideoThumb(String videoThumbPath, String devId, BaseImageManager.OnImageManagerListener onDevImageListener) {
        this.devImageManager = new DevImageManager(videoThumbPath);
        this.devImageManager.setOnImageManagerListener(onDevImageListener);
        this.devImageManager.setDevId(devId);
    }

    public void downloadVideoThumb(H264_DVR_FILE_DATA info, int seq) {
        if (info == null) {
            return;
        }
        this.devImageManager.downloadVideoThumb(info, seq, 160, 90);
    }

    public Bitmap getLocalVideoThumb(H264_DVR_FILE_DATA info) {
        if (info == null) {
            return null;
        }
        if (this.devImageManager != null) {
            return this.devImageManager.getPicBitmap(info, true);
        }
        return null;
    }
}

