/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.playback;

import android.graphics.Bitmap;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.lib.FunSDK;
import com.lib.cloud.CloudDirectory;
import com.lib.sdk.bean.alarm.AlarmInfo;
import com.lib.sdk.bean.cloudmedia.CloudMediaFileInfoBean;
import com.lib.sdk.bean.cloudmedia.CloudMediaFilesBean;
import com.manager.device.media.MediaManager;
import com.manager.device.media.attribute.RecordPlayerAttribute;
import com.manager.device.media.playback.RecordManager;
import com.manager.image.BaseImageManager;
import com.manager.image.CloudImageManager;
import java.util.Calendar;
import java.util.List;

public class CloudRecordManager
extends RecordManager {
    private CloudMediaFilesBean cloudMediaFiles = new CloudMediaFilesBean(Calendar.getInstance());
    private String shortRecordType = "MSG_SHORT_VIDEO_QUERY_REQ";
    private CloudImageManager cloudImageManager;

    public CloudRecordManager(ViewGroup playView, RecordPlayerAttribute playerAttribute) {
        super(playView, playerAttribute);
    }

    @Override
    public int searchFile() {
        return 0;
    }

    @Override
    public int searchFileByTime(@NonNull int[] time) {
        this.cloudMediaFiles.clearData();
        int[] begin = new int[]{time[0], time[1], time[2], 0, 0, 0};
        int[] end = new int[]{time[0], time[1], time[2], 23, 59, 59};
        int ret = CloudDirectory.SearchMediaByTime((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)"", (int)FunSDK.ToTimeType((int[])begin), (int)FunSDK.ToTimeType((int[])end), (int)0);
        return ret;
    }

    public int searchFileByTime(@NonNull int[] startTime, @NonNull int[] endTime) {
        this.cloudMediaFiles.clearData();
        int ret = CloudDirectory.SearchMediaByTime((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)"", (int)FunSDK.ToTimeType((int[])startTime), (int)FunSDK.ToTimeType((int[])endTime), (int)0);
        return ret;
    }

    @Override
    public int searchFileByTime(@NonNull Calendar startTime, @NonNull Calendar endTime) {
        this.cloudMediaFiles.clearData();
        int[] begin = new int[]{startTime.get(1), startTime.get(2) + 1, startTime.get(5), startTime.get(11), startTime.get(12), startTime.get(13)};
        int[] end = new int[]{endTime.get(1), endTime.get(2) + 1, endTime.get(5), endTime.get(11), endTime.get(12), endTime.get(13)};
        int ret = 0;
        ret = ((RecordPlayerAttribute)this.playerAttribute).getRecordLenType() == RecordPlayerAttribute.RECORD_LEN_TYPE.RECORD_LEN_SHORT ? CloudDirectory.SearchMediaByTimeV2((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)"", (int)FunSDK.ToTimeType((int[])begin), (int)FunSDK.ToTimeType((int[])end), (String)this.shortRecordType, (int)0, (int)0) : CloudDirectory.SearchMediaByTime((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)"", (int)FunSDK.ToTimeType((int[])begin), (int)FunSDK.ToTimeType((int[])end), (int)0);
        this.cloudMediaFiles.chnId = ((RecordPlayerAttribute)this.playerAttribute).getChnnel();
        return ret;
    }

    public void setRecordLenType(RecordPlayerAttribute.RECORD_LEN_TYPE recordLenType) {
        if (this.playerAttribute != null) {
            ((RecordPlayerAttribute)this.playerAttribute).setRecordLenType(recordLenType);
        }
    }

    @Override
    public void setDevId(String devId) {
        super.setDevId(devId);
    }

    @Override
    public MediaManager setChnId(int chnId) {
        return super.setChnId(chnId);
    }

    @Override
    public int seekToTime(int nTimes, int absTime) {
        super.start();
        if (((RecordPlayerAttribute)this.playerAttribute).getPlayHandle() == 0) {
            Calendar calendar = this.cloudMediaFiles.getSearchCalendar();
            int[] time = new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5), 23, 59, 59};
            int endTimes = FunSDK.ToTimeType((int[])time);
            int lPlayHandle = 0;
            lPlayHandle = ((RecordPlayerAttribute)this.playerAttribute).getRecordLenType() == RecordPlayerAttribute.RECORD_LEN_TYPE.RECORD_LEN_SHORT ? FunSDK.MediaCloudRecordPlayV2((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)(((RecordPlayerAttribute)this.playerAttribute).getStreamType() == 0 ? "Main" : "Sub"), (int)absTime, (int)endTimes, (String)this.shortRecordType, (int)1, (Object)this.surfaceView, (int)0) : FunSDK.MediaCloudRecordPlay((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)(((RecordPlayerAttribute)this.playerAttribute).getStreamType() == 0 ? "Main" : "Sub"), (int)absTime, (int)endTimes, (Object)this.surfaceView, (int)0);
            if (this.playMode == 1) {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)0);
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10014, (int)1);
            } else if (lPlayHandle == 2) {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10016, (int)1);
            } else {
                FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)1);
            }
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10012, (int)100);
            ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(lPlayHandle);
            FunSDK.MediaSetSound((int)lPlayHandle, (int)(((RecordPlayerAttribute)this.playerAttribute).isSound() ? 100 : 0), (int)0);
        } else {
            this.setPlaySpeed(0);
            FunSDK.MediaSeekToTime((int)((RecordPlayerAttribute)this.playerAttribute).getPlayHandle(), (int)0, (int)absTime, (int)0);
        }
        return 0;
    }

    @Override
    public int startPlay(Calendar startTimes, Calendar endTimes) {
        if (startTimes == null || endTimes == null) {
            return 0;
        }
        super.start();
        int[] sTime = new int[]{startTimes.get(1), startTimes.get(2) + 1, startTimes.get(5), startTimes.get(11), startTimes.get(12), startTimes.get(13)};
        int[] eTime = new int[]{endTimes.get(1), endTimes.get(2) + 1, endTimes.get(5), endTimes.get(11), endTimes.get(12), endTimes.get(13)};
        int lPlayHandle = 0;
        lPlayHandle = ((RecordPlayerAttribute)this.playerAttribute).getRecordLenType() == RecordPlayerAttribute.RECORD_LEN_TYPE.RECORD_LEN_SHORT ? FunSDK.MediaCloudRecordPlayV2((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)(((RecordPlayerAttribute)this.playerAttribute).getStreamType() == 0 ? "Main" : "Sub"), (int)FunSDK.ToTimeType((int[])sTime), (int)FunSDK.ToTimeType((int[])eTime), (String)this.shortRecordType, (int)1, (Object)this.surfaceView, (int)0) : FunSDK.MediaCloudRecordPlay((int)this.userId, (String)((RecordPlayerAttribute)this.playerAttribute).getDevId(), (int)((RecordPlayerAttribute)this.playerAttribute).getChnnel(), (String)(((RecordPlayerAttribute)this.playerAttribute).getStreamType() == 0 ? "Main" : "Sub"), (int)FunSDK.ToTimeType((int[])sTime), (int)FunSDK.ToTimeType((int[])eTime), (Object)this.surfaceView, (int)0);
        ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(lPlayHandle);
        if (this.playMode == 1) {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)0);
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10014, (int)1);
        } else if (lPlayHandle == 2) {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10016, (int)1);
        } else {
            FunSDK.SetIntAttr((int)lPlayHandle, (int)10015, (int)1);
        }
        FunSDK.SetIntAttr((int)lPlayHandle, (int)10012, (int)100);
        ((RecordPlayerAttribute)this.playerAttribute).setPlayHandle(lPlayHandle);
        FunSDK.MediaSetSound((int)lPlayHandle, (int)(((RecordPlayerAttribute)this.playerAttribute).isSound() ? 100 : 0), (int)0);
        return 0;
    }

    @Override
    public byte[] getRecordTimes(int arg1, byte[] pData, String dataJson, int chnNum) {
        boolean ret;
        byte[] pRet = null;
        if (null != this.cloudMediaFiles && (ret = this.cloudMediaFiles.parseJson(dataJson)) && this.cloudMediaFiles.getFileNum() > 0) {
            pRet = new byte[720];
            for (CloudMediaFileInfoBean info : this.cloudMediaFiles.getFileList()) {
                long startLong;
                long timeLong = info.getFileTimeLong();
                for (long i = startLong = info.getStartTimes(); i < startLong + timeLong; i += 120L) {
                    int index = (int)(i / 120L);
                    if (i + 120L >= startLong + timeLong) {
                        if (i % 120L < 60L) {
                            int n = index;
                            pRet[n] = (byte)(pRet[n] | 1);
                        } else {
                            int n = index;
                            pRet[n] = (byte)(pRet[n] | 0x11);
                        }
                    } else if (i == startLong) {
                        if (i % 120L < 60L) {
                            int n = index;
                            pRet[n] = (byte)(pRet[n] | 0x11);
                        } else {
                            int n = index;
                            pRet[n] = (byte)(pRet[n] | 0x10);
                        }
                    } else {
                        int n = index;
                        pRet[n] = (byte)(pRet[n] | 0x11);
                    }
                    System.out.println("times:" + info.toString() + "index:" + index + " " + pRet[index]);
                }
            }
        }
        return pRet;
    }

    public long getStartTimes() {
        CloudMediaFileInfoBean cloudMediaFileInfoBean;
        List<CloudMediaFileInfoBean> cloudMediaFileInfoBeans;
        if (null != this.cloudMediaFiles && this.cloudMediaFiles.getFileNum() > 0 && (cloudMediaFileInfoBeans = this.cloudMediaFiles.getFileList()) != null && (cloudMediaFileInfoBean = cloudMediaFileInfoBeans.get(0)) != null) {
            return cloudMediaFileInfoBean.getStartTimes();
        }
        return 0L;
    }

    public long getEndTimes() {
        CloudMediaFileInfoBean cloudMediaFileInfoBean;
        List<CloudMediaFileInfoBean> cloudMediaFileInfoBeans;
        if (null != this.cloudMediaFiles && this.cloudMediaFiles.getFileNum() > 0 && (cloudMediaFileInfoBeans = this.cloudMediaFiles.getFileList()) != null && (cloudMediaFileInfoBean = cloudMediaFileInfoBeans.get(cloudMediaFileInfoBeans.size() - 1)) != null) {
            return cloudMediaFileInfoBean.getEndTimes();
        }
        return 0L;
    }

    public CloudMediaFilesBean getCloudMediaFiles() {
        return this.cloudMediaFiles;
    }

    @Override
    public void initVideoThumb(String videoThumbPath, String devId, BaseImageManager.OnImageManagerListener onCloudImageListener) {
        this.cloudImageManager = new CloudImageManager(videoThumbPath);
        this.cloudImageManager.setOnImageManagerListener(onCloudImageListener);
        this.cloudImageManager.setDevId(devId);
    }

    public void downloadVideoThumb(CloudMediaFileInfoBean cloudMediaFileInfoBean, int seq) {
        if (cloudMediaFileInfoBean != null && this.cloudImageManager != null) {
            this.cloudImageManager.downloadVideoThumb(cloudMediaFileInfoBean, seq, 160, 90);
        }
    }

    public Bitmap getLocalVideoThumb(AlarmInfo info) {
        if (info == null) {
            return null;
        }
        if (this.cloudImageManager != null) {
            return this.cloudImageManager.getPicBitmap(info, true);
        }
        return null;
    }

    public Bitmap getLocalVideoThumb(CloudMediaFileInfoBean info) {
        if (info == null) {
            return null;
        }
        if (this.cloudImageManager != null) {
            return this.cloudImageManager.getPicBitmap(info, true);
        }
        return null;
    }
}

