/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.file;

import android.os.Message;
import androidx.annotation.NonNull;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.cloud.CloudDirectory;
import com.lib.sdk.bean.cloudmedia.CloudMediaFilesBean;
import com.lib.sdk.struct.H264_DVR_FILE_DATA;
import com.manager.base.BaseManager;
import com.manager.db.SearchFileInfo;
import com.manager.device.media.file.FileManagerInterface;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileManager<T>
extends BaseManager
implements IFunSDKResult,
FileManagerInterface {
    private String shortRecordType = "MSG_SHORT_VIDEO_QUERY_REQ";
    private int userId;
    private List<T> fileDataList;
    private OnFileSearchListener listener;

    public FileManager(OnFileSearchListener<T> listener) {
        this.listener = listener;
    }

    @Override
    public boolean init() {
        this.userId = FunSDK.GetId((int)this.userId, (IFunSDKResult)this);
        return false;
    }

    @Override
    public void unInit() {
        if (this.userId != 0) {
            FunSDK.UnRegUser((int)this.userId);
            this.userId = 0;
        }
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 5101: {
                if (msg.arg1 >= 0) {
                    int i;
                    if (this.fileDataList == null) {
                        this.fileDataList = new ArrayList<T>();
                    }
                    this.fileDataList.clear();
                    Object[] datas = new H264_DVR_FILE_DATA[msg.arg1];
                    for (i = 0; i < datas.length; ++i) {
                        datas[i] = new H264_DVR_FILE_DATA();
                    }
                    G.BytesToObj((Object[])datas, (byte[])ex.pData);
                    for (i = 0; i < datas.length; ++i) {
                        this.fileDataList.add(datas[i]);
                    }
                    if (this.listener == null) break;
                    this.listener.onSearchResult(this.fileDataList);
                    break;
                }
                if (this.listener == null) break;
                this.listener.onSearchResult(null);
                break;
            }
            case 6203: {
                try {
                    if (msg.arg1 < 0) {
                        if (this.listener == null) break;
                        this.listener.onSearchResult(null);
                        break;
                    }
                    if (this.fileDataList == null) {
                        this.fileDataList = new ArrayList<T>();
                    }
                    this.fileDataList.clear();
                    CloudMediaFilesBean cloudMediaFilesBean = new CloudMediaFilesBean();
                    cloudMediaFilesBean.parseJson(ex.str);
                    if (cloudMediaFilesBean.getFileNum() > 0) {
                        this.fileDataList.addAll(cloudMediaFilesBean.cloudMediaInfoToH264FileData());
                    }
                    if (this.listener == null) break;
                    this.listener.onSearchResult(this.fileDataList);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.listener == null) break;
                    this.listener.onSearchResult(null);
                }
                break;
            }
        }
        return 0;
    }

    @Override
    public boolean searchRecordByFile(String devId, SearchFileInfo info) {
        return this.searchRecordByFile(devId, info, 2000);
    }

    @Override
    public boolean searchRecordByFile(@NonNull String devId, @NonNull SearchFileInfo info, int searchMaxFileNum) {
        this.init();
        int iret = FunSDK.DevFindFile((int)this.userId, (String)devId, (byte[])G.ObjToBytes((Object)info.getRecordFileInfo()), (int)searchMaxFileNum, (int)10000, (int)0);
        return iret != 0;
    }

    @Override
    public boolean searchRecordByCloud(@NonNull String devId, @NonNull SearchFileInfo info) {
        int[] begin = new int[]{info.getStartTime().get(1), info.getStartTime().get(2) + 1, info.getStartTime().get(5), info.getStartTime().get(11), info.getStartTime().get(12), info.getStartTime().get(13)};
        int[] end = new int[]{info.getEndTime().get(1), info.getEndTime().get(2) + 1, info.getEndTime().get(5), info.getEndTime().get(11), info.getEndTime().get(12), info.getEndTime().get(13)};
        int ret = CloudDirectory.SearchMediaByTime((int)this.userId, (String)devId, (int)info.getChnId(), (String)"", (int)FunSDK.ToTimeType((int[])begin), (int)FunSDK.ToTimeType((int[])end), (int)0);
        return ret >= 0;
    }

    @Override
    public boolean searchRecordByShortVideo(@NonNull String devId, @NonNull SearchFileInfo info) {
        int[] begin = new int[]{info.getStartTime().get(1), info.getStartTime().get(2) + 1, info.getStartTime().get(5), info.getStartTime().get(11), info.getStartTime().get(12), info.getStartTime().get(13)};
        int[] end = new int[]{info.getEndTime().get(1), info.getEndTime().get(2) + 1, info.getEndTime().get(5), info.getEndTime().get(11), info.getEndTime().get(12), info.getEndTime().get(13)};
        int ret = CloudDirectory.SearchMediaByTimeV2((int)this.userId, (String)devId, (int)info.getChnId(), (String)"", (int)FunSDK.ToTimeType((int[])begin), (int)FunSDK.ToTimeType((int[])end), (String)this.shortRecordType, (int)0, (int)0);
        return ret >= 0;
    }

    @Override
    public boolean searchPictureByFile(@NonNull @NotNull String devId, @NonNull @NotNull SearchFileInfo info) {
        return this.searchPictureByFile(devId, info, 2000);
    }

    @Override
    public boolean searchPictureByFile(@NonNull String devId, @NonNull SearchFileInfo info, int searchMaxFileNum) {
        this.init();
        int iret = FunSDK.DevFindFile((int)this.userId, (String)devId, (byte[])G.ObjToBytes((Object)info.getPictureFileInfo()), (int)searchMaxFileNum, (int)10000, (int)0);
        return iret != 0;
    }

    public static interface OnFileSearchListener<T> {
        public void onSearchResult(List<T> var1);
    }
}

