/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.media.audio;

import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.SystemClock;
import java.nio.ByteBuffer;

public class XMRecordingManager {
    public static final int BIT_RATE = 320;
    private boolean threadExitFlag = false;
    private AudioRecord audioRecord = null;
    private OnRecordingListener listener;
    private ByteBuffer audioDataBuffer;
    private long startRecoringTime;
    private int recordMaxTime = Integer.MAX_VALUE;
    private RecordingTread recordingTread;
    private int bufferSizeInBytes = 320;

    public XMRecordingManager(OnRecordingListener listener, int recordMaxTime) {
        this.listener = listener;
        this.recordMaxTime = recordMaxTime;
        this.audioDataBuffer = ByteBuffer.allocate(0x100000 * recordMaxTime);
    }

    public boolean isRecording() {
        return this.recordingTread != null;
    }

    public boolean startRecording() {
        if (this.audioDataBuffer != null) {
            this.audioDataBuffer.clear();
        }
        if (this.recordingTread == null) {
            this.recordingTread = new RecordingTread();
            return this.recordingTread.startRecording();
        }
        return false;
    }

    public void stopRecording() {
        if (this.recordingTread != null) {
            this.recordingTread.stopRecording();
            this.recordingTread = null;
        }
    }

    public static interface OnRecordingListener {
        public void onRecording(int var1);

        public void onComplete(ByteBuffer var1, int var2);
    }

    class RecordingTread
    extends Thread {
        RecordingTread() {
        }

        public synchronized boolean startRecording() {
            if (!this.isAlive()) {
                XMRecordingManager.this.threadExitFlag = false;
                int minBufSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
                XMRecordingManager.this.audioRecord = new AudioRecord(7, 8000, 2, 2, minBufSize);
                try {
                    AcousticEchoCanceler acousticEchoCanceler = AcousticEchoCanceler.create((int)XMRecordingManager.this.audioRecord.getAudioSessionId());
                    if (acousticEchoCanceler != null) {
                        acousticEchoCanceler.setEnabled(true);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (XMRecordingManager.this.audioRecord.getState() == 0) {
                    return false;
                }
                if (XMRecordingManager.this.bufferSizeInBytes == 0) {
                    XMRecordingManager.this.bufferSizeInBytes = minBufSize;
                }
                XMRecordingManager.this.startRecoringTime = System.currentTimeMillis();
                super.start();
                return true;
            }
            return false;
        }

        public synchronized void stopRecording() {
            XMRecordingManager.this.threadExitFlag = true;
        }

        @Override
        public void run() {
            if (null == XMRecordingManager.this.audioRecord) {
                return;
            }
            XMRecordingManager.this.audioRecord.startRecording();
            byte[] audioData = new byte[XMRecordingManager.this.bufferSizeInBytes];
            while (!XMRecordingManager.this.threadExitFlag) {
                int recordingTime = (int)((System.currentTimeMillis() - XMRecordingManager.this.startRecoringTime) / 1000L);
                int readSize = XMRecordingManager.this.audioRecord.read(audioData, 0, XMRecordingManager.this.bufferSizeInBytes);
                if (readSize > 0) {
                    XMRecordingManager.this.audioDataBuffer.put(audioData);
                    if (recordingTime > XMRecordingManager.this.recordMaxTime) {
                        XMRecordingManager.this.threadExitFlag = true;
                        break;
                    }
                    if (XMRecordingManager.this.listener == null || XMRecordingManager.this.threadExitFlag) continue;
                    XMRecordingManager.this.listener.onRecording(recordingTime);
                    continue;
                }
                SystemClock.sleep((long)5L);
            }
            if (XMRecordingManager.this.audioRecord != null) {
                if (XMRecordingManager.this.audioRecord.getState() == 3) {
                    XMRecordingManager.this.audioRecord.stop();
                }
                XMRecordingManager.this.audioRecord.release();
                XMRecordingManager.this.audioRecord = null;
                if (XMRecordingManager.this.listener != null) {
                    int dataLength = XMRecordingManager.this.audioDataBuffer.position();
                    XMRecordingManager.this.audioDataBuffer.flip();
                    XMRecordingManager.this.listener.onComplete(XMRecordingManager.this.audioDataBuffer, dataLength);
                }
            }
            XMRecordingManager.this.recordingTread = null;
        }
    }
}

