/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.lib.FunSDK;
import com.manager.device.idr.IDRSleepModel;
import java.util.UUID;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public final class IDRSleepService
extends Service {
    public static final int ADD_SLEEP = 500;
    public static final int CANCEL_SLEEP = 501;
    public static final int SLEEP_NOW = 502;
    public static final String SLEEP_QUEUE_EMPTY = "IDRSleepService_QUEUE_EMPTY";
    public static final int KEEP_NOTIFICATION_ID = 0x7FFFFFFE;
    private static final String NOTIFICATION_BACKGROUND_CHANNEL_ID = "SleepService";
    private IDRSleepModel mIDRSleepModel;
    private Handler mHandler = new Handler();
    private Runnable mStopRunnable = new Runnable(){

        @Override
        public void run() {
            IDRSleepService.this.stopSelf();
            IDRSleepService.this.mIDRSleepModel.onDestroy();
        }
    };

    public static final void start(Context context, String sn, int operation) {
        if (TextUtils.isEmpty((CharSequence)sn)) {
            return;
        }
        if (operation != 500 && operation != 501 && operation != 502) {
            return;
        }
        Intent intent = new Intent(context, IDRSleepService.class);
        intent.putExtra("sn", sn);
        intent.putExtra("operation", operation);
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                context.startService(intent);
            }
            catch (Exception e) {
                context.startForegroundService(intent);
            }
        } else {
            context.startService(intent);
        }
    }

    @TargetApi(value=16)
    public void onCreate() {
        super.onCreate();
        this.mIDRSleepModel = new IDRSleepModel();
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                NotificationChannel channel = new NotificationChannel(NOTIFICATION_BACKGROUND_CHANNEL_ID, (CharSequence)FunSDK.TS((String)"TR_Background_Sleep_Service"), 2);
                NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                if (manager != null) {
                    manager.createNotificationChannel(channel);
                    Notification.Builder builder = new Notification.Builder((Context)this.getApplication());
                    builder.setChannelId(NOTIFICATION_BACKGROUND_CHANNEL_ID);
                    builder.setContentText((CharSequence)FunSDK.TS((String)"TR_Keep_Push_Service_Background_Tips"));
                    Intent actIntent = new Intent();
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)UUID.randomUUID().hashCode(), (Intent)actIntent, (int)0xC000000);
                    builder.setContentIntent(pendingIntent);
                    this.startIdrSleepAliveService(builder.getNotification());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                Notification.Builder builder = new Notification.Builder((Context)this.getApplication());
                this.startIdrSleepAliveService(builder.build());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EventBus.getDefault().register((Object)this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null) {
            return 1;
        }
        String sn = intent.getStringExtra("sn");
        int action = intent.getIntExtra("operation", 0);
        this.mHandler.removeCallbacksAndMessages(null);
        switch (action) {
            case 501: {
                this.mIDRSleepModel.removeSleepIDR(sn);
                break;
            }
            case 500: {
                this.mIDRSleepModel.addSleepIDR(sn);
                break;
            }
            case 502: {
                IDRSleepModel.sleep(sn);
                break;
            }
        }
        return 1;
    }

    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        manager.cancel(0x7FFFFFFE);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Subscribe
    public void sleepEmpty(String action) {
        if (TextUtils.isEmpty((CharSequence)action)) {
            return;
        }
        if (!SLEEP_QUEUE_EMPTY.equals(action)) {
            return;
        }
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.postDelayed(this.mStopRunnable, 30000L);
    }

    private void startIdrSleepAliveService(Notification notification) {
        this.startForeground(0x7FFFFFFE, notification);
    }

    public static class InnerService
    extends Service {
        @TargetApi(value=16)
        public void onCreate() {
            super.onCreate();
            if (Build.VERSION.SDK_INT >= 26) {
                try {
                    NotificationChannel channel = new NotificationChannel(IDRSleepService.NOTIFICATION_BACKGROUND_CHANNEL_ID, (CharSequence)FunSDK.TS((String)"TR_Background_Sleep_Service"), 2);
                    NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                    if (manager != null) {
                        manager.createNotificationChannel(channel);
                        Notification.Builder builder = new Notification.Builder((Context)this.getApplication());
                        builder.setChannelId(IDRSleepService.NOTIFICATION_BACKGROUND_CHANNEL_ID);
                        builder.setContentTitle((CharSequence)FunSDK.TS((String)"TR_Push_Service_Background"));
                        builder.setContentText((CharSequence)FunSDK.TS((String)"TR_Keep_Push_Service_Background_Tips"));
                        Intent actIntent = new Intent();
                        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)UUID.randomUUID().hashCode(), (Intent)actIntent, (int)0xC000000);
                        builder.setContentIntent(pendingIntent);
                        this.startIdrSleepAliveService(builder.getNotification());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Notification.Builder builder = new Notification.Builder((Context)this.getApplication());
                    this.startIdrSleepAliveService(builder.build());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    this.stopForeground(true);
                    NotificationManager manager = (NotificationManager)this.getSystemService("notification");
                    manager.cancel(0x7FFFFFFE);
                    this.stopSelf();
                }
            }, 200L);
        }

        @Nullable
        public IBinder onBind(Intent intent) {
            return null;
        }

        private void startIdrSleepAliveService(Notification notification) {
            this.startForeground(0x7FFFFFFE, notification);
        }
    }
}

