/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.idr;

import android.os.Message;
import android.text.TextUtils;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.IFunSDKResult;
import com.lib.MsgContent;
import com.lib.sdk.bean.ElectCapacityBean;
import com.utils.LogUtils;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class IDRDevBatteryManager
implements IFunSDKResult {
    private int mUserId;
    private String mDevId;
    private boolean mIsInit;
    private OnBatteryLevelListener mOnBatteryLevelLs;
    private int seq = 0;
    private ElectCapacityBean electCapacityBean;
    private boolean isSendingStop = false;
    private int mStopType = 0;
    private Disposable mDisposable;

    public IDRDevBatteryManager(String devId) {
        this.mDevId = devId;
        this.mUserId = FunSDK.GetId((int)this.mUserId, (IFunSDKResult)this);
    }

    public void startReceive() {
        if (this.isSendingStop) {
            return;
        }
        if (!this.mIsInit) {
            this.seq = 0;
            LogUtils.debugInfo("[APP_IDR]->", "start dev battery receive " + this.mDevId);
            FunSDK.DevStartUploadData((int)this.mUserId, (String)this.mDevId, (int)5, (int)3);
        }
    }

    public void restartReceive() {
        this.mIsInit = false;
        this.seq = Integer.MAX_VALUE;
        this.mOnBatteryLevelLs = null;
        LogUtils.debugInfo("[APP_IDR]->", "stop dev battery receive " + this.mDevId);
        this.mStopType = 1;
        FunSDK.DevStopUploadData((int)this.mUserId, (String)this.mDevId, (int)5, (int)1);
    }

    public void stopReceive() {
        this.seq = Integer.MAX_VALUE;
        this.mOnBatteryLevelLs = null;
        this.isSendingStop = true;
        this.mStopType = 0;
        LogUtils.debugInfo("[APP_IDR]->", "stop dev battery receive " + this.mDevId);
        FunSDK.DevStopUploadData((int)this.mUserId, (String)this.mDevId, (int)5, (int)0);
    }

    public int OnFunSDKResult(Message msg, MsgContent ex) {
        switch (msg.what) {
            case 5135: {
                LogUtils.debugInfo("[APP_IDR]->", "start dev battery receive result " + this.seq + "   " + msg.arg1 + " " + ex.seq);
                if (msg.arg1 < 0) {
                    if (this.seq >= 3) break;
                    ++this.seq;
                    FunSDK.DevStartUploadData((int)this.mUserId, (String)this.mDevId, (int)5, (int)0);
                    break;
                }
                this.mIsInit = true;
                break;
            }
            case 5136: {
                LogUtils.debugInfo("[APP_IDR]->", "stop dev battery receive result " + this.seq + "   " + msg.arg1 + " " + ex.seq);
                this.seq = 3;
                this.mIsInit = false;
                if (this.mStopType != 1) break;
                this.mDisposable = Flowable.just((Object)0).delay(1L, TimeUnit.SECONDS).subscribe((Consumer)new Consumer<Integer>(){

                    public void accept(Integer integer) throws Exception {
                        IDRDevBatteryManager.this.isSendingStop = false;
                        IDRDevBatteryManager.this.startReceive();
                        if (IDRDevBatteryManager.this.mDisposable != null) {
                            IDRDevBatteryManager.this.mDisposable.dispose();
                        }
                    }
                });
                break;
            }
            case 5137: {
                this.parseBatteryState(G.ToString((byte[])ex.pData));
                break;
            }
        }
        return 0;
    }

    private void parseBatteryState(String jsonStr) {
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(jsonStr);
            jsonObject = jsonObject.optJSONObject("Dev.ElectCapacity");
            this.electCapacityBean = new ElectCapacityBean();
            LogUtils.debugInfo("[APP_IDR]->", this.mDevId + "_\u7535\u91cf_" + jsonStr);
            this.electCapacityBean.devStorageStatus = jsonObject.optInt("DevStorageStatus", -2);
            this.electCapacityBean.electable = jsonObject.optInt("electable", 3);
            this.electCapacityBean.percent = jsonObject.optInt("percent", 4);
            if (jsonObject.has("level")) {
                this.electCapacityBean.level = jsonObject.optInt("level", -1);
            }
            if (null != this.mOnBatteryLevelLs) {
                this.mOnBatteryLevelLs.onBatteryLevel(this.electCapacityBean.devStorageStatus, this.electCapacityBean.electable, this.electCapacityBean.level, this.electCapacityBean.percent);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getLastStorageStatus() {
        if (this.electCapacityBean == null) {
            LogUtils.debugInfo("[APP_IDR]->", "sd\u5361\u72b6\u6001\uff1aelectCapacityBean null");
            return -2;
        }
        return this.electCapacityBean.devStorageStatus;
    }

    public void setOnBatteryLevelListener(OnBatteryLevelListener ls) {
        this.mOnBatteryLevelLs = ls;
    }

    public void destroyNoStop() {
        this.isSendingStop = true;
        this.mOnBatteryLevelLs = null;
        FunSDK.UnRegUser((int)this.mUserId);
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
    }

    public void onDestroy() {
        this.stopReceive();
        this.mOnBatteryLevelLs = null;
        FunSDK.UnRegUser((int)this.mUserId);
        if (this.mDisposable != null) {
            this.mDisposable.dispose();
        }
    }

    public static interface OnBatteryLevelListener {
        public void onBatteryLevel(int var1, int var2, int var3, int var4);
    }
}

