/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.fisheye;

import com.lib.sdk.struct.SDK_FishEyeFrame;
import com.lib.sdk.struct.SDK_FishEyeFrameHW;
import com.lib.sdk.struct.SDK_FishEyeFrameSW;
import com.lib.sdk.struct.SDK_TwoLensesInOne;
import com.utils.FileUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class FishEyeParamsCache {
    private static FishEyeParamsCache mInstance = null;
    private String mAppVersion = null;
    private String mFilePath = null;
    private Map<String, SDK_FishEyeFrame> mFishFrameMap = new HashMap<String, SDK_FishEyeFrame>();
    private static final int FISHEYE_HARDWARE = 1;
    private static final int FISHEYE_SOFTWARE = 2;
    private static final int TWO_LENSES_IN_ONE = 3;

    private FishEyeParamsCache() {
    }

    public static FishEyeParamsCache getInstance() {
        if (null == mInstance) {
            mInstance = new FishEyeParamsCache();
        }
        return mInstance;
    }

    public void init(String cachePath, String appVer) {
        this.mFilePath = cachePath;
        this.mAppVersion = appVer;
        new Thread(){

            @Override
            public void run() {
                FishEyeParamsCache.this.load();
            }
        }.start();
    }

    public SDK_FishEyeFrame getFishFrame(String devSnChn) {
        if (null == devSnChn) {
            return null;
        }
        return this.mFishFrameMap.get(devSnChn);
    }

    public void setFishFrame(String devSnChn, SDK_FishEyeFrame sp) {
        SDK_FishEyeFrame oldSp = this.getFishFrame(devSnChn);
        if (null == oldSp || !oldSp.equals((Object)sp)) {
            this.mFishFrameMap.put(devSnChn, sp);
            new Thread(){

                @Override
                public void run() {
                    FishEyeParamsCache.this.save();
                }
            }.start();
        }
    }

    public void delete(String sn) {
        this.mFishFrameMap.remove(sn);
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Map<String, SDK_FishEyeFrame> map = this.mFishFrameMap;
        synchronized (map) {
            try {
                String cacheText = new String(FileUtils.readSDFile(this.mFilePath));
                JSONObject fishFramesObj = new JSONObject(cacheText);
                String appVer = fishFramesObj.getString("appver");
                if (!appVer.equals(this.mAppVersion)) {
                    return;
                }
                JSONArray jsonArray = fishFramesObj.getJSONArray("frames");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject jsonObj = jsonArray.getJSONObject(i);
                    String sn = jsonObj.optString("sn");
                    SDK_FishEyeFrame frame = this.toParam(jsonObj);
                    if (sn.length() <= 0 || null == frame) continue;
                    this.mFishFrameMap.put(sn, frame);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Map<String, SDK_FishEyeFrame> map = this.mFishFrameMap;
        synchronized (map) {
            try {
                Set<String> devSns = this.mFishFrameMap.keySet();
                JSONArray jsonArray = new JSONArray();
                for (String sn : devSns) {
                    JSONObject jsonObj = this.toJsonObj(sn, this.mFishFrameMap.get(sn));
                    if (null == jsonObj) continue;
                    jsonArray.put((Object)jsonObj);
                }
                JSONObject fishFramesObj = new JSONObject();
                fishFramesObj.put("appver", (Object)this.mAppVersion);
                fishFramesObj.put("frames", (Object)jsonArray);
                FileUtils.writeSDFile(this.mFilePath, fishFramesObj.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private JSONObject toJsonObj(String devSN, SDK_FishEyeFrame param) {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("sn", (Object)devSN);
            if (param instanceof SDK_FishEyeFrameSW) {
                SDK_FishEyeFrameSW ps = (SDK_FishEyeFrameSW)param;
                jsonObj.put("type", 2);
                jsonObj.put("st_0_version", (int)ps.st_0_version);
                jsonObj.put("st_1_lensType", (int)ps.st_1_lensType);
                jsonObj.put("st_2_centerOffsetX", (int)ps.st_2_centerOffsetX);
                jsonObj.put("st_3_centerOffsetY", (int)ps.st_3_centerOffsetY);
                jsonObj.put("st_4_radius", (int)ps.st_4_radius);
                jsonObj.put("st_5_imageWidth", (int)ps.st_5_imageWidth);
                jsonObj.put("st_6_imageHeight", (int)ps.st_6_imageHeight);
                jsonObj.put("st_7_viewAngle", (int)ps.st_7_viewAngle);
                jsonObj.put("st_8_viewMode", (int)ps.st_8_viewMode);
            } else if (param instanceof SDK_FishEyeFrameHW) {
                SDK_FishEyeFrameHW ph = (SDK_FishEyeFrameHW)param;
                jsonObj.put("type", 1);
                jsonObj.put("st_0_secene", (int)ph.st_0_secene);
            } else if (param instanceof SDK_TwoLensesInOne) {
                SDK_TwoLensesInOne twoLensesInOne = (SDK_TwoLensesInOne)param;
                jsonObj.put("type", 3);
                jsonObj.put("spliceDirection", (int)twoLensesInOne.st_0_spliceDirection);
                jsonObj.put("videoWidth", twoLensesInOne.getWidth());
                jsonObj.put("videoHeight", twoLensesInOne.getHeight());
            }
            return jsonObj;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SDK_FishEyeFrame toParam(JSONObject jsonObj) {
        try {
            int type = jsonObj.getInt("type");
            if (type == 1) {
                SDK_FishEyeFrameHW ph = new SDK_FishEyeFrameHW();
                ph.st_0_secene = (byte)jsonObj.getInt("st_0_secene");
                return ph;
            }
            if (type == 2) {
                SDK_FishEyeFrameSW ps = new SDK_FishEyeFrameSW();
                ps.st_0_version = (byte)jsonObj.getInt("st_0_version");
                ps.st_1_lensType = (byte)jsonObj.getInt("st_1_lensType");
                ps.st_2_centerOffsetX = (short)jsonObj.getInt("st_2_centerOffsetX");
                ps.st_3_centerOffsetY = (short)jsonObj.getInt("st_3_centerOffsetY");
                ps.st_4_radius = (short)jsonObj.getInt("st_4_radius");
                ps.st_5_imageWidth = (short)jsonObj.getInt("st_5_imageWidth");
                ps.st_6_imageHeight = (short)jsonObj.getInt("st_6_imageHeight");
                ps.st_7_viewAngle = (byte)jsonObj.getInt("st_7_viewAngle");
                ps.st_8_viewMode = (byte)jsonObj.getInt("st_8_viewMode");
                return ps;
            }
            if (type == 3) {
                SDK_TwoLensesInOne twoLensesInOne = new SDK_TwoLensesInOne();
                twoLensesInOne.st_0_spliceDirection = (byte)jsonObj.getInt("spliceDirection");
                twoLensesInOne.setWidth(jsonObj.getInt("videoWidth"));
                twoLensesInOne.setHeight(jsonObj.getInt("videoHeight"));
                return twoLensesInOne;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

