/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config.preset;

import com.lib.sdk.bean.HandleConfigData;
import com.lib.sdk.bean.OPPTZControlBean;
import com.manager.device.DeviceManager;
import com.manager.device.config.DevConfigInfo;
import com.manager.device.config.DevConfigManager;
import com.manager.device.config.preset.IPresetManager;
import org.jetbrains.annotations.NotNull;

public class PresetManager
implements IPresetManager {
    private DevConfigManager devConfigManager;
    private DeviceManager.OnDevManagerListener onDevManagerListener;
    public static final int PRESET_ADD = 1;
    public static final int PRESET_REMOVE = 2;
    public static final int PRESET_EDIT = 3;
    public static final int PRESET_MODIFY_NAME = 4;
    public static final int PRESET_TURN_TO = 5;

    public PresetManager(@NotNull String devId, @NotNull DeviceManager.OnDevManagerListener onDevManagerListener) {
        this.devConfigManager = DevConfigManager.create(devId);
        this.onDevManagerListener = onDevManagerListener;
    }

    @Override
    public boolean getPresetList(int chnId) {
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        devConfigInfo2.setJsonName("Uart.PTZPreset");
        devConfigInfo2.setChnId(chnId);
        this.devConfigManager.getDevConfig(devConfigInfo2);
        return true;
    }

    @Override
    public boolean addPreset(int chnId, int presetId) {
        if (presetId < 1 || presetId > 255) {
            return false;
        }
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        OPPTZControlBean opptzControlBean = new OPPTZControlBean();
        opptzControlBean.Command = "SetPreset";
        opptzControlBean.Parameter.Channel = chnId;
        opptzControlBean.Parameter.Preset = presetId;
        String jsonData = HandleConfigData.getSendData("OPPTZControl", "0x08", opptzControlBean);
        devConfigInfo2.setJsonName("OPPTZControl");
        devConfigInfo2.setCmdId(1400);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setSeq(1);
        this.devConfigManager.setDevCmd(devConfigInfo2);
        return true;
    }

    @Override
    public boolean clearPreset(int chnId, int presetId) {
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        OPPTZControlBean opptzControlBean = new OPPTZControlBean();
        opptzControlBean.Command = "ClearPreset";
        opptzControlBean.Parameter.Channel = chnId;
        opptzControlBean.Parameter.Preset = presetId;
        String jsonData = HandleConfigData.getSendData("OPPTZControl", "0x08", opptzControlBean);
        devConfigInfo2.setJsonName("OPPTZControl");
        devConfigInfo2.setCmdId(1400);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setSeq(2);
        this.devConfigManager.setDevCmd(devConfigInfo2);
        return true;
    }

    @Override
    public boolean editPreset(int chnId, int presetId) {
        if (presetId < 1 || presetId > 255) {
            return false;
        }
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        OPPTZControlBean opptzControlBean = new OPPTZControlBean();
        opptzControlBean.Command = "SetPreset";
        opptzControlBean.Parameter.Channel = chnId;
        opptzControlBean.Parameter.Preset = presetId;
        String jsonData = HandleConfigData.getSendData("OPPTZControl", "0x08", opptzControlBean);
        devConfigInfo2.setJsonName("OPPTZControl");
        devConfigInfo2.setCmdId(1400);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setSeq(3);
        this.devConfigManager.setDevCmd(devConfigInfo2);
        return true;
    }

    @Override
    public boolean turnPreset(int chnId, int presetId) {
        if (presetId < 1 || presetId > 255) {
            return false;
        }
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        OPPTZControlBean opptzControlBean = new OPPTZControlBean();
        opptzControlBean.Command = "GotoPreset";
        opptzControlBean.Parameter.Channel = chnId;
        opptzControlBean.Parameter.Preset = presetId;
        String jsonData = HandleConfigData.getSendData("OPPTZControl", "0x08", opptzControlBean);
        devConfigInfo2.setJsonName("OPPTZControl");
        devConfigInfo2.setCmdId(1400);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setSeq(5);
        this.devConfigManager.setDevCmd(devConfigInfo2);
        return true;
    }

    @Override
    public boolean modifyPresetName(int chnId, int presetId, String presetName) {
        if (presetId < 1 || presetId > 255 || presetName == null) {
            return false;
        }
        DevConfigInfo devConfigInfo2 = DevConfigInfo.create(this.onDevManagerListener, new String[0]);
        OPPTZControlBean opptzControlBean = new OPPTZControlBean();
        opptzControlBean.Command = "SetPresetName";
        opptzControlBean.Parameter.Channel = 0;
        opptzControlBean.Parameter.Preset = presetId;
        opptzControlBean.Parameter.PresetName = presetName;
        String jsonData = HandleConfigData.getSendData("OPPTZControl", "0x08", opptzControlBean);
        devConfigInfo2.setJsonName("OPPTZControl");
        devConfigInfo2.setCmdId(1400);
        devConfigInfo2.setJsonData(jsonData);
        devConfigInfo2.setSeq(4);
        this.devConfigManager.setDevCmd(devConfigInfo2);
        return true;
    }
}

