/*
 * Decompiled with CFR 0.152.
 */
package com.manager.device.config.mqtt;

import android.app.Application;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.constant.DeviceConstant;
import com.lib.sdk.bean.StringUtils;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.mqtt.MqttInfo;
import com.manager.mqtt.XMMqttManager;
import com.manager.websocket.WebSocketInfo;
import com.utils.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DevStateNotifyMqttManager
implements XMMqttManager.XMMqttListener {
    public static String MQTT_KEY = "MQTT_SERVER";
    public static final int RETRY_TIMES = 3;
    public static String MQTT_SUBSCRIBE_URL = "jfmq-v2.xmcsrv.net";
    public static int MQTT_SUBSCRIBE_PORT = 1883;
    private static DevStateNotifyMqttManager devStateNotifyManager;
    private static XMMqttManager xmMqttManager;
    private boolean isReconnecting = false;
    private int mqttInitRetryTime = 3;
    private boolean isMqttInit = false;
    private HashMap<String, Boolean> isSelfDelDevMap = new HashMap();
    private HashMap<String, Boolean> isSelfDelGroupMap = new HashMap();
    private WebSocketInfo webSocketInfo;
    private HashMap<Integer, OnDevStateNotifyListener> notifyListenerHashMap;
    private List<String> devList = new ArrayList<String>();

    private DevStateNotifyMqttManager(Application application) {
        this.notifyListenerHashMap = new HashMap();
        xmMqttManager = XMMqttManager.getInstance(application.getApplicationContext());
        xmMqttManager.setPrintLog(true);
        xmMqttManager.initMqttServerParam(MQTT_KEY, MQTT_SUBSCRIBE_URL, MQTT_SUBSCRIBE_PORT);
        xmMqttManager.addXMMqttListener(this);
    }

    public static synchronized DevStateNotifyMqttManager getInstance(Application application) {
        if (devStateNotifyManager == null) {
            devStateNotifyManager = new DevStateNotifyMqttManager(application);
        }
        return devStateNotifyManager;
    }

    public boolean webSocketIsConnect() {
        if (null == this.webSocketInfo) {
            return false;
        }
        return this.webSocketInfo.isConnect();
    }

    public void addNotifyListener(OnDevStateNotifyListener onDevStateNotifyListener) {
        if (onDevStateNotifyListener != null && this.notifyListenerHashMap != null && !this.notifyListenerHashMap.containsKey(onDevStateNotifyListener.hashCode())) {
            this.notifyListenerHashMap.put(onDevStateNotifyListener.hashCode(), onDevStateNotifyListener);
        }
    }

    public void removeNotifyListener(OnDevStateNotifyListener onDevStateNotifyListener) {
        if (this.notifyListenerHashMap != null && onDevStateNotifyListener != null && this.notifyListenerHashMap.containsKey(onDevStateNotifyListener.hashCode())) {
            this.notifyListenerHashMap.remove(onDevStateNotifyListener.hashCode());
        }
    }

    private void dealWithDevErrorState(String devId, String errorId, Object errorMsg, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevErrorState(devId, errorId, errorMsg, originalData);
            }
        }
    }

    private void dealWithDevSleepState(String devId, Object value, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevSleepState(devId, value, originalData);
            }
        }
    }

    private void dealWithDevMasterCtrlState(String devId, Object value, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevMasterCtrlState(devId, value, originalData);
            }
        }
    }

    private void dealWithDevFunState(String devId, String funId, Object value, JSONObject originalData) {
        if (this.notifyListenerHashMap != null) {
            for (Integer key : this.notifyListenerHashMap.keySet()) {
                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                if (onDevStateNotifyListener == null) continue;
                onDevStateNotifyListener.onDevFunState(devId, funId, value, originalData);
            }
        }
    }

    public void connectMqtt() {
        if (xmMqttManager != null) {
            xmMqttManager.connectMqtt();
        }
    }

    @Override
    public void onMqttInfo(MqttInfo mqttInfo) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            LogUtils.debugInfo("[APP_MQTT]->", "currentThread " + Thread.currentThread().getName());
                            if (devStateNotifyManager == null) {
                                return;
                            }
                            if (mqttInfo.getState() != 1) break block7;
                            LogUtils.debugInfo("[APP_MQTT]->", "MQTT \u5df2\u7ecf\u8fde\u63a5");
                            if (this.notifyListenerHashMap == null) break block8;
                            for (Integer key : this.notifyListenerHashMap.keySet()) {
                                OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                                if (onDevStateNotifyListener == null) continue;
                                onDevStateNotifyListener.onConnected();
                            }
                            break block8;
                        }
                        if (mqttInfo.getState() != 5) break block9;
                        if (this.mqttInitRetryTime-- > 0) {
                            this.connectMqtt();
                        } else {
                            LogUtils.debugInfo("[APP_MQTT]->", "MQTT\u521d\u59cb\u5316\u5931\u8d25,\u91cd\u8bd5\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
                        }
                        break block8;
                    }
                    if (mqttInfo.getState() != 4) break block10;
                    LogUtils.debugInfo("[APP_MQTT]->", mqttInfo.getStrMsg());
                    this.webSocketDataParse(mqttInfo.getStrMsg());
                    break block8;
                }
                if (mqttInfo.getState() != 2) break block11;
                if (this.notifyListenerHashMap == null) break block8;
                for (Integer key : this.notifyListenerHashMap.keySet()) {
                    OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                    if (onDevStateNotifyListener == null) continue;
                    onDevStateNotifyListener.onReconnected();
                }
                break block8;
            }
            if (mqttInfo.getState() == 6) {
                LogUtils.debugInfo("[APP_MQTT]->", "MQTT unInit result back\uff01");
                for (Integer key : this.notifyListenerHashMap.keySet()) {
                    OnDevStateNotifyListener onDevStateNotifyListener = this.notifyListenerHashMap.get(key);
                    if (onDevStateNotifyListener == null) continue;
                    onDevStateNotifyListener.onUnInit(mqttInfo.getErrorId() == 0);
                }
            }
        }
    }

    public void subscribeAllDevIdsByMqtt() {
        if (xmMqttManager != null && this.devList != null && !this.devList.isEmpty()) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u8ba2\u9605\u5168\u90e8\u8bbe\u5907\uff0c\u8bbe\u5907\u6570\u91cf\uff1a" + this.devList.size());
            xmMqttManager.subscribe("devicemsg", this.devList);
            xmMqttManager.subscribe("status", this.devList);
        }
    }

    public void subscribeDevIdsByMqtt(List<String> devIds) {
        if (xmMqttManager != null && devIds != null && !devIds.isEmpty()) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u8ba2\u9605\u8bbe\u5907\uff0c\u8bbe\u5907\u6570\u91cf\uff1a" + devIds.size());
            xmMqttManager.subscribe("devicemsg", devIds);
            xmMqttManager.subscribe("status", devIds);
            for (String devId : devIds) {
                if (devId == null || this.devList.contains(devId)) continue;
                this.devList.add(devId);
            }
        }
    }

    public void unSubscribeDevIdsByMqtt(List<String> devIds) {
        if (xmMqttManager != null && devIds != null && !devIds.isEmpty()) {
            LogUtils.debugInfo("[APP_MQTT]->", "mqtt\u53d6\u6d88\u8ba2\u9605\u8bbe\u5907\uff0c\u8bbe\u5907\u6570\u91cf\uff1a" + devIds.size());
            xmMqttManager.unSubscribe("devicemsg", devIds);
            xmMqttManager.unSubscribe("status", devIds);
        }
    }

    public void closeCurrentConnect() {
        if (xmMqttManager != null) {
            xmMqttManager.closeMqtt();
        }
    }

    public void release() {
        this.closeCurrentConnect();
        if (xmMqttManager != null) {
            xmMqttManager.release();
            xmMqttManager = null;
        }
        if (this.notifyListenerHashMap != null) {
            this.notifyListenerHashMap.clear();
            this.notifyListenerHashMap = null;
        }
        devStateNotifyManager = null;
    }

    public void webSocketDataParse(String jsonData) {
        if (jsonData == null) {
            return;
        }
        String devId = null;
        JSONObject notifyEventMap = (JSONObject)JSON.parse((String)jsonData);
        if (notifyEventMap != null && !notifyEventMap.isEmpty()) {
            JSONArray eventMap;
            Object eventObj;
            Object snObj;
            if (notifyEventMap.containsKey((Object)"sn") && (snObj = notifyEventMap.get((Object)"sn")) instanceof String) {
                devId = (String)snObj;
            }
            if (notifyEventMap.containsKey((Object)"props") && (eventObj = notifyEventMap.get((Object)"props")) instanceof JSONArray && !(eventMap = (JSONArray)eventObj).isEmpty()) {
                block5: for (int i = 0; i < eventMap.size(); ++i) {
                    Object eventsObj;
                    Object propCodeObj;
                    String propCode = null;
                    Object propValue = null;
                    JSONArray eventArray = null;
                    JSONObject propObj = (JSONObject)eventMap.get(i);
                    if (propObj.containsKey((Object)"propCode") && (propCodeObj = propObj.get((Object)"propCode")) instanceof String) {
                        propCode = (String)propCodeObj;
                    }
                    if (propObj.containsKey((Object)"propValue")) {
                        propValue = propObj.get((Object)"propValue");
                    }
                    if (propObj.containsKey((Object)"events") && (eventsObj = propObj.get((Object)"events")) instanceof JSONArray) {
                        eventArray = (JSONArray)eventsObj;
                        if (propCode != null) {
                            this.dealWithDevErrorState(devId, propCode, eventArray, notifyEventMap);
                        }
                    }
                    if (propCode == null) continue;
                    for (DeviceConstant.DevStateConstant.DevFunStatus devFunStatus : DeviceConstant.DevStateConstant.DevFunStatus.values()) {
                        if (!StringUtils.contrast(devFunStatus.getEventId(), propCode)) continue;
                        switch (devFunStatus.getType()) {
                            case 0: {
                                String value;
                                if (propValue == null) continue block5;
                                XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
                                if (xmDevInfo != null) {
                                    if (propValue instanceof String) {
                                        value = (String)propValue;
                                        if (DeviceConstant.DevStateEnum.PREPARE_SLEEP.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevState(6);
                                        } else if (DeviceConstant.DevStateEnum.LIGHT_SLEEP.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevState(2);
                                        } else if (DeviceConstant.DevStateEnum.DEEP_SLEEP.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevState(5);
                                            xmDevInfo.setDevMasterCtrlState(5);
                                        } else if (DeviceConstant.DevStateEnum.WAKE_UP.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevState(3);
                                        }
                                    }
                                    LogUtils.debugInfo("[APP_IDR]->", "\u8bbe\u5907\u72b6\u6001:" + xmDevInfo.getDevState());
                                }
                                this.dealWithDevSleepState(devId, propValue, notifyEventMap);
                                break;
                            }
                            case 1: {
                                if (propValue == null) continue block5;
                                this.dealWithDevFunState(devId, propCode, propValue, notifyEventMap);
                                break;
                            }
                            case 3: {
                                String value;
                                if (propValue == null) continue block5;
                                XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
                                if (xmDevInfo != null) {
                                    if (propValue instanceof String) {
                                        value = (String)propValue;
                                        if (DeviceConstant.DevStateEnum.MASTER_CTRL_SLEEP.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevMasterCtrlState(2);
                                        } else if (DeviceConstant.DevStateEnum.MASTER_CTRL_WAKE.getDevState().equalsIgnoreCase(value)) {
                                            xmDevInfo.setDevMasterCtrlState(4);
                                        }
                                    }
                                    LogUtils.debugInfo("[APP_IDR]->", "\u4e3b\u63a7\u72b6\u6001:" + xmDevInfo.getDevMasterCtrlState());
                                }
                                this.dealWithDevMasterCtrlState(devId, propValue, notifyEventMap);
                                break;
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
    }

    public void addDelIdentify(String devId) {
        if (this.isSelfDelDevMap != null) {
            this.isSelfDelDevMap.put(devId, true);
        }
    }

    public void removeDelIdentify(String devId) {
        if (this.isSelfDelDevMap != null) {
            this.isSelfDelDevMap.put(devId, false);
        }
    }

    public void addDelGroupIdenify(String userGroupId) {
        if (this.isSelfDelGroupMap != null) {
            this.isSelfDelGroupMap.put(userGroupId, true);
        }
    }

    public void removeDelGroupIdenify(String userGroupId) {
        if (this.isSelfDelGroupMap != null) {
            this.isSelfDelGroupMap.put(userGroupId, false);
        }
    }

    public static interface OnDevStateNotifyListener {
        default public void onDevSleepState(String devId, Object value, JSONObject originalData) {
        }

        default public void onDevMasterCtrlState(String devId, Object value, JSONObject originalData) {
        }

        default public void onDevFunState(String devId, String funId, Object value, JSONObject originalData) {
        }

        default public void onDevErrorState(String devId, String errorId, Object errorMsg, JSONObject originalData) {
        }

        default public void onReconnecting() {
        }

        default public void onReconnected() {
        }

        default public void onConnected() {
        }

        default public void onDisconnected() {
        }

        default public void onUnInit(boolean isSuccess) {
        }
    }
}

