/*
 * Decompiled with CFR 0.152.
 */
package com.manager.db;

import com.basic.G;
import com.lib.FunSDK;
import com.lib.Mps.SMCInitInfo;
import com.lib.constant.DevType;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.bean.SystemFunctionBean;
import com.lib.sdk.bean.SystemInfoBean;
import com.lib.sdk.bean.SystemInfoExBean;
import com.lib.sdk.bean.share.OtherShareDevUserBean;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.manager.db.DevDataCenterInerface;
import com.manager.db.XMDevInfo;
import com.manager.device.DeviceManager;
import com.utils.LogUtils;
import com.utils.ThreadUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DevDataCenter
implements DevDataCenterInerface {
    private HashMap<String, XMDevInfo> xmDevInfos = new HashMap();
    private TreeMap<Integer, Boolean> recordFileMap;
    private List<String> devList = new ArrayList<String>();
    private static DevDataCenter instance;
    private OnDevDataCenterListener devDataCenterListener;
    private int pushType;
    private SMCInitInfo smcInitInfo;
    private String accountUserName;
    private String accountPassword;
    private int loginType;
    private int appLoginOemType;
    private volatile String accessToken;
    private List<OtherShareDevUserBean> otherShareDevUserBeanList;

    private DevDataCenter(OnDevDataCenterListener ls) {
        this.devDataCenterListener = ls;
    }

    public static DevDataCenter getInstance() {
        if (null == instance) {
            instance = new DevDataCenter(null);
        }
        return instance;
    }

    public static DevDataCenter getInstance(OnDevDataCenterListener ls) {
        if (null == instance) {
            instance = new DevDataCenter(ls);
        } else {
            instance.setOnDevDataCenterListener(ls);
        }
        return instance;
    }

    public void setOnDevDataCenterListener(OnDevDataCenterListener ls) {
        this.devDataCenterListener = ls;
    }

    private XMDevInfo sdbDevInfoToXMDevInfo(String devId, SDBDeviceInfo info) {
        XMDevInfo xmDevInfo;
        if (null == info) {
            return null;
        }
        if (!this.devList.contains(devId)) {
            this.devList.add(devId);
        }
        if ((xmDevInfo = this.xmDevInfos.get(devId)) == null) {
            xmDevInfo = new XMDevInfo();
        }
        xmDevInfo.sdbDevInfoToXMDevInfo(info);
        return xmDevInfo;
    }

    @Override
    public void addDev(SDBDeviceInfo info) {
        if (null == info) {
            return;
        }
        String devId = G.ToString((byte[])info.st_0_Devmac);
        this.xmDevInfos.put(devId, this.sdbDevInfoToXMDevInfo(devId, info));
    }

    @Override
    public void addDev(XMDevInfo info) {
        if (null == info) {
            return;
        }
        if (!this.xmDevInfos.containsKey(info.getDevId())) {
            this.xmDevInfos.put(info.getDevId(), info);
            this.devList.add(info.getDevId());
        }
    }

    @Override
    public void addDevs(List<SDBDeviceInfo> infos) {
        for (SDBDeviceInfo info : infos) {
            String devId = G.ToString((byte[])info.st_0_Devmac);
            this.xmDevInfos.put(devId, this.sdbDevInfoToXMDevInfo(devId, info));
        }
    }

    @Override
    public boolean removeDev(String devId) {
        if (this.xmDevInfos.containsKey(devId)) {
            this.xmDevInfos.remove(devId);
            if (this.devList != null && this.devList.contains(devId)) {
                this.devList.remove(devId);
            }
        }
        if (this.devDataCenterListener != null) {
            this.devDataCenterListener.clearDevConfig(devId);
        }
        return true;
    }

    @Override
    public boolean removeDevs() {
        if (this.xmDevInfos != null) {
            this.xmDevInfos.clear();
        }
        if (this.devList != null) {
            this.devList.clear();
        }
        if (this.devDataCenterListener != null) {
            this.devDataCenterListener.clearDevConfigs();
        }
        return true;
    }

    @Override
    public boolean isDevExist(String devId) {
        return this.xmDevInfos.containsKey(devId);
    }

    @Override
    public boolean isLoginByAccount() {
        return this.loginType == 6 || this.loginType == 5 || this.loginType == 9 || this.loginType == 8 || this.loginType == 7 || this.loginType == 1 || this.loginType == 10 || this.loginType == 11;
    }

    @Override
    public XMDevInfo getDevInfo(String devId) {
        if (this.xmDevInfos.containsKey(devId)) {
            XMDevInfo info = this.xmDevInfos.get(devId);
            return info;
        }
        return null;
    }

    @Override
    public int getDevType(String devId) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            return info.getDevType();
        }
        return 0;
    }

    @Override
    public void setDevType(String devId, int devType) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            info.setDevType(devType);
        }
    }

    @Override
    public void setSystemInfo(String devId, SystemInfoBean sysInfo) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            info.setSystemInfoBean(sysInfo);
        }
    }

    @Override
    public SystemInfoBean getSystemInfo(String devId) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            return info.getSystemInfoBean();
        }
        return null;
    }

    @Override
    public SystemInfoExBean getSystemExInfo(String devId) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            return info.getSystemInfoExBean();
        }
        return null;
    }

    @Override
    public void setSystemExInfo(String devId, SystemInfoExBean sysInfo) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            info.setSystemInfoExBean(sysInfo);
        }
    }

    @Override
    public void setSystemFunction(String devId, SystemFunctionBean sysFuncInfo) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            info.setSystemFunctionBean(sysFuncInfo);
        }
    }

    @Override
    public SystemFunctionBean getSystemFunction(String devId) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            return info.getSystemFunctionBean();
        }
        return null;
    }

    @Override
    public int getOnlineDevCount() {
        int count = 0;
        if (this.xmDevInfos != null && !this.xmDevInfos.isEmpty()) {
            for (Map.Entry<String, XMDevInfo> entry : this.xmDevInfos.entrySet()) {
                XMDevInfo xmDevInfo = entry.getValue();
                if (xmDevInfo == null || xmDevInfo.getDevState() == 0) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isLowPowerDev(int devType) {
        switch (devType) {
            case 21: 
            case 26: 
            case 285409282: 
            case 286326823: 
            case 0x11110031: 
            case 0x11110033: 
            case 0x11130001: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isLowPowerDevByPid(String pid) {
        return StringUtils.contrast(DevType.IDR.getPid(), pid) || StringUtils.contrast(DevType.PEEPHOLE.getPid(), pid) || StringUtils.contrast(DevType.DEV_CZ_IDR.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK_V2.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_LOW_POWER.getPid(), pid) || StringUtils.contrast(DevType.EE_DEV_DOORLOCK_PEEPHOLE.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_BELL_B.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_BELL_P.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_LOCK.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_LOCK_LX.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_LOCK_LX_B.getPid(), pid) || StringUtils.contrast(DevType.PID_T_DOOR_BELL_LX.getPid(), pid) || StringUtils.contrast(DevType.PID_XM_650_V200_DOOR_LOCK.getPid(), pid) || StringUtils.contrast(DevType.PID_XM_650_V200_DOOR_LOCK_PRO.getPid(), pid) || StringUtils.contrast(DevType.PID_XM_650_V200_DOOR_LOCK_USB.getPid(), pid) || StringUtils.contrast(DevType.PID_BK.getPid(), pid);
    }

    @Override
    public boolean isLowPowerDev(String devId) {
        if (StringUtils.isStringNULL(devId)) {
            return false;
        }
        XMDevInfo xmDevInfo = this.getDevInfo(devId);
        if (xmDevInfo != null) {
            if (StringUtils.isStringNULL(xmDevInfo.getPid())) {
                return this.isLowPowerDev(xmDevInfo.getDevType());
            }
            return this.isLowPowerDevByPid(xmDevInfo.getPid());
        }
        return false;
    }

    @Override
    public String getSerialNo(String devId) {
        SystemInfoBean systemInfoBean;
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId)) && (systemInfoBean = info.getSystemInfoBean()) != null) {
            return systemInfoBean.getSerialNo();
        }
        return devId;
    }

    @Override
    public String getBuildTime(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getBuildTime");
    }

    @Override
    public String getHardWare(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getHardWare");
    }

    @Override
    public int getDigChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getDigChannel");
    }

    @Override
    public int getExtraChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getExtraChannel");
    }

    @Override
    public int getVideoInChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getVideoInChannel");
    }

    @Override
    public int getTalkInChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getTalkInChannel");
    }

    @Override
    public int getAlarmInChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getAlarmInChannel");
    }

    @Override
    public int getAlarmOutChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getAlarmOutChannel");
    }

    @Override
    public int getCombineSwitch(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getCombineSwitch");
    }

    @Override
    public int getVideoOutChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getVideoOutChannel");
    }

    @Override
    public int getAudioInChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getAudioInChannel");
    }

    @Override
    public int getTalkOutChannel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (Integer)this.getSystemInfoItemValue(devId, listener, "getTalkOutChannel");
    }

    @Override
    public String getUpdataTime(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getUpdataTime");
    }

    @Override
    public String getEncryptVersion(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getEncryptVersion");
    }

    @Override
    public String getDeviceRunTime(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getDeviceRunTime");
    }

    @Override
    public String getHardWareVersion(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getHardWareVersion");
    }

    @Override
    public String getSoftWareVersion(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getSoftWareVersion");
    }

    @Override
    public String getDeviceModel(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoItemValue(devId, listener, "getDeviceModel");
    }

    @Override
    public String getMcuVersion(String devId, DeviceManager.OnDevManagerListener listener) {
        return (String)this.getSystemInfoExItemValue(devId, listener, "getMcuVersion");
    }

    @Override
    public int getEncyptChipInfo(String devId, DeviceManager.OnDevManagerListener listener) {
        if (this.xmDevInfos.containsKey(devId)) {
            XMDevInfo info = this.xmDevInfos.get(devId);
            int chipOEMId = info.getChipOEMId();
            if (info != null && chipOEMId >= 0) {
                if (null != listener) {
                    listener.onSuccess(devId, 0, chipOEMId);
                    return chipOEMId;
                }
            } else {
                if (null != listener) {
                    listener.onFailed(devId, 0, "EncyptChipInfo", 0);
                }
                if (null != this.devDataCenterListener) {
                    this.devDataCenterListener.getConfigFromDev(devId, listener, "EncyptChipInfo", new String[0]);
                }
            }
        }
        return -1;
    }

    @Override
    public int getNetConnectMode(String devId, DeviceManager.OnDevManagerListener listener) {
        Object obj = this.getSystemInfoItemValue(devId, listener, "getNetConnectMode");
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    private Object getSystemInfoItemValue(String devId, DeviceManager.OnDevManagerListener listener, String field) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            SystemInfoBean sysInfo = info.getSystemInfoBean();
            if (null != sysInfo) {
                Object result = null;
                Class<?> _class = sysInfo.getClass();
                try {
                    Method method = _class.getMethod(field, null);
                    if (method != null) {
                        try {
                            result = method.invoke((Object)sysInfo, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                if (null != listener) {
                    listener.onSuccess(devId, 0, result);
                }
                return result;
            }
            if (null != this.devDataCenterListener) {
                this.devDataCenterListener.getConfigFromDev(devId, listener, "SystemInfo", field);
            }
            return "";
        }
        return "";
    }

    private Object getSystemInfoExItemValue(String devId, DeviceManager.OnDevManagerListener listener, String field) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            SystemInfoExBean sysInfo = info.getSystemInfoExBean();
            if (null != sysInfo) {
                Object result = null;
                Class<?> _class = sysInfo.getClass();
                try {
                    Method method = _class.getMethod(field, null);
                    if (method != null) {
                        try {
                            result = method.invoke((Object)sysInfo, new Object[0]);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                if (null != listener) {
                    listener.onSuccess(devId, 0, result);
                }
                return result;
            }
            if (null != this.devDataCenterListener) {
                this.devDataCenterListener.getConfigFromDev(devId, listener, "SystemInfoEx", field);
            }
            return "";
        }
        return "";
    }

    public Boolean getSystemFunctionItemValue(String devId, DeviceManager.OnDevManagerListener listener, String ... field) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            SystemFunctionBean sysFunc = info.getSystemFunctionBean();
            if (null != sysFunc) {
                Boolean result = false;
                if (field != null && field.length == 2) {
                    Class<?> sysFuncClass = sysFunc.getClass();
                    try {
                        Field field1 = sysFuncClass.getField(field[0]);
                        try {
                            Object obj = field1.get(sysFunc);
                            Class<?> objClass = obj.getClass();
                            Field field2 = objClass.getField(field[1]);
                            result = (Boolean)field2.get(obj);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                }
                if (null != listener) {
                    listener.onSuccess(devId, 0, result);
                }
                return result;
            }
            if (null != this.devDataCenterListener) {
                this.devDataCenterListener.getConfigFromDev(devId, listener, "SystemFunction", field);
            }
            return false;
        }
        if (null != listener) {
            listener.onFailed(devId, 0, "SystemFunction", -1);
        }
        return false;
    }

    public void getSystemFunction(String devId, DeviceManager.OnDevManagerListener listener) {
        XMDevInfo info;
        if (this.xmDevInfos.containsKey(devId) && null != (info = this.xmDevInfos.get(devId))) {
            SystemFunctionBean sysFunc = info.getSystemFunctionBean();
            if (null != sysFunc) {
                if (null != listener) {
                    listener.onSuccess(devId, 0, sysFunc);
                }
            } else if (null != this.devDataCenterListener) {
                this.devDataCenterListener.getConfigFromDev(devId, listener, "SystemFunction", new String[0]);
            }
            return;
        }
        if (null != listener) {
            listener.onFailed(devId, 0, "SystemFunction", -1);
        }
    }

    @Override
    public boolean isSupportAlarmConfig(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "AlarmConfig");
    }

    @Override
    public boolean isSupportBlindDetect(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "BlindDetect");
    }

    @Override
    public boolean isSupportLossDetect(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "LossDetect");
    }

    @Override
    public boolean isSupportMotionDetect(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "MotionDetect");
    }

    @Override
    public boolean isSupportNetAbort(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "NetAbort");
    }

    @Override
    public boolean isSupportNetAlarm(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "NetAlarm");
    }

    @Override
    public boolean isSupportNetIpConflict(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "NetIpConflict");
    }

    @Override
    public boolean isSupportStorageFailure(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "StorageFailure");
    }

    @Override
    public boolean isSupportStorageLowSpace(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "StorageLowSpace");
    }

    @Override
    public boolean isSupportStorageNotExist(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "StorageNotExist");
    }

    @Override
    public boolean isSupportConsumer433Alarm(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "Consumer433Alarm");
    }

    @Override
    public boolean isSupportConsumerRemote(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "ConsumerRemote");
    }

    @Override
    public boolean isSupportIPCAlarm(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "IPCAlarm");
    }

    @Override
    public boolean isSupportNetAbortExtend(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "NetAbortExtend");
    }

    @Override
    public boolean isSupportSensorAlarmCenter(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "SensorAlarmCenter");
    }

    @Override
    public boolean isSupportSerialAlarm(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "SerialAlarm");
    }

    @Override
    public boolean isSupportVideoAnalyze(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "VideoAnalyze");
    }

    @Override
    public boolean isSupportNewVideoAnalyze(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "AlarmFunction", "NewVideoAnalyze");
    }

    @Override
    public boolean isSupportDoubleStream(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "EncodeFunction", "DoubleStream");
    }

    @Override
    public boolean isSupportSnapStream(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "EncodeFunction", "SnapStream");
    }

    @Override
    public boolean isSupportWaterMark(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "EncodeFunction", "WaterMark");
    }

    @Override
    public boolean isSupportCombineStream(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "EncodeFunction", "CombineStream");
    }

    @Override
    public boolean isSupportSmartH264(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "EncodeFunction", "SmartH264");
    }

    @Override
    public boolean isSupportNet3G(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "Net3G");
    }

    @Override
    public boolean isSupportNetARSP(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetARSP");
    }

    @Override
    public boolean isSupportNetAlarmCenter(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetAlarmCenter");
    }

    @Override
    public boolean isSupportNetDDNS(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetDDNS");
    }

    @Override
    public boolean isSupportNetDHCP(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetDHCP");
    }

    @Override
    public boolean isSupportNetDNS(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetDNS");
    }

    @Override
    public boolean isSupportNetEmail(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetEmail");
    }

    @Override
    public boolean isSupportNetFTP(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetFTP");
    }

    @Override
    public boolean isSupportNetIPFilter(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetIPFilter");
    }

    @Override
    public boolean isSupportNetMobile(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetMobile");
    }

    @Override
    public boolean isSupportNetMutlicast(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetMutlicast");
    }

    @Override
    public boolean isSupportNetNTP(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetNTP");
    }

    @Override
    public boolean isSupportNetPPPoE(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetPPPoE");
    }

    @Override
    public boolean isSupportNetWifi(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetWifi");
    }

    @Override
    public boolean isSupportNetWifiMode(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "NetServerFunction", "NetWifiMode");
    }

    @Override
    public boolean isSupportDownLoadPause(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "DownLoadPause");
    }

    @Override
    public boolean isSupportUSBsupportRecord(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "USBsupportRecord");
    }

    @Override
    public boolean isSupportSDsupportRecord(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SDsupportRecord");
    }

    @Override
    public boolean isSupportSupportOnvifClient(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportOnvifClient");
    }

    @Override
    public boolean isSupportSupportNetLocalSearch(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportNetLocalSearch");
    }

    @Override
    public boolean isSupportSupportMaxPlayback(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportMaxPlayback");
    }

    @Override
    public boolean isSupportSupportNVR(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportNVR");
    }

    @Override
    public boolean isSupportSupportC7Platform(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportC7Platform");
    }

    @Override
    public boolean isSupportSupportMailTest(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportMailTest");
    }

    @Override
    public boolean isSupportHideDigital(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "HideDigital");
    }

    @Override
    public boolean isSupportNotSupportAH(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "NotSupportAH");
    }

    @Override
    public boolean isSupportNotSupportAV(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "NotSupportAV");
    }

    @Override
    public boolean isSupportSupportBT(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportBT");
    }

    @Override
    public boolean isSupportNotSupportTalk(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "NotSupportTalk");
    }

    @Override
    public boolean isSupportAlterDigitalName(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "AlterDigitalName");
    }

    @Override
    public boolean isSupportSupportShowConnectStatus(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportShowConnectStatus");
    }

    @Override
    public boolean isSupportSupportPlayBackExactSeek(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportPlayBackExactSeek");
    }

    @Override
    public boolean isSupportTitleAndStateUpload(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "TitleAndStateUpload");
    }

    @Override
    public boolean isSupportMusicFilePlay(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "MusicFilePlay");
    }

    @Override
    public boolean isSupportSupportSetDigIP(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportSetDigIP");
    }

    @Override
    public boolean isSupportSupportShowProductType(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportShowProductType");
    }

    @Override
    public boolean isSupportSupportCamareStyle(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportCamareStyle");
    }

    @Override
    public boolean isSupportSupportonviftitle(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "Supportonviftitle");
    }

    @Override
    public boolean isSupportShowFalseCheckTime(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "ShowFalseCheckTime");
    }

    @Override
    public boolean isSupportSupportStatusLed(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportStatusLed");
    }

    @Override
    public boolean isSupportSupportLowLuxMode(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportLowLuxMode");
    }

    @Override
    public boolean isSupportSupportSlowMotion(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportSlowMotion");
    }

    @Override
    public boolean isSupportSupportTimeZone(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportTimeZone");
    }

    @Override
    public boolean isSupportSupportImpRecord(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportImpRecord");
    }

    @Override
    public boolean isSupportXMModeSwitch(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "XMModeSwitch");
    }

    @Override
    public boolean isSupportSupportIntelligentPlayBack(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportIntelligentPlayBack");
    }

    @Override
    public boolean isSupportSupportNetWorkMode(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportNetWorkMode");
    }

    @Override
    public boolean isSupportSupportSetPTZPresetAttribute(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportSetPTZPresetAttribute");
    }

    @Override
    public boolean isSupportSupportConsSensorAlarmLink(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportConsSensorAlarmLink");
    }

    @Override
    public boolean isSupportSupportDeviceInfoNew(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportDeviceInfoNew");
    }

    @Override
    public boolean isSupportSupportContinueUpgrade(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportContinueUpgrade");
    }

    @Override
    public boolean isSupportSupportRecordingFunction(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportRecordingFunction");
    }

    @Override
    public boolean isSupportSupportAudioPlay(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportAudioPlay");
    }

    @Override
    public boolean isSupportSupportPTZTour(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportPTZTour");
    }

    @Override
    public boolean isSupportTalk(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "PreviewFunction", "Talk");
    }

    @Override
    public boolean isSupportTour(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "PreviewFunction", "Tour");
    }

    @Override
    public boolean isSupportNotifyLight(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportNotifyLight");
    }

    @Override
    public boolean isSupportPirAlarm(String devId, DeviceManager.OnDevManagerListener listener) {
        return this.getSystemFunctionItemValue(devId, listener, "OtherFunction", "SupportPirAlarm");
    }

    public int getPushType() {
        return this.pushType;
    }

    public void setPushType(int pushType) {
        this.pushType = pushType;
    }

    public SMCInitInfo getSmcInitInfo() {
        return this.smcInitInfo;
    }

    public void setSmcInitInfo(SMCInitInfo smcInitInfo) {
        this.smcInitInfo = smcInitInfo;
    }

    public String getAccountUserName() {
        return this.accountUserName;
    }

    public void setAccountUserName(String accountUserName) {
        this.accountUserName = accountUserName;
    }

    public String getAccountPassword() {
        return this.accountPassword;
    }

    public void setAccountPassword(String accountPassword) {
        this.accountPassword = accountPassword;
    }

    public int getLoginType() {
        return this.loginType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
        ThreadUtils.newSingleThreadExecutor(new Runnable(){

            @Override
            public void run() {
                String szLoginParams = FunSDK.SysGetCurLoginParams();
                HashMap loginParamsMap = new HashMap();
                DevDataCenter.this.parseLoginParams(szLoginParams, loginParamsMap);
                DevDataCenter.this.accessToken = (String)loginParamsMap.get("accessToken");
                LogUtils.debugInfo("accessToken", DevDataCenter.this.accessToken);
            }
        });
    }

    public int getAppLoginOemType() {
        return this.appLoginOemType;
    }

    public void setAppLoginOemType(int appLoginOemType) {
        this.appLoginOemType = appLoginOemType;
    }

    public void setHasRecordFile(int time, boolean hasRecord) {
        if (this.recordFileMap == null) {
            this.recordFileMap = new TreeMap();
        }
        this.recordFileMap.put(time, hasRecord);
    }

    public TreeMap getHasRecordFile() {
        if (this.recordFileMap == null) {
            this.recordFileMap = new TreeMap();
        }
        return this.recordFileMap;
    }

    public List<String> getDevList() {
        return this.devList;
    }

    public void clear() {
        if (this.devList != null) {
            this.devList.clear();
        }
        if (this.recordFileMap != null) {
            this.recordFileMap.clear();
        }
        if (this.xmDevInfos != null) {
            this.xmDevInfos.clear();
        }
        if (this.devDataCenterListener != null) {
            this.devDataCenterListener.clearDevConfigs();
        }
        this.loginType = 0;
        this.appLoginOemType = 0;
    }

    public synchronized String getAccessToken() {
        if (!this.isLoginByAccount()) {
            return null;
        }
        if (!StringUtils.isStringNULL(this.accessToken)) {
            return this.accessToken;
        }
        String szLoginParams = FunSDK.SysGetCurLoginParams();
        HashMap<String, String> loginParamsMap = new HashMap<String, String>();
        this.parseLoginParams(szLoginParams, loginParamsMap);
        this.accessToken = loginParamsMap.get("accessToken");
        LogUtils.debugInfo("accessToken", this.accessToken);
        return this.accessToken;
    }

    public void setAccessToken(String token) {
        this.accessToken = token;
    }

    private void parseLoginParams(String params, HashMap<String, String> result) {
        if (params == null || result == null) {
            return;
        }
        try {
            String[] maps;
            for (String map : maps = params.split("&&")) {
                String[] item;
                if (StringUtils.isStringNULL(map) || (item = map.split("=")).length != 2) continue;
                result.put(item[0], item[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<OtherShareDevUserBean> getOtherShareDevUserBeanList() {
        return this.otherShareDevUserBeanList;
    }

    public void setOtherShareDevUserBeanList(List<OtherShareDevUserBean> otherShareDevUserBeanList) {
        this.otherShareDevUserBeanList = otherShareDevUserBeanList;
    }

    public static interface OnDevDataCenterListener {
        public void getConfigFromDev(String var1, DeviceManager.OnDevManagerListener var2, String var3, String ... var4);

        public void clearDevConfigs();

        public void clearDevConfig(String var1);
    }
}

