/*
 * Decompiled with CFR 0.152.
 */
package com.manager.account;

import android.os.Message;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.basic.G;
import com.lib.FunSDK;
import com.lib.MsgContent;
import com.lib.constant.DevType;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDBDeviceInfo;
import com.manager.XMFunSDKManager;
import com.manager.account.BaseAccountManager;
import com.manager.account.XMAccountInterface;
import com.manager.account.code.AccountCode;
import com.manager.account.serverinteraction.AccountServerInteraction;
import com.manager.db.Define;
import com.manager.db.DevDataCenter;
import com.manager.db.XMDevInfo;
import com.manager.db.XMUserInfo;
import com.utils.AESECBUtils;
import com.utils.SignatureUtil;
import com.utils.TimeMillisUtil;
import com.xm.base.OkHttpManager;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class XMAccountManager
extends BaseAccountManager
implements XMAccountInterface {
    protected String username;
    protected String password;
    protected XMUserInfo xmUserInfo;
    protected AccountServerInteraction accountServerInteraction;
    protected static XMAccountManager xmAccountManager;

    protected XMAccountManager(String username, String password) {
        this.username = username;
        this.password = password;
    }

    protected XMAccountManager() {
        this.accountServerInteraction = OkHttpManager.createOkHttp(Define.RS_BASE_URL, AccountServerInteraction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XMAccountManager getInstance() {
        if (null != xmAccountManager) return xmAccountManager;
        Class<XMAccountManager> clazz = XMAccountManager.class;
        synchronized (XMAccountManager.class) {
            if (null != xmAccountManager) return xmAccountManager;
            xmAccountManager = new XMAccountManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return xmAccountManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaseAccountManager getInstance(String userName, String password) {
        if (null != xmAccountManager) return xmAccountManager;
        Class<XMAccountManager> clazz = XMAccountManager.class;
        synchronized (XMAccountManager.class) {
            if (null != xmAccountManager) return xmAccountManager;
            xmAccountManager = new XMAccountManager();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return xmAccountManager;
        }
    }

    @Override
    public boolean init() {
        if (!this.isInit && this.xmFunSDKManager.init()) {
            int iRet = FunSDK.SysInitNet((String)"", (int)0);
            boolean bl = this.isInit = iRet >= 0;
        }
        if (this.isInit) {
            super.init();
        }
        return this.isInit;
    }

    @Override
    public void unInit() {
        super.unInit();
        this.isLogined = false;
    }

    @Override
    public boolean getUserInfo(BaseAccountManager.OnAccountManagerListener ls) {
        if (this.xmUserInfo != null && ls != null) {
            ls.onSuccess(5049);
            return true;
        }
        this.listenerHashMap.put(5049, ls);
        if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.password)) {
            this.username = DevDataCenter.getInstance().getAccountUserName();
            this.password = DevDataCenter.getInstance().getAccountPassword();
            if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.password)) {
                return false;
            }
        }
        this.init();
        int result = FunSDK.SysGetUerInfo((int)this.userId, (String)this.username, (String)this.password, (int)0);
        return result == 0;
    }

    @Override
    public void updateUserInfo() {
        if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.password)) {
            this.username = DevDataCenter.getInstance().getAccountUserName();
            this.password = DevDataCenter.getInstance().getAccountPassword();
            if (TextUtils.isEmpty((CharSequence)this.username) || TextUtils.isEmpty((CharSequence)this.password)) {
                return;
            }
        }
        this.init();
        FunSDK.SysGetUerInfo((int)this.userId, (String)this.username, (String)this.password, (int)0);
    }

    @Override
    public boolean checkUserName(String userName, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5046, ls);
        this.init();
        int result = FunSDK.SysCheckUserRegiste((int)this.userId, (String)userName, (int)0);
        return result == 0;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getUserName() {
        if (this.xmUserInfo != null) {
            return this.xmUserInfo.getUserName();
        }
        return this.username;
    }

    @Override
    public String getAccountName() {
        return this.username;
    }

    @Override
    public void checkQrCodeForPcLogin(String qrCode, final OkHttpManager.OnOkHttpListener<Boolean> onOkHttpListener) {
        if (StringUtils.isStringNULL(qrCode)) {
            if (onOkHttpListener != null) {
                onOkHttpListener.onFailed(-1, "qrCode is null");
            }
            return;
        }
        String[] results = qrCode.split("qrLogin=");
        String qrLogin = null;
        try {
            qrLogin = AESECBUtils.decryptToBase64(results[1], "SFpASnVGZW5nMjAy", false);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (onOkHttpListener != null) {
                onOkHttpListener.onFailed(-2, "QR code data decryption failed");
            }
            return;
        }
        if (qrLogin == null) {
            if (onOkHttpListener != null) {
                onOkHttpListener.onFailed(-2, "QR code data decryption failed");
            }
            return;
        }
        String token = "";
        JSONObject jsonObject = JSON.parseObject((String)qrLogin);
        if (jsonObject.containsKey((Object)"token")) {
            token = jsonObject.getString("token");
        }
        if (StringUtils.isStringNULL(token)) {
            if (onOkHttpListener != null) {
                onOkHttpListener.onFailed(-3, "Token parsing failed");
            }
            return;
        }
        String timeMillis = TimeMillisUtil.getTimMillis();
        try {
            String userId = FunSDK.GetFunStrAttr((int)12);
            if (StringUtils.isStringNULL(userId)) {
                if (onOkHttpListener != null) {
                    onOkHttpListener.onFailed(AccountCode.NOT_LOGIN.getCode(), AccountCode.NOT_LOGIN.getMessage());
                }
                return;
            }
            String appUuid = XMFunSDKManager.getInstance().getAppUuid();
            String appKey = XMFunSDKManager.getInstance().getAppKey();
            String appSecret = XMFunSDKManager.getInstance().getAppSecret();
            int appMovecard = XMFunSDKManager.getInstance().getAppMovecard();
            String secret = SignatureUtil.getEncryptStr(appUuid, appKey, appSecret, timeMillis, appMovecard);
            Call<ResponseBody> call = this.accountServerInteraction.checkQrCodeForPcLogin(appUuid, appKey, "v1", timeMillis, secret, userId, token);
            call.enqueue(OkHttpManager.createCallbackForJson(new OkHttpManager.OnOkHttpListener<String>(){

                @Override
                public void onSuccess(String originalJsonData, String jsonData) {
                    try {
                        boolean isExpired = true;
                        boolean isLimit = true;
                        JSONObject jsonObject = JSON.parseObject((String)jsonData);
                        if (jsonObject != null) {
                            if (jsonObject.containsKey((Object)"expired")) {
                                isExpired = jsonObject.getBoolean("expired");
                            }
                            if (jsonObject.containsKey((Object)"limit")) {
                                isLimit = jsonObject.getBoolean("limit");
                            }
                        }
                        if (!isExpired && !isLimit) {
                            if (onOkHttpListener != null) {
                                onOkHttpListener.onSuccess(originalJsonData, true);
                            }
                        } else if (onOkHttpListener != null) {
                            onOkHttpListener.onSuccess(originalJsonData, false);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void onFailed(int errorId, String errorMsg) {
                    if (onOkHttpListener != null) {
                        onOkHttpListener.onFailed(errorId, errorMsg);
                    }
                }
            }, AccountCode.class));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void syncDevInfoToDataCenter(String devListJson) {
        FunSDK.SysSyncDevInfoToDataCenter((String)devListJson);
    }

    @Override
    public void supportWakeUpToSDK(String devId) {
        SDBDeviceInfo sdbDeviceInfo = new SDBDeviceInfo();
        G.SetValue((byte[])sdbDeviceInfo.st_0_Devmac, (String)devId);
        sdbDeviceInfo.st_7_nType = (Integer)DevType.IDR.getCode();
        FunSDK.AddDevInfoToDataCenter((byte[])G.ObjToBytes((Object)sdbDeviceInfo), (int)0, (int)0, (String)"");
    }

    @Override
    public void modifyDevName(String devId, String devName, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5005, ls);
        XMDevInfo xmDevInfo = DevDataCenter.getInstance().getDevInfo(devId);
        if (xmDevInfo != null) {
            xmDevInfo.setDevName(devName);
            FunSDK.SysChangeDevInfo((int)this.userId, (byte[])G.ObjToBytes((Object)xmDevInfo.getSdbDevInfo()), (String)"", (String)"", (int)0);
        }
    }

    @Override
    public boolean login(String username, String password, int loginType, BaseAccountManager.OnAccountManagerListener ls) {
        this.username = username;
        this.password = password;
        DevDataCenter.getInstance().setAccountUserName(username);
        DevDataCenter.getInstance().setAccountPassword(password);
        this.listenerHashMap.put(5000, ls);
        if (StringUtils.isStringNULL(username)) {
            return false;
        }
        if (StringUtils.isStringNULL(password)) {
            return false;
        }
        this.init();
        FunSDK.SysGetDevList((int)this.userId, (String)username, (String)password, (int)0);
        DevDataCenter.getInstance().setLoginType(loginType);
        return true;
    }

    @Override
    public boolean loginByUnionId(String unionId, String name, int loginType, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5000, ls);
        this.init();
        int loginOemType = DevDataCenter.getInstance().getAppLoginOemType();
        if (loginType == 7) {
            FunSDK.SysGetDevListEx((int)this.userId, (String)unionId, (String)("fb_" + name), (int)loginOemType, (int)0);
        } else if (loginType == 5) {
            FunSDK.SysGetDevListEx((int)this.userId, (String)unionId, (String)name, (int)loginOemType, (int)0);
        } else if (loginType == 8) {
            FunSDK.SysGetDevListEx((int)this.userId, (String)unionId, (String)("gg_" + name), (int)loginOemType, (int)0);
        } else if (loginType == 10) {
            FunSDK.SysGetDevListEx((int)this.userId, (String)unionId, (String)name, (int)loginOemType, (int)0);
        } else {
            FunSDK.SysGetDevListEx((int)this.userId, (String)unionId, (String)name, (int)loginOemType, (int)0);
        }
        DevDataCenter.getInstance().setLoginType(loginType);
        return true;
    }

    @Override
    public boolean loginByCode(String emailOrPhoneNo, String code, int appType, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5077, ls);
        if (StringUtils.isStringNULL(emailOrPhoneNo)) {
            return false;
        }
        if (StringUtils.isStringNULL(code)) {
            return false;
        }
        this.init();
        this.username = emailOrPhoneNo;
        FunSDK.SysSmsGetDevList((int)this.userId, (String)emailOrPhoneNo, (String)code, (int)appType, (int)0);
        DevDataCenter.getInstance().setLoginType(9);
        return true;
    }

    @Override
    public void logout() {
        this.unInit();
        this.username = null;
        this.password = null;
        FunSDK.SysLogout((int)this.userId, (int)0);
        DevDataCenter.getInstance().clear();
    }

    @Override
    public boolean updateDevListFromServer(BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5093, ls);
        this.init();
        FunSDK.SysGetCurrentUserDevList((int)this.userId, (int)0);
        return true;
    }

    @Override
    public int OnFunSDKResult(Message msg, MsgContent ex) {
        if (msg.arg1 >= 0) {
            switch (msg.what) {
                case 5049: {
                    String dataJson;
                    JSONObject jsonObject;
                    if (!StringUtils.isStringNULL(ex.str) && (jsonObject = JSONObject.parseObject((String)ex.str)) != null && jsonObject.containsKey((Object)"code") && jsonObject.getInteger("code") == 2000 && !StringUtils.isStringNULL(dataJson = jsonObject.getString("data"))) {
                        this.xmUserInfo = (XMUserInfo)JSON.parseObject((String)dataJson, XMUserInfo.class);
                        if (this.xmUserInfo != null) {
                            this.triggeredListener(msg, ex, true);
                            return 0;
                        }
                    }
                    this.triggeredListener(msg, ex, false);
                    return 0;
                }
                case 5050: 
                case 5051: 
                case 5054: 
                case 5055: 
                case 5078: 
                case 5079: {
                    this.triggeredListener(msg, ex, true);
                    return 0;
                }
            }
        }
        return super.OnFunSDKResult(msg, ex);
    }

    @Override
    public boolean sendEmailCodeForResetPwd(String email, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5043, ls);
        this.init();
        int result = FunSDK.SysSendCodeForEmail((int)this.userId, (String)email, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendPhoneCodeForResetPwd(String phone, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5014, ls);
        this.init();
        int result = FunSDK.SysForgetPwdXM((int)this.userId, (String)phone, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendCodeForAccountLogin(String emailOrPhoneNo, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5076, ls);
        this.init();
        int result = FunSDK.SysGetLoginAccountCode((int)this.userId, (String)emailOrPhoneNo, (int)0);
        return result == 0;
    }

    @Override
    public boolean verifyEmailCode(String email, String verifyCode, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5044, ls);
        this.init();
        int result = FunSDK.SysCheckCodeForEmail((int)this.userId, (String)email, (String)verifyCode, (int)0);
        return result == 0;
    }

    @Override
    public boolean verifyPhoneCode(String phone, String verifyCode, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5015, ls);
        this.init();
        int result = FunSDK.CheckResetCodeXM((int)this.userId, (String)phone, (String)verifyCode, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendSendGlobalPhoneCode(String areaCode, String phone, XMAccountInterface.SEND_CODE_USE sendCodeUse, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5082, ls);
        this.init();
        String countryPhoneNum = String.format("%s:%s", areaCode, phone);
        String verifyCode = "";
        if (sendCodeUse == XMAccountInterface.SEND_CODE_USE.REGISTER) {
            verifyCode = "re";
        } else if (sendCodeUse == XMAccountInterface.SEND_CODE_USE.FORGET) {
            verifyCode = "fp";
        } else if (sendCodeUse == XMAccountInterface.SEND_CODE_USE.BIND) {
            verifyCode = "bin";
        }
        int result = FunSDK.SysSendGlobalPhoneCode((int)this.userId, (String)countryPhoneNum, (String)verifyCode, (int)0);
        return result == 0;
    }

    @Override
    public boolean resetPwdByEmail(String email, String newPassw, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5045, ls);
        this.init();
        int result = FunSDK.SysChangePwdByEmail((int)this.userId, (String)email, (String)newPassw, (int)0);
        return result == 0;
    }

    @Override
    public boolean resetPwdByPhone(String phone, String newPassw, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5016, ls);
        this.init();
        int result = FunSDK.ResetPwdXM((int)this.userId, (String)phone, (String)newPassw, (int)0);
        return result == 0;
    }

    @Override
    public void register(String userName, String password, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5011, ls);
        this.init();
        FunSDK.SysRegUserToXM((int)this.userId, (String)userName, (String)password, (String)"", (String)"", (int)0);
    }

    @Override
    public boolean registerByPhoneNo(String userName, String password, String code, String phoneNo, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5011, ls);
        this.init();
        int result = FunSDK.SysRegUserToXM((int)this.userId, (String)userName, (String)password, (String)code, (String)phoneNo, (int)0);
        return result == 0;
    }

    @Override
    public boolean registerByEmail(String userName, String password, String email, String code, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5042, ls);
        this.init();
        int result = FunSDK.SysRegisteByEmail((int)this.userId, (String)userName, (String)password, (String)email, (String)code, (int)0);
        return result == 0;
    }

    @Override
    public boolean deleteXMAccount(String code, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5075, ls);
        this.init();
        int result = FunSDK.SysCancellationAccount((int)this.userId, (String)code, (int)0);
        return result == 0;
    }

    @Override
    public boolean bindXMAccount(String userName, String password, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(8504, ls);
        this.init();
        int result = FunSDK.SysBindingAccount((int)this.userId, (String)userName, (String)password, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendPhoneCodeForBind(String phoneNum, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5050, ls);
        this.init();
        int result = FunSDK.SysGetVerCodeForBindPhone((int)this.userId, (String)phoneNum, (int)0);
        return result == 0;
    }

    @Override
    public boolean bindPhoneAccount(String phoneNum, String code, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5051, ls);
        this.init();
        int result = FunSDK.SysAccountBindPhone((int)this.userId, (String)phoneNum, (String)code, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendEmailCodeForBind(String email, String username, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5054, ls);
        this.init();
        int result = FunSDK.SysGetVerCodeForBindEmail((int)this.userId, (String)email, (String)username, (int)0);
        return result == 0;
    }

    @Override
    public boolean bindEmailAccount(String email, String code, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5055, ls);
        this.init();
        int result = FunSDK.SysAccountBindEmail((int)this.userId, (String)email, (String)code, (int)0);
        return result == 0;
    }

    @Override
    public boolean bindWeChatAccount(String unionId, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5079, ls);
        this.init();
        int loginOemType = DevDataCenter.getInstance().getAppLoginOemType();
        int reuslt = FunSDK.SysThirdPartyBindAccount((int)this.userId, (String)this.username, (String)this.password, (String)unionId, (String)"wx", (int)loginOemType, (int)0);
        return reuslt == 0;
    }

    @Override
    public boolean unBindWeChatAccount(BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5078, ls);
        this.init();
        int reuslt = FunSDK.SysUserWXUnbind((int)this.userId, (int)0);
        return reuslt == 0;
    }

    @Override
    public boolean sendEmailCodeForRegister(String email, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5041, ls);
        this.init();
        int result = FunSDK.SysSendEmailCode((int)this.userId, (String)email, (int)0);
        return result == 0;
    }

    @Override
    public boolean sendPhoneCodeForRegister(String userName, String phoneNo, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5010, ls);
        this.init();
        int result = FunSDK.SysSendPhoneMsg((int)this.userId, (String)userName, (String)phoneNo, (int)0);
        return result == 0;
    }

    @Override
    public boolean hasLogin() {
        return this.isLogined;
    }

    @Override
    public boolean checkPwd(String password, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5039, ls);
        this.init();
        int result = FunSDK.SysCheckPwdStrength((int)this.userId, (String)password, (int)0);
        return result == 0;
    }

    @Override
    public boolean modifyPwd(String userName, String oldPassw, String newPassw, BaseAccountManager.OnAccountManagerListener ls) {
        this.listenerHashMap.put(5013, ls);
        this.init();
        int result = FunSDK.SysEditPwdXM((int)this.userId, (String)userName, (String)oldPassw, (String)newPassw, (int)0);
        return result == 0;
    }

    public XMUserInfo getXmUserInfo() {
        return this.xmUserInfo;
    }

    public static enum Operation {
        REGISTER,
        GETCODE,
        FORGOTPWD,
        ADDDEV,
        DELDEV;

    }
}

