/*
 * Decompiled with CFR 0.152.
 */
package com.manager;

import android.app.Activity;
import android.content.ContentResolver;
import android.os.Handler;
import android.provider.Settings;
import java.util.HashMap;

public class ScreenOrientationManager {
    private static final int CHANGE_SENSOR_TIME = 2000;
    private Handler handler;
    private Runnable runnable;
    private HashMap<Integer, Boolean> addManagerMaps = new HashMap();
    private static ScreenOrientationManager manager;

    private ScreenOrientationManager() {
    }

    public static synchronized ScreenOrientationManager getInstance() {
        if (manager == null) {
            manager = new ScreenOrientationManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portraitScreen(Activity activity, boolean afterSensor) {
        try {
            HashMap<Integer, Boolean> hashMap = this.addManagerMaps;
            synchronized (hashMap) {
                this.addManagerMaps.put(activity.hashCode(), true);
            }
            activity.setRequestedOrientation(1);
            if (afterSensor) {
                this.changeScreenOrientationSensor(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void landscapeScreen(Activity activity, boolean afterSensor) {
        try {
            HashMap<Integer, Boolean> hashMap = this.addManagerMaps;
            synchronized (hashMap) {
                this.addManagerMaps.put(activity.hashCode(), true);
            }
            activity.setRequestedOrientation(0);
            if (afterSensor) {
                this.changeScreenOrientationSensor(activity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sensorScreen(Activity activity) {
        try {
            HashMap<Integer, Boolean> hashMap = this.addManagerMaps;
            synchronized (hashMap) {
                this.addManagerMaps.put(activity.hashCode(), true);
            }
            if (ScreenOrientationManager.getSystemSettingAccelerometer(activity) == 1) {
                activity.setRequestedOrientation(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Activity activity) {
        try {
            HashMap<Integer, Boolean> hashMap = this.addManagerMaps;
            synchronized (hashMap) {
                if (this.addManagerMaps.containsKey(activity.hashCode())) {
                    this.addManagerMaps.remove(activity.hashCode());
                }
                if (this.addManagerMaps.isEmpty()) {
                    if (this.runnable != null && this.handler != null) {
                        this.handler.removeCallbacks(this.runnable);
                        this.runnable = null;
                        this.handler = null;
                    }
                    if (activity != null) {
                        activity.setRequestedOrientation(4);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void changeScreenOrientationSensor(final Activity activity) {
        try {
            if (ScreenOrientationManager.getSystemSettingAccelerometer(activity) == 1) {
                if (this.runnable != null && this.handler != null) {
                    this.handler.removeCallbacks(this.runnable);
                }
                this.runnable = new Runnable(){

                    @Override
                    public void run() {
                        activity.setRequestedOrientation(4);
                        ScreenOrientationManager.this.handler.removeCallbacks(ScreenOrientationManager.this.runnable);
                    }
                };
                this.handler = new Handler();
                this.handler.postDelayed(this.runnable, 2000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getSystemSettingAccelerometer(Activity activity) {
        if (activity == null) {
            return 0;
        }
        int value = 0;
        try {
            value = Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"accelerometer_rotation");
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        return value;
    }
}

