/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.struct;

import com.basic.G;
import com.lib.sdk.bean.StringUtils;
import com.lib.sdk.struct.SDK_SYSTEM_TIME;
import com.manager.device.media.attribute.RecordPlayerAttribute;
import com.utils.TimeUtils;
import com.utils.XUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class H264_DVR_FILE_DATA
implements Serializable {
    public int st_0_ch = 0;
    public int st_1_size = 0;
    public byte[] st_2_fileName = new byte[108];
    public SDK_SYSTEM_TIME st_3_beginTime = new SDK_SYSTEM_TIME();
    public SDK_SYSTEM_TIME st_4_endTime = new SDK_SYSTEM_TIME();
    public long st_5_wnd = 0L;
    public int st_6_StreamType;
    public int downloadStatus = -1;
    public int downloadType = 0;
    public boolean isChecked;
    public double currentPos = 0.0;
    private int orderNum;
    private int fileType;
    public int seekPosition;
    public boolean isEffective = false;
    public String fileName;
    private String alarmExFileInfo;
    private RecordPlayerAttribute.RECORD_LEN_TYPE recordLenType = RecordPlayerAttribute.RECORD_LEN_TYPE.RECORD_LEN_NORMAL;

    public String toString() {
        return "H264_DVR_FILE_DATA [st_0_ch=" + this.st_0_ch + ", st_1_size=" + this.st_1_size + ", st_2_fileName=" + G.ToString((byte[])this.st_2_fileName) + ", st_3_beginTime=" + this.st_3_beginTime + ", st_4_endTime=" + this.st_4_endTime + ", st_5_wnd=" + this.st_5_wnd + "]";
    }

    public boolean equals(Object o) {
        if (null != o && o instanceof H264_DVR_FILE_DATA) {
            return this.toString().equals(((H264_DVR_FILE_DATA)o).toString());
        }
        return false;
    }

    public String getStartDate() {
        return String.format("%04d/%02d/%02d", this.st_3_beginTime.st_0_year, this.st_3_beginTime.st_1_month, this.st_3_beginTime.st_2_day);
    }

    public String getStartTimeOfDay() {
        return String.format("%02d:%02d:%02d", this.st_3_beginTime.st_4_hour, this.st_3_beginTime.st_5_minute, this.st_3_beginTime.st_6_second);
    }

    public String getStartTimeOfYear() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.st_3_beginTime.st_0_year - 1900, this.st_3_beginTime.st_1_month - 1, this.st_3_beginTime.st_2_day, this.st_3_beginTime.st_4_hour, this.st_3_beginTime.st_5_minute, this.st_3_beginTime.st_6_second));
    }

    public long getLongTimes(int hour, int minute, int second) {
        long times = hour * 3600 + minute * 60 + second;
        return times;
    }

    public long getLongStartTime() {
        return this.getLongTimes(this.st_3_beginTime.st_4_hour, this.st_3_beginTime.st_5_minute, this.st_3_beginTime.st_6_second);
    }

    public String getEndTimeOfDay() {
        return String.format("%02d:%02d:%02d", this.st_4_endTime.st_4_hour, this.st_4_endTime.st_5_minute, this.st_4_endTime.st_6_second);
    }

    public String getEndTimeOfYear() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(this.st_4_endTime.st_0_year - 1900, this.st_4_endTime.st_1_month - 1, this.st_4_endTime.st_2_day, this.st_4_endTime.st_4_hour, this.st_4_endTime.st_5_minute, this.st_4_endTime.st_6_second));
    }

    public long getLongEndTime() {
        return this.getLongTimes(this.st_4_endTime.st_4_hour, this.st_4_endTime.st_5_minute, this.st_4_endTime.st_6_second);
    }

    public long getLongEndTime24Hours() {
        if ((this.st_4_endTime.st_4_hour | this.st_4_endTime.st_5_minute | this.st_4_endTime.st_6_second) == 0) {
            Calendar sCalendar = TimeUtils.getNormalFormatCalender((String)this.getStartTimeOfYear());
            sCalendar.set(14, 0);
            int sTime = (int)(sCalendar.getTimeInMillis() / 1000L);
            Calendar eCalendar = TimeUtils.getNormalFormatCalender((String)this.getEndTimeOfYear());
            eCalendar.set(14, 0);
            int eTime = (int)(eCalendar.getTimeInMillis() / 1000L);
            if (eTime > sTime) {
                return 86400L;
            }
            return 0L;
        }
        return this.getLongEndTime();
    }

    public boolean isContain(long times) {
        return times >= this.getLongStartTime() && times < this.getLongEndTime24Hours();
    }

    public int contrast(long times) {
        if (this.isContain(times)) {
            return 0;
        }
        if (times >= this.getLongEndTime24Hours()) {
            return 1;
        }
        return -1;
    }

    public void setFileName(String fileName) {
        if (null != fileName) {
            this.st_2_fileName = fileName.getBytes();
            this.fileName = fileName;
        }
    }

    public String getFileName() {
        if (null == this.fileName) {
            this.fileName = G.ToString((byte[])this.st_2_fileName);
        }
        return this.fileName;
    }

    public RecordPlayerAttribute.RECORD_LEN_TYPE getRecordLenType() {
        return this.recordLenType;
    }

    public void setRecordLenType(RecordPlayerAttribute.RECORD_LEN_TYPE recordLenType) {
        this.recordLenType = recordLenType;
    }

    public void setAlarmExFileInfo(String alarmExFileInfo) {
        this.alarmExFileInfo = alarmExFileInfo;
    }

    public String getAlarmExFileInfo() {
        return this.alarmExFileInfo != null ? this.alarmExFileInfo : this.fileName;
    }

    public int getFileTimeLong() {
        return (int)(this.getLongEndTime() - this.getLongStartTime());
    }

    public int getStreamType() {
        return H264_DVR_FILE_DATA.getStreamType(G.ToString((byte[])this.st_2_fileName));
    }

    public static int getStreamType(String fileName) {
        int index_1;
        if (StringUtils.isStringNULL(fileName)) {
            return 0;
        }
        int index_0 = fileName.indexOf("(", 0);
        if (index_0 == (index_1 = fileName.indexOf(")", index_0))) {
            return 0;
        }
        String type = fileName.substring(index_0 + 1, index_1);
        if (XUtils.isInteger(type)) {
            return Integer.parseInt(type);
        }
        return 0;
    }
}

