/*
 * Decompiled with CFR 0.152.
 */
package com.lib.sdk.bean.cloudmedia;

import com.alibaba.fastjson.annotation.JSONField;
import com.lib.sdk.bean.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class CloudMediaFileInfoBean {
    @JSONField(name="IndexFile")
    private String indexFile;
    @JSONField(name="StartTime")
    public String startTime;
    @JSONField(name="StopTime")
    public String endTime;
    @JSONField(name="nMediaType")
    public String nMediaType;
    @JSONField(name="PicFlag")
    private String picFlag;
    @JSONField(name="StorageBucket")
    private String storageBucket;
    @JSONField(name="VideoSize")
    private String videoSize;

    public String toString() {
        return "startTime:" + this.startTime + " endTime:" + this.endTime;
    }

    public Date getStartTimeByYear() {
        if (StringUtils.isStringNULL(this.startTime)) {
            return Calendar.getInstance().getTime();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(this.startTime);
            if (null != date) {
                return date;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return Calendar.getInstance().getTime();
    }

    public Date getEndTimeByYear() {
        if (StringUtils.isStringNULL(this.endTime)) {
            return Calendar.getInstance().getTime();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            Date date = format.parse(this.endTime);
            if (null != date) {
                return date;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return Calendar.getInstance().getTime();
    }

    public long getStartTimes() {
        Date date = this.getStartTimeByYear();
        if (null != date) {
            long times = date.getHours() * 3600 + date.getMinutes() * 60 + date.getSeconds();
            return times;
        }
        return 0L;
    }

    public long getEndTimes() {
        Date date = this.getEndTimeByYear();
        if (null != date) {
            long times = date.getHours() * 3600 + date.getMinutes() * 60 + date.getSeconds();
            return times;
        }
        return 0L;
    }

    public int getFileTimeLong() {
        return (int)(this.getEndTimes() - this.getStartTimes());
    }

    public String getIndexFile() {
        return this.indexFile;
    }

    public void setIndexFile(String indexFile) {
        this.indexFile = indexFile;
    }

    public String getPicFlag() {
        return this.picFlag;
    }

    public void setPicFlag(String picFlag) {
        this.picFlag = picFlag;
    }

    public String getStorageBucket() {
        return this.storageBucket;
    }

    public void setStorageBucket(String storageBucket) {
        this.storageBucket = storageBucket;
    }

    public String getVideoSize() {
        return this.videoSize;
    }

    public void setVideoSize(String videoSize) {
        this.videoSize = videoSize;
    }
}

