/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.search.le;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import com.inuker.bluetooth.library.search.BluetoothSearcher;
import com.inuker.bluetooth.library.search.SearchResult;
import com.inuker.bluetooth.library.search.response.BluetoothSearchResponse;
import com.inuker.bluetooth.library.utils.BluetoothLog;
import com.inuker.bluetooth.library.utils.BluetoothUtils;
import com.utils.LogUtils;
import java.util.List;

public class BluetoothLESearcher
extends BluetoothSearcher {
    private final ScanCallback mLeScanCallback = new ScanCallback(){

        public void onBatchScanResults(List<ScanResult> results) {
            super.onBatchScanResults(results);
        }

        public void onScanResult(int callbackType, ScanResult result) {
            super.onScanResult(callbackType, result);
            LogUtils.debugInfo("[APP_BLE]->", result.getDevice().getAddress());
            BluetoothLESearcher.this.notifyDeviceFounded(new SearchResult(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes()));
        }

        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            LogUtils.debugInfo("[APP_BLE]->", "scan error:" + errorCode);
        }
    };

    private BluetoothLESearcher() {
        this.mBluetoothAdapter = BluetoothUtils.getBluetoothAdapter();
    }

    public static BluetoothLESearcher getInstance() {
        return BluetoothLESearcherHolder.instance;
    }

    @Override
    @TargetApi(value=18)
    public void startScanBluetooth(BluetoothSearchResponse response) {
        super.startScanBluetooth(response);
        if (this.mBluetoothAdapter != null) {
            ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(2).build();
            this.mBluetoothAdapter.getBluetoothLeScanner().startScan(null, scanSettings, this.mLeScanCallback);
        }
    }

    @Override
    @TargetApi(value=18)
    public void stopScanBluetooth() {
        try {
            if (this.mBluetoothAdapter != null) {
                this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mLeScanCallback);
            }
        }
        catch (Exception e) {
            BluetoothLog.e(e);
        }
        super.stopScanBluetooth();
    }

    @Override
    @TargetApi(value=18)
    protected void cancelScanBluetooth() {
        try {
            if (this.mBluetoothAdapter != null) {
                this.mBluetoothAdapter.getBluetoothLeScanner().stopScan(this.mLeScanCallback);
            }
        }
        catch (Exception e) {
            BluetoothLog.e(e);
        }
        super.cancelScanBluetooth();
    }

    private static class BluetoothLESearcherHolder {
        private static BluetoothLESearcher instance = new BluetoothLESearcher();

        private BluetoothLESearcherHolder() {
        }
    }
}

