/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library.search;

import android.bluetooth.BluetoothDevice;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class SearchResult
implements Parcelable {
    public BluetoothDevice device;
    public int rssi;
    public byte[] scanRecord;
    public static final Parcelable.Creator<SearchResult> CREATOR = new Parcelable.Creator<SearchResult>(){

        public SearchResult createFromParcel(Parcel source) {
            return new SearchResult(source);
        }

        public SearchResult[] newArray(int size) {
            return new SearchResult[size];
        }
    };

    public SearchResult(BluetoothDevice device) {
        this(device, 0, null);
    }

    public SearchResult(BluetoothDevice device, int rssi, byte[] scanRecord) {
        this.device = device;
        this.rssi = rssi;
        this.scanRecord = scanRecord;
    }

    public String getName() {
        String name = this.device.getName();
        return TextUtils.isEmpty((CharSequence)name) ? "NULL" : name;
    }

    public String getAddress() {
        return this.device != null ? this.device.getAddress() : "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(", mac = " + this.device.getAddress());
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.device, 0);
        dest.writeInt(this.rssi);
        dest.writeByteArray(this.scanRecord);
    }

    public SearchResult(Parcel in) {
        this.device = (BluetoothDevice)in.readParcelable(BluetoothDevice.class.getClassLoader());
        this.rssi = in.readInt();
        this.scanRecord = in.createByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResult that = (SearchResult)o;
        return this.device.equals((Object)that.device);
    }

    public int hashCode() {
        return this.device.hashCode();
    }
}

