/*
 * Decompiled with CFR 0.152.
 */
package com.inuker.bluetooth.library;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import com.inuker.bluetooth.library.IBluetoothService;
import com.inuker.bluetooth.library.IResponse;
import com.inuker.bluetooth.library.connect.BleConnectManager;
import com.inuker.bluetooth.library.connect.options.BleConnectOptions;
import com.inuker.bluetooth.library.connect.response.BleGeneralResponse;
import com.inuker.bluetooth.library.search.BluetoothSearchManager;
import com.inuker.bluetooth.library.search.SearchRequest;
import com.inuker.bluetooth.library.utils.BluetoothLog;
import java.util.UUID;

public class BluetoothServiceImpl
extends IBluetoothService.Stub
implements Handler.Callback {
    private static BluetoothServiceImpl sInstance;
    private Handler mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);

    private BluetoothServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BluetoothServiceImpl getInstance() {
        if (sInstance != null) return sInstance;
        Class<BluetoothServiceImpl> clazz = BluetoothServiceImpl.class;
        synchronized (BluetoothServiceImpl.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BluetoothServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    @Override
    public void callBluetoothApi(int code, Bundle args, final IResponse response) throws RemoteException {
        Message msg = this.mHandler.obtainMessage(code, (Object)new BleGeneralResponse(){

            @Override
            public void onResponse(int code, Bundle data) {
                if (response != null) {
                    if (data == null) {
                        data = new Bundle();
                    }
                    try {
                        response.onResponse(code, data);
                    }
                    catch (Throwable e) {
                        BluetoothLog.e(e);
                    }
                }
            }
        });
        args.setClassLoader(this.getClass().getClassLoader());
        msg.setData(args);
        msg.sendToTarget();
    }

    public boolean handleMessage(Message msg) {
        Bundle args = msg.getData();
        String mac = args.getString("extra.mac");
        UUID service = (UUID)args.getSerializable("extra.service.uuid");
        UUID character = (UUID)args.getSerializable("extra.character.uuid");
        UUID descriptor = (UUID)args.getSerializable("extra.descriptor.uuid");
        byte[] value = args.getByteArray("extra.byte.value");
        BleGeneralResponse response = (BleGeneralResponse)msg.obj;
        switch (msg.what) {
            case 1: {
                BleConnectOptions options = (BleConnectOptions)args.getParcelable("extra.options");
                BleConnectManager.connect(mac, options, response);
                break;
            }
            case 2: {
                BleConnectManager.disconnect(mac);
                break;
            }
            case 3: {
                BleConnectManager.read(mac, service, character, response);
                break;
            }
            case 4: {
                BleConnectManager.write(mac, service, character, value, response);
                break;
            }
            case 5: {
                BleConnectManager.writeNoRsp(mac, service, character, value, response);
                break;
            }
            case 13: {
                BleConnectManager.readDescriptor(mac, service, character, descriptor, response);
                break;
            }
            case 14: {
                BleConnectManager.writeDescriptor(mac, service, character, descriptor, value, response);
                break;
            }
            case 6: {
                BleConnectManager.notify(mac, service, character, response);
                break;
            }
            case 7: {
                BleConnectManager.unnotify(mac, service, character, response);
                break;
            }
            case 8: {
                BleConnectManager.readRssi(mac, response);
                break;
            }
            case 11: {
                SearchRequest request = (SearchRequest)args.getParcelable("extra.request");
                BluetoothSearchManager.search(request, response);
                break;
            }
            case 12: {
                BluetoothSearchManager.stopSearch();
                break;
            }
            case 10: {
                BleConnectManager.indicate(mac, service, character, response);
                break;
            }
            case 22: {
                int mtu = args.getInt("extra.mtu");
                BleConnectManager.requestMtu(mac, mtu, response);
                break;
            }
            case 20: {
                int clearType = args.getInt("extra.type", 0);
                BleConnectManager.clearRequest(mac, clearType);
                break;
            }
            case 21: {
                BleConnectManager.refreshCache(mac);
            }
        }
        return true;
    }
}

