/*
 * Decompiled with CFR 0.152.
 */
package com.xmgl.vrsoft;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.vatics.dewarp.FecCenter;
import com.vatics.dewarp.GL2JNIView;
import com.xmgl.vrsoft.VRSoftEvent;
import com.xmgl.vrsoft.VRSoftEvent180;
import com.xmgl.vrsoft.VRSoftEvent360;
import com.xmgl.vrsoft.VRSoftEventJNI;
import com.xmgl.vrsoft.VRSoftJNI;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class VRSoftGLView
extends GLSurfaceView
implements SensorEventListener {
    private VRSoftRenderer mRenderer = null;
    private int mType = 22;
    private int mMount = 0;
    private int mShape = 0;
    private VRSoftEvent mVREvent = null;
    private boolean mHasReady = false;
    private boolean mTouchable = true;
    private boolean mIsSupportVRFollow;
    private int mVRSoftHandle = -1;
    private boolean mIsAlarm;
    private OnVRSoftZoomListener mListener = null;
    private OnShapeChangeListener mShapeChangeLs = null;
    public GLSurfaceView.Renderer mRendererCallback;
    private static final int GET_ANGLE_TIME = 200;
    private Timer mTimer;
    private OnRotateAngleListener mOnRotateAngleLs;

    public VRSoftGLView(Context context) {
        super(context);
        this.initialize();
    }

    public void setDoubleTap(boolean enable) {
        if (this.mVREvent != null && this.mVREvent instanceof VRSoftEventJNI) {
            ((VRSoftEventJNI)this.mVREvent).setDoubleTap(enable);
        }
    }

    public boolean hasReady() {
        return this.mHasReady;
    }

    private void initialize() {
        this.mVRSoftHandle = VRSoftJNI.createHandle();
        this.setDebugFlags(1);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(8, 8, 8, 8, 24, 0);
        this.mRenderer = new VRSoftRenderer();
        this.setRenderer(this.mRenderer);
        this.setRenderMode(1);
        this.switchVRType(this.mType);
        this.setTouchable(true);
    }

    private void switchVRType(int type) {
        VRSoftJNI.setType(this.mVRSoftHandle, type);
        this.createEventManager();
    }

    public void startAutoCruise(double speed) {
        VRSoftJNI.startAutoCruise(this.mVRSoftHandle, speed);
    }

    public void stopAutoCruise() {
        VRSoftJNI.stopAutoCruise(this.mVRSoftHandle);
    }

    public void setOnZoomListener(OnVRSoftZoomListener listener) {
        this.mListener = listener;
    }

    public void setOnShapeChangeListener(OnShapeChangeListener listener) {
        this.mShapeChangeLs = listener;
    }

    public void setRendererCallback(GLSurfaceView.Renderer callback) {
        this.mRendererCallback = callback;
    }

    public void setParams(int xCenter, int yCenter, int radius, int imgWidth, int imgHeight) {
        VRSoftJNI.setParams(this.mVRSoftHandle, xCenter, yCenter, radius, imgWidth, imgHeight);
    }

    public void setType(int type) {
        if ((type == 1 || type == 0 || type == 2 || type == 3 || type == 10 || type == 20 || type == 21 || type == 22 || type == 23 || type == 24) && this.mType != type) {
            this.mType = type;
            this.switchVRType(this.mType);
            if (this.hasReady()) {
                this.requestRender();
            }
        }
    }

    public int getType() {
        return this.mType;
    }

    public void cleanUp() {
        VRSoftJNI.cleanUp(this.mVRSoftHandle, ((Object)((Object)this)).hashCode());
    }

    private void createEventManager() {
        if (null == this.mVREvent) {
            this.mVREvent = new VRSoftEventJNI(this.getContext(), this, this.mVRSoftHandle);
            ((VRSoftEventJNI)this.mVREvent).setCameraMount(this.mMount);
            ((VRSoftEventJNI)this.mVREvent).setShape(this.mShape);
        }
    }

    public void setBackgroundColor(int color) {
        super.setBackgroundColor(color);
        VRSoftJNI.setBackground(this.mVRSoftHandle, color);
    }

    public void setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mType == 2 || this.mType == 3) {
            double[] ratateZoom = new double[4];
            VRSoftJNI.getRotateZoom(this.mVRSoftHandle, ratateZoom);
            double zoom = ratateZoom[3];
            if (zoom == 1.0 && null != this.mListener) {
                this.mListener.onVRSoftScale(1.0f, (View)this, event);
            }
        }
        if (null != this.mVREvent && this.mTouchable) {
            return this.mVREvent.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }

    public void setNewBitmap(Bitmap bmp) {
        if (null != bmp) {
            ByteBuffer bf = ByteBuffer.allocate(bmp.getByteCount());
            bmp.copyPixelsToBuffer((Buffer)bf);
            byte[] byteArray = bf.array();
            VRSoftJNI.setRGBTexture(this.mVRSoftHandle, byteArray, byteArray.length, bmp.getWidth(), bmp.getHeight());
            bmp.recycle();
            bmp = null;
            this.requestRender();
        }
    }

    public void setMultiBitmap(int index, Bitmap bmp) {
        if (null != bmp) {
            ByteBuffer bf = ByteBuffer.allocate(bmp.getByteCount());
            bmp.copyPixelsToBuffer((Buffer)bf);
            byte[] byteArray = bf.array();
            VRSoftJNI.multiSetRGBTexture(this.mVRSoftHandle, index, byteArray, byteArray.length, bmp.getWidth(), bmp.getHeight());
            bmp.recycle();
            bmp = null;
            this.requestRender();
        }
    }

    public void setNewYUV(byte[] data, int width, int height) {
        if (null != data) {
            VRSoftJNI.setYUVTexture(this.mVRSoftHandle, data, data.length, width, height);
            this.requestRender();
        }
    }

    public void setNewData(int fixelFmt, byte[] data, int width, int height) {
        if (null != data) {
            VRSoftJNI.setTexture(this.mVRSoftHandle, fixelFmt, data, data.length, width, height);
            this.requestRender();
        }
    }

    public void setNewData(int gridId, int fixelFmt, byte[] data, int width, int height) {
        if (null != data) {
            VRSoftJNI.multiSetTexture(this.mVRSoftHandle, gridId, fixelFmt, data, data.length, width, height);
            this.requestRender();
        }
    }

    public void setDrawMode(int drawMode) {
        if (null != this.mVREvent) {
            if (this.mVREvent instanceof VRSoftEvent180) {
                ((VRSoftEvent180)this.mVREvent).setDrawMode(drawMode);
                this.mVREvent.goToDefaultPosition();
                VRSoftJNI.setDrawMode(this.mVRSoftHandle, drawMode);
                this.requestRender();
            } else if (this.mVREvent instanceof VRSoftEventJNI) {
                this.mVREvent.goToDefaultPosition();
                VRSoftJNI.setDrawMode(this.mVRSoftHandle, drawMode);
                this.requestRender();
            }
        }
    }

    public void setCameraMount(int mount) {
        if (null != this.mVREvent) {
            this.mMount = mount;
            if (this.mVREvent instanceof VRSoftEvent360) {
                ((VRSoftEvent360)this.mVREvent).setCameraMount(mount);
                VRSoftJNI.setCameraMount(this.mVRSoftHandle, mount);
                this.mVREvent.goToDefaultPosition();
                this.requestRender();
            } else if (this.mVREvent instanceof VRSoftEventJNI) {
                ((VRSoftEventJNI)this.mVREvent).setCameraMount(mount);
                VRSoftJNI.setCameraMount(this.mVRSoftHandle, mount);
                this.mVREvent.goToDefaultPosition();
                this.requestRender();
            }
        }
    }

    public int getCameraMount() {
        return this.mMount;
    }

    public void setShape(int shape) {
        if (null != this.mVREvent) {
            this.mShape = shape;
            if (this.mVREvent instanceof VRSoftEvent360) {
                ((VRSoftEvent360)this.mVREvent).setShape(shape);
                VRSoftJNI.setShape(this.mVRSoftHandle, shape);
                this.mVREvent.goToDefaultPosition();
                this.requestRender();
            } else if (this.mVREvent instanceof VRSoftEventJNI) {
                ((VRSoftEventJNI)this.mVREvent).setShape(shape);
                VRSoftJNI.setShape(this.mVRSoftHandle, shape);
                if (this.mType == 1) {
                    if (shape == 0 && this.mIsSupportVRFollow) {
                        this.setPTZFor180VR(0.0, 0.0, 3.0, 10.0);
                    } else {
                        this.mVREvent.goToDefaultPosition();
                    }
                    if (this.mShapeChangeLs != null) {
                        this.mShapeChangeLs.onShapeChanged(this.mType, this.mShape);
                    }
                }
                this.requestRender();
            }
        }
    }

    public int getShape() {
        return this.mShape;
    }

    public void setMultiLensCount(int lensCount) {
        VRSoftJNI.multiSetLensCount(this.mVRSoftHandle, lensCount);
    }

    public void switchMultiLens(int lensIndex) {
        VRSoftJNI.multiSwitchLens(this.mVRSoftHandle, lensIndex);
    }

    public int getMultiLensCount() {
        return VRSoftJNI.multiGetLensCount(this.mVRSoftHandle);
    }

    public int getMultiLensIndex() {
        return VRSoftJNI.multiGetLensIndex(this.mVRSoftHandle);
    }

    public void getRotateZoom(double[] outRxRyRzZoom) {
        VRSoftJNI.getRotateZoom(this.mVRSoftHandle, outRxRyRzZoom);
    }

    public void setRotateZoom(double rotateX, double rotateY, double rotateZ, double zoom) {
        VRSoftJNI.setRotateZoom(this.mVRSoftHandle, rotateX, rotateY, rotateZ, zoom);
    }

    public void setRotateZoomRecoverMode(double rotateX, double rotateY, double rotateZ, double zoom) {
        VRSoftJNI.setRotateZoomRecoverMode(this.mVRSoftHandle, rotateX, rotateY, rotateZ, zoom);
    }

    public float getRelativeXOffset() {
        return VRSoftJNI.getRelativeXOffset(this.mVRSoftHandle);
    }

    public void setFecParams(GL2JNIView.FecType type, FecCenter center) {
        if (type == GL2JNIView.FecType.GENERAL_180VR) {
            this.mType = 1;
            this.switchVRType(1);
            if (null != center) {
                VRSoftJNI.setParams(this.mVRSoftHandle, center.xCenter, center.yCenter, center.radius, center.videoWidth, center.videoHeight);
            }
        } else if (type == GL2JNIView.FecType.GENERAL_360VR) {
            this.mType = 0;
            this.switchVRType(0);
            if (null != center) {
                VRSoftJNI.setParams(this.mVRSoftHandle, center.xCenter, center.yCenter, center.radius, center.videoWidth, center.videoHeight);
            }
        }
    }

    public void displayRect(int x0, int y0, int x1, int y1, int width, int height) {
        VRSoftJNI.displayRect(this.mVRSoftHandle, x0, y0, x1, y1, width, height);
        this.mIsAlarm = true;
    }

    public void displayRect(int x0, int y0, int x1, int y1) {
        VRSoftJNI.displayRect(this.mVRSoftHandle, x0, y0, x1, y1, 8192, 8192);
        this.mIsAlarm = true;
    }

    public void displayTarget(int targetX, int targetY, int width, int height) {
        VRSoftJNI.displayTarget(this.mVRSoftHandle, targetX, targetY, width, height);
    }

    protected void onDetachedFromWindow() {
        VRSoftJNI.releaseHandle(this.mVRSoftHandle, ((Object)((Object)this)).hashCode());
        this.mVRSoftHandle = -1;
        this.closeRotateAngleTimerTask();
        super.onDetachedFromWindow();
    }

    public void change_RawPicture_Size(SurfaceView view, int width, int height) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
        params.leftMargin = 0;
        params.topMargin = 0;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void onAccuracyChanged(Sensor arg0, int arg1) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            Configuration config = this.getResources().getConfiguration();
            if (config.orientation == 1) {
                VRSoftJNI.onAccelerometer(this.mVRSoftHandle, x, y, z);
            } else {
                VRSoftJNI.onAccelerometer(this.mVRSoftHandle, y, x, z);
            }
        } else if (event.sensor.getType() == 3) {
            float zD = event.values[0];
            float xD = event.values[1];
            float yD = event.values[2];
            Configuration config = this.getResources().getConfiguration();
            if (config.orientation == 1) {
                VRSoftJNI.onOrientation(this.mVRSoftHandle, xD, yD, zD);
            } else {
                int rotation = 0;
                if (Build.VERSION.SDK_INT >= 17) {
                    rotation = this.getDisplay().getRotation();
                } else {
                    WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
                    rotation = wm.getDefaultDisplay().getRotation();
                }
                if (rotation == 1) {
                    VRSoftJNI.onOrientation(this.mVRSoftHandle, -yD, xD, zD);
                } else {
                    VRSoftJNI.onOrientation(this.mVRSoftHandle, yD, xD, zD);
                }
            }
        }
    }

    public void openRotateAngleTimerTask(OnRotateAngleListener ls) {
        this.closeRotateAngleTimerTask();
        this.mOnRotateAngleLs = ls;
        this.mTimer = new Timer();
        this.mTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (null != VRSoftGLView.this.mOnRotateAngleLs) {
                    double[] outPTZR = new double[4];
                    VRSoftJNI.getPTZ(VRSoftGLView.this.mVRSoftHandle, outPTZR);
                    VRSoftGLView.this.mOnRotateAngleLs.onRotate((float)(360.0 - (outPTZR[0] - 90.0) % 360.0) % 360.0f);
                    if (VRSoftGLView.this.mIsAlarm) {
                        VRSoftGLView.this.mOnRotateAngleLs.onAlarm();
                        VRSoftGLView.this.mIsAlarm = false;
                    }
                }
            }
        }, 10L, 200L);
    }

    public void closeRotateAngleTimerTask() {
        if (null != this.mTimer) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
        this.mOnRotateAngleLs = null;
    }

    public void setmGestureListener(GestureDetector.OnGestureListener mGestureListener) {
        if (null != this.mVREvent) {
            ((VRSoftEventJNI)this.mVREvent).setGestureListener(mGestureListener);
        }
    }

    public void setmDoubleTapListener(GestureDetector.OnDoubleTapListener mDoubleTapListener) {
        if (null != this.mVREvent) {
            ((VRSoftEventJNI)this.mVREvent).setmDoubleTapListener(mDoubleTapListener);
        }
    }

    public boolean isDoorBellWallMode() {
        if (null != this.mVREvent) {
            return ((VRSoftEventJNI)this.mVREvent).isDoorBellWallMode();
        }
        return false;
    }

    public void setDoorBellWallMode(boolean isDoorBellWallMode) {
        if (null != this.mVREvent) {
            ((VRSoftEventJNI)this.mVREvent).setDoorBellWallMode(isDoorBellWallMode);
        }
    }

    public double[] getPTZFor180VR() {
        double[] ratateZoom = new double[4];
        VRSoftJNI.getPTZFor180VR(this.mVRSoftHandle, ratateZoom);
        return ratateZoom;
    }

    public void setPTZFor180VR(double rotateX, double rotateY, double rotateZ, double zoom) {
        if (this.mVRSoftHandle != -1) {
            VRSoftJNI.setPTZFor180VR(this.mVRSoftHandle, rotateX, rotateY, rotateZ, zoom);
        }
    }

    public void setSupportVRFollow(boolean isSupportVRFollow) {
        this.mIsSupportVRFollow = isSupportVRFollow;
        if (this.mVREvent != null && this.mVREvent instanceof VRSoftEventJNI) {
            ((VRSoftEventJNI)this.mVREvent).setSupportVRFollow(isSupportVRFollow);
        }
    }

    public void setRotationFor180VR(double rotation) {
        if (this.mVRSoftHandle != -1) {
            VRSoftJNI.setRotationFor180VR(this.mVRSoftHandle, rotation);
        }
    }

    public void showPIPOriginal(boolean isShowPIPOriginal) {
        VRSoftJNI.showPIPOriginal(this.mVRSoftHandle, isShowPIPOriginal);
    }

    public void setLogicZoom(double zoomMin, double zoomMax, double zoomDiv, double zoomValue) {
        if (this.mVRSoftHandle != -1) {
            VRSoftJNI.setLogicZoom(this.mVRSoftHandle, zoomMin, zoomMax, zoomDiv, zoomValue);
        }
    }

    public float getLogicZoom(double zoomMin, double zoomMax) {
        return VRSoftJNI.getLogicZoom(this.mVRSoftHandle, zoomMin, zoomMax);
    }

    public void setTwoLensesDrawMode(int drawMode) {
        VRSoftJNI.setTwoLensesDrawMode(this.mVRSoftHandle, drawMode);
    }

    public void setTwoLensesScreen(int screen) {
        VRSoftJNI.setTwoLensesScreen(this.mVRSoftHandle, screen);
        this.requestRender();
    }

    public int getTwoLensesScreen() {
        return VRSoftJNI.getTwoLensesScreen(this.mVRSoftHandle);
    }

    public static interface OnRotateAngleListener {
        public void onRotate(float var1);

        public void onAlarm();
    }

    public class VRSoftRenderer
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 gl) {
            if (null != VRSoftGLView.this.mVREvent) {
                VRSoftGLView.this.mVREvent.setPTZs();
                VRSoftJNI.drawSelf(VRSoftGLView.this.mVRSoftHandle, ((Object)((Object)VRSoftGLView.this)).hashCode());
                if (VRSoftGLView.this.mVREvent.needContinue()) {
                    VRSoftGLView.this.requestRender();
                }
            } else {
                VRSoftJNI.drawSelf(VRSoftGLView.this.mVRSoftHandle, ((Object)((Object)VRSoftGLView.this)).hashCode());
            }
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            VRSoftJNI.init(VRSoftGLView.this.mVRSoftHandle, width, height);
            VRSoftGLView.this.mHasReady = true;
            if (null != VRSoftGLView.this.mRendererCallback) {
                VRSoftGLView.this.mRendererCallback.onSurfaceChanged(gl, width, height);
            }
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig cnf) {
            VRSoftJNI.prepare(VRSoftGLView.this.mVRSoftHandle);
            if (null != VRSoftGLView.this.mRendererCallback) {
                VRSoftGLView.this.mRendererCallback.onSurfaceCreated(gl, cnf);
            }
        }
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12352, EGL_OPENGL_ES2_BIT, 12324, 8, 12323, 8, 12322, 8, 12325, 24, 12338, 1, 12337, 8, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            for (int i = 0; i < attributes.length; ++i) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) continue;
                while (egl.eglGetError() != 12288) {
                }
            }
        }
    }

    public static interface OnShapeChangeListener {
        public void onShapeChanged(int var1, int var2);
    }

    public static interface OnVRSoftZoomListener {
        public void onVRSoftScale(float var1, View var2, MotionEvent var3);
    }
}

