/*
 * Decompiled with CFR 0.152.
 */
package com.vatics.dewarp;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.graphics.PointF;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import com.vatics.dewarp.FecCenter;
import com.vatics.dewarp.GL2JNILib;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class GL2JNIView
extends GLSurfaceView
implements SensorEventListener {
    private static String TAG = "GL2JNIView";
    private static final float MAX_DP = 3.0f;
    private static final float MIN_DP = 0.1f;
    private static final float MAX_SCALE = 3.5f;
    private static final float MIN_SCALE = 0.5f;
    private static final float MIN_SPCE = 10.0f;
    private static final float MIN_MOVE = 30.0f;
    private static final int DRAG = 1;
    private static final int ZOOM = 2;
    private static final boolean DEBUG = false;
    private float mPreScale;
    private float mCurScale;
    private float mChangeScale;
    private float mOldDist = 1.0f;
    private Context mContext;
    private Renderer mRenderer;
    private static int mMode = 0;
    private static float mMinDP = 0.1f;
    private static float mMinScale = 0.5f;
    private static ValueAnimator mAnimator;
    private boolean mSurfaceViewCreated = false;
    private static final int MESSAGE_ANIMATION_GENERAL_180VR = 256;
    private static final int MESSAGE_ANIMATION_FISHEYE_360VR_TILT_ENLARGE = 257;
    private static final int MESSAGE_ANIMATION_FISHEYE_360VR_ZOOM_ENLARGE = 258;
    private static final int MESSAGE_ANIMATION_FISHEYE_360VR_TILT_NARROW = 259;
    private static final int MESSAGE_ANIMATION_FISHEYE_360VR_ZOOM_NARROW = 260;
    private static final int MESSAGE_ANIMATION_END = 261;
    private static final int MESSAGE_ANIMATION_GOBACK = 262;
    private boolean mIsOriginal = true;
    private boolean mIsChanging = false;
    private AnimatorSet mGoBackSet;
    private int mJNIHandle = -1;
    private float mMoveY = 0.0f;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 256: {
                    GL2JNIView.this.zoomAnimation(0.7f, 2.0f, 2000L);
                    GL2JNIView.this.mCurScale = (GL2JNIView.this.mPreScale = 2.0f);
                    break;
                }
                case 257: {
                    GL2JNIView.this.tiltAnimation(-90.0f, -45.0f, 1000L);
                    GL2JNIView.this.mHandler.sendEmptyMessageDelayed(258, 1000L);
                    break;
                }
                case 258: {
                    GL2JNIView.this.zoomAnimation(1.0f, 2.0f, 1000L);
                    GL2JNIView.this.mHandler.sendEmptyMessageDelayed(261, 1000L);
                    break;
                }
                case 259: {
                    GL2JNIView.this.tiltAnimation(-45.0f, -90.0f, 1000L);
                    GL2JNIView.this.mHandler.sendEmptyMessageDelayed(261, 1000L);
                    break;
                }
                case 260: {
                    GL2JNIView.this.zoomAnimation(2.0f, 1.0f, 1000L);
                    GL2JNIView.this.mHandler.sendEmptyMessageDelayed(259, 1000L);
                    break;
                }
                case 262: {
                    float[] fPan = new float[1];
                    float[] fTilt = new float[1];
                    float[] fZoom = new float[1];
                    float[] fTiltBoundary = new float[2];
                    GL2JNILib.getPtz(GL2JNIView.this.mJNIHandle, fPan, fTilt, fZoom);
                    GL2JNILib.getTiltBoundary(GL2JNIView.this.mJNIHandle, fTiltBoundary);
                    float tarTilt = fTilt[0];
                    if (tarTilt < fTiltBoundary[0]) {
                        tarTilt = fTiltBoundary[0];
                    } else if (tarTilt > fTiltBoundary[1]) {
                        tarTilt = fTiltBoundary[1];
                    }
                    if (fTilt[0] == tarTilt) break;
                    GL2JNIView.this.goBackAnimation(fTilt[0], tarTilt, 1000L);
                    break;
                }
                case 261: {
                    GL2JNIView.this.mIsChanging = false;
                }
            }
        }
    };

    public GL2JNIView(Context context) {
        super(context);
        this.mContext = context;
        this.init(false, 0, 0);
    }

    public GL2JNIView(Context context, boolean translucent, int depth, int stencil) {
        super(context);
        this.mContext = context;
        this.init(translucent, depth, stencil);
    }

    private void init(boolean translucent, int depth, int stencil) {
        this.mJNIHandle = GL2JNILib.createHandle();
        if (translucent) {
            this.getHolder().setFormat(-3);
        }
        this.setEGLContextFactory(new ContextFactory());
        this.setEGLConfigChooser(translucent ? new ConfigChooser(8, 8, 8, 8, depth, stencil) : new ConfigChooser(5, 6, 5, 0, depth, stencil));
        this.mRenderer = new Renderer(this.mContext);
        this.setRenderer(this.mRenderer);
        this.mSurfaceViewCreated = false;
    }

    public void setFecParams(FecType type, FecCenter center) {
        if (null != this.mRenderer) {
            this.mRenderer.setFecParams(type, center);
        }
    }

    public float spacing(MotionEvent event) {
        try {
            float x = event.getX(0) - event.getX(1);
            float y = event.getY(0) - event.getY(1);
            return (float)Math.sqrt(x * x + y * y);
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public void midPoint(PointF point, MotionEvent event) {
        float x = event.getX(0) + event.getX(1);
        float y = event.getY(0) + event.getY(1);
        point.set(x / 2.0f, y / 2.0f);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mIsChanging) {
            return super.onTouchEvent(event);
        }
        int action = event.getAction() & 0xFF;
        switch (action) {
            case 0: {
                if (null != mAnimator) {
                    mAnimator.cancel();
                }
                if (null != this.mGoBackSet) {
                    this.mGoBackSet.cancel();
                }
                this.mRenderer.onTouchDown(event.getX(), event.getY());
                this.mPreScale = this.mCurScale;
                mMode = 1;
                this.mMoveY = event.getY();
                break;
            }
            case 2: {
                float newDist;
                if (mMode == 1) {
                    if (this.mIsOriginal && Math.abs(this.mMoveY - event.getY()) > 30.0f) {
                        this.originalToPart();
                        break;
                    }
                    this.mRenderer.onTouchMove(event.getX(), event.getY());
                    break;
                }
                if (mMode != 2 || !((newDist = this.spacing(event)) > 10.0f)) break;
                float scale = newDist / this.mOldDist * this.mPreScale;
                if ((scale = (float)Math.round(scale * 100.0f) / 100.0f) < 2.0f && scale > this.mPreScale && this.mIsOriginal) {
                    this.originalToPart();
                    break;
                }
                if (scale < 2.0f && scale < this.mPreScale && !this.mIsOriginal && (this.mRenderer.getFecType() == FecType.FISHEYE_360VR || this.mRenderer.getFecType() == FecType.GENERAL_360VR)) {
                    this.partToOriginal();
                    break;
                }
                scale = scale <= 0.5f ? 0.5f : scale;
                scale = scale >= 3.5f ? 3.5f : scale;
                float d_value = scale - this.mCurScale;
                int i = 0;
                while ((float)i < Math.abs(d_value) * 100.0f) {
                    scale = this.mCurScale + (float)i * 0.01f * (Math.abs(d_value) / d_value);
                    GL2JNILib.handleTouchPinch(this.mJNIHandle, scale);
                    ++i;
                }
                this.mCurScale = scale;
                break;
            }
            case 1: {
                this.mRenderer.onTouchUp(event.getX(), event.getY());
                mMode = 0;
                break;
            }
            case 6: {
                mMode = 0;
                break;
            }
            case 5: {
                this.mOldDist = this.spacing(event);
                if (!(this.mOldDist > 10.0f)) break;
                mMode = 2;
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void originalToPart() {
        this.mIsOriginal = false;
        this.mIsChanging = true;
        this.mHandler.sendEmptyMessage(257);
        mMinScale = 2.0f;
        this.mCurScale = 2.0f;
    }

    private void partToOriginal() {
        this.mIsOriginal = true;
        this.mIsChanging = true;
        this.mHandler.sendEmptyMessage(260);
        mMinScale = 1.0f;
        this.mCurScale = 1.0f;
    }

    private static void checkEglError(String prompt, EGL10 egl) {
        int error;
        while ((error = egl.eglGetError()) != 12288) {
            Log.e((String)TAG, (String)String.format("%s: EGL error: 0x%x", prompt, error));
        }
    }

    public void onAccuracyChanged(Sensor arg0, int arg1) {
    }

    public void onSensorChanged(SensorEvent event) {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation == 1) {
            return;
        }
        float x = event.values[0] * 5.0f;
        float y = event.values[1] * 5.0f;
        float z = event.values[2] * 5.0f;
        if (Math.abs(x) > 1.0f || Math.abs(y) > 1.0f) {
            float[] values = new float[2];
            GL2JNILib.getZoom(this.mJNIHandle, values);
            if (values[0] == 0.0f && values[1] == 0.0f) {
                GL2JNILib.handleGyroscope(this.mJNIHandle, -x, y, z);
            }
        }
    }

    private void deceleration(final float dp, final float dt) {
        mAnimator = ValueAnimator.ofFloat((float[])new float[]{dp, mMinDP * (dp / Math.abs(dp))});
        mAnimator.setDuration(1500L);
        mAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                float tValue = Math.abs(value) / Math.abs(dp) * dt;
                GL2JNILib.setZoom(GL2JNIView.this.mJNIHandle, value, 0.0f, 0.0f);
            }
        });
        mAnimator.start();
    }

    public void setAlwaysScroll(boolean enable) {
        if (enable) {
            mMinDP = 0.1f;
        } else {
            mMinDP = 0.0f;
            if (null != mAnimator) {
                mAnimator.cancel();
                GL2JNILib.setZoom(this.mJNIHandle, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    private void zoomAnimation(float zoomStart, float zoomEnd, long duration) {
        mAnimator = ValueAnimator.ofFloat((float[])new float[]{zoomStart, zoomEnd});
        mAnimator.setDuration(duration);
        mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                Log.e((String)TAG, (String)("---------------->value:" + value));
                GL2JNIView.this.mChangeScale = value;
                GL2JNILib.setPtz(GL2JNIView.this.mJNIHandle, true, 65535.0f, -45.0f, value);
            }
        });
        mAnimator.start();
    }

    private void tiltAnimation(float tiltStart, float tiltEnd, long duration) {
        mAnimator = ValueAnimator.ofFloat((float[])new float[]{tiltStart, tiltEnd});
        mAnimator.setDuration(duration);
        mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                GL2JNILib.setPtz(GL2JNIView.this.mJNIHandle, true, 65535.0f, value, 1.0f);
            }
        });
        mAnimator.start();
    }

    private void goBackAnimation(float tiltStart, float tiltEnd, long duration) {
        this.mGoBackSet = new AnimatorSet();
        ValueAnimator step1 = ValueAnimator.ofFloat((float[])new float[]{tiltStart, tiltEnd});
        step1.setDuration(duration);
        step1.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        step1.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                GL2JNILib.setPtz(GL2JNIView.this.mJNIHandle, true, 65535.0f, value, GL2JNIView.this.mCurScale);
            }
        });
        ValueAnimator step2 = ValueAnimator.ofFloat((float[])new float[]{tiltEnd, tiltEnd - (tiltEnd - tiltStart) / 10.0f});
        step2.setDuration(100L);
        step2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        step2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                GL2JNILib.setPtz(GL2JNIView.this.mJNIHandle, true, 65535.0f, value, GL2JNIView.this.mCurScale);
            }
        });
        ValueAnimator step3 = ValueAnimator.ofFloat((float[])new float[]{tiltEnd - (tiltEnd - tiltStart) / 10.0f, tiltEnd});
        step3.setDuration(100L);
        step3.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        step3.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator arg0) {
                float value = ((Float)arg0.getAnimatedValue()).floatValue();
                GL2JNILib.setPtz(GL2JNIView.this.mJNIHandle, true, 65535.0f, value, GL2JNIView.this.mCurScale);
            }
        });
        this.mGoBackSet.play((Animator)step1);
        this.mGoBackSet.play((Animator)step2).after((Animator)step1);
        this.mGoBackSet.play((Animator)step3).after((Animator)step2);
        this.mGoBackSet.start();
    }

    protected void onDetachedFromWindow() {
        if (null != this.mHandler) {
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler = null;
        }
        GL2JNILib.release(this.mJNIHandle, ((Object)((Object)this)).hashCode());
        this.mJNIHandle = -1;
        super.onDetachedFromWindow();
    }

    public void cleanUp() {
        GL2JNILib.cleanUp(this.mJNIHandle, ((Object)((Object)this)).hashCode());
    }

    public void change_RawPicture_Size(SurfaceView view, int width, int height) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
        params.leftMargin = 0;
        params.topMargin = 0;
        view.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private class Renderer
    implements GLSurfaceView.Renderer {
        private Context mContext;
        private FecType mFecType = FecType.NORMAL;
        private FecCenter mFecCenter = null;
        private int mSurfaceWidth = -1;
        private int mSurfaceHeight = -1;

        public Renderer(Context context) {
            this.mContext = context;
        }

        public void readYUVData() {
            AssetManager am = this.mContext.getAssets();
            try {
                InputStream is = am.open("wallmode.yuv");
                int width = 1024;
                int height = 1024;
                int size = width * height * 3 / 2;
                byte[] bytes = new byte[size];
                BufferedInputStream buf = new BufferedInputStream(is, size);
                buf.read(bytes, 0, bytes.length);
                buf.close();
                GL2JNILib.setYUVBuffer(GL2JNIView.this.mJNIHandle, width, height, width, bytes);
                bytes = null;
                System.gc();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void setFecParams(FecType cameraType, FecCenter center) {
            if (this.mFecType != cameraType || center != null && !center.equals(this.mFecCenter)) {
                this.mFecType = cameraType;
                this.mFecCenter = center;
                if (this.mSurfaceWidth > 0 && this.mSurfaceHeight > 0) {
                    if (null != mAnimator) {
                        mAnimator.cancel();
                    }
                    this.initGL2JNILib(this.mSurfaceWidth, this.mSurfaceHeight);
                    this.resetInitStat();
                }
            }
        }

        private void initGL2JNILib(int width, int height) {
            GL2JNIView.this.mCurScale = (GL2JNIView.this.mPreScale = 1.0f);
            GL2JNIView.this.mIsOriginal = true;
            if (null == this.mFecCenter) {
                GL2JNILib.setDewarpFecCenter(GL2JNIView.this.mJNIHandle, 0, 0, 0, 0, 0, this.mFecType == FecType.GENERAL_180VR);
            } else {
                GL2JNILib.setDewarpFecCenter(GL2JNIView.this.mJNIHandle, this.mFecCenter.videoWidth, this.mFecCenter.videoHeight, this.mFecCenter.xCenter, this.mFecCenter.yCenter, this.mFecCenter.radius, this.mFecType == FecType.GENERAL_180VR);
            }
            if (this.mFecType == FecType.GENERAL_180VR) {
                GL2JNILib.setDewarpType(GL2JNIView.this.mJNIHandle, 0);
                GL2JNILib.setMountType(GL2JNIView.this.mJNIHandle, 0);
            } else if (this.mFecType == FecType.GENERAL_360VR) {
                GL2JNILib.setDewarpType(GL2JNIView.this.mJNIHandle, 0);
                GL2JNILib.setMountType(GL2JNIView.this.mJNIHandle, 1);
            } else if (this.mFecType == FecType.NO_DEWARP) {
                GL2JNILib.setDewarpType(GL2JNIView.this.mJNIHandle, 4);
                GL2JNILib.setMountType(GL2JNIView.this.mJNIHandle, 1);
            } else {
                GL2JNILib.setDewarpFecCenter(GL2JNIView.this.mJNIHandle, 0, 0, 0, 0, 0, true);
                GL2JNILib.setDewarpType(GL2JNIView.this.mJNIHandle, 6);
                GL2JNILib.setMountType(GL2JNIView.this.mJNIHandle, 1);
            }
            GL2JNILib.setZoom(GL2JNIView.this.mJNIHandle, 0.0f, 0.0f, 0.0f);
        }

        private void resetInitStat() {
            if (this.mFecType == FecType.NO_DEWARP) {
                GL2JNILib.handleTouchPinch(GL2JNIView.this.mJNIHandle, 1.0f);
            } else if (this.mFecType == FecType.GENERAL_180VR && null != GL2JNIView.this.mHandler) {
                GL2JNIView.this.mHandler.sendEmptyMessageDelayed(256, 100L);
            }
        }

        public void onDrawFrame(GL10 gl) {
            GL2JNILib.dataUpdate(GL2JNIView.this.mJNIHandle, ((Object)((Object)GL2JNIView.this)).hashCode());
        }

        public void onSurfaceChanged(GL10 gl, int width, int height) {
            GL2JNILib.init(GL2JNIView.this.mJNIHandle, width, height);
            this.initGL2JNILib(width, height);
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            if (!GL2JNIView.this.mSurfaceViewCreated) {
                GL2JNIView.this.mSurfaceViewCreated = true;
                this.resetInitStat();
            }
        }

        public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        }

        public void onTouchDown(float x, float y) {
            GL2JNILib.handleTouchDown(GL2JNIView.this.mJNIHandle, x, y);
        }

        public void onTouchMove(float x, float y) {
            GL2JNILib.handleTouchMove(GL2JNIView.this.mJNIHandle, x, y);
        }

        public void onTouchUp(float x, float y) {
            GL2JNILib.handleTouchUp(GL2JNIView.this.mJNIHandle, x, y);
            if (mMode != 2) {
                float[] values = new float[2];
                GL2JNILib.getZoom(GL2JNIView.this.mJNIHandle, values);
                if (Math.abs(values[0]) > 3.0f) {
                    values[0] = 3.0f * values[0] / Math.abs(values[0]);
                }
                if (Math.abs(values[1]) > 3.0f) {
                    values[1] = 3.0f * values[1] / Math.abs(values[1]);
                }
                if (Math.abs(values[0]) < 0.1f) {
                    values[1] = 0.0f;
                    values[0] = 0.0f;
                    GL2JNILib.setZoom(GL2JNIView.this.mJNIHandle, values[0], values[1], 0.0f);
                } else {
                    GL2JNIView.this.deceleration(values[0], values[1]);
                }
                if (GL2JNIView.this.mRenderer.getFecType() == FecType.FISHEYE_360VR || GL2JNIView.this.mRenderer.getFecType() == FecType.GENERAL_360VR) {
                    GL2JNIView.this.mHandler.sendEmptyMessage(262);
                }
            }
        }

        public FecType getFecType() {
            return this.mFecType;
        }
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private static int EGL_OPENGL_ES2_BIT = 4;
        private static int[] s_configAttribs2 = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, EGL_OPENGL_ES2_BIT, 12344};
        protected int mRedSize;
        protected int mGreenSize;
        protected int mBlueSize;
        protected int mAlphaSize;
        protected int mDepthSize;
        protected int mStencilSize;
        private int[] mValue = new int[1];

        public ConfigChooser(int r, int g, int b, int a, int depth, int stencil) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = depth;
            this.mStencilSize = stencil;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] num_config = new int[1];
            egl.eglChooseConfig(display, s_configAttribs2, null, 0, num_config);
            int numConfigs = num_config[0];
            if (numConfigs <= 0) {
                throw new IllegalArgumentException("No configs match configSpec");
            }
            EGLConfig[] configs = new EGLConfig[numConfigs];
            egl.eglChooseConfig(display, s_configAttribs2, configs, numConfigs, num_config);
            return this.chooseConfig(egl, display, configs);
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                return this.mValue[0];
            }
            return defaultValue;
        }

        private void printConfigs(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            int numConfigs = configs.length;
            Log.w((String)TAG, (String)String.format("%d configurations", numConfigs));
            for (int i = 0; i < numConfigs; ++i) {
                Log.w((String)TAG, (String)String.format("Configuration %d:\n", i));
                this.printConfig(egl, display, configs[i]);
            }
        }

        private void printConfig(EGL10 egl, EGLDisplay display, EGLConfig config) {
            int[] attributes = new int[]{12320, 12321, 12322, 12323, 12324, 12325, 12326, 12327, 12328, 12329, 12330, 12331, 12332, 12333, 12334, 12335, 12336, 12337, 12338, 12339, 12340, 12343, 12342, 12341, 12345, 12346, 12347, 12348, 12349, 12350, 12351, 12352, 12354};
            String[] names = new String[]{"EGL_BUFFER_SIZE", "EGL_ALPHA_SIZE", "EGL_BLUE_SIZE", "EGL_GREEN_SIZE", "EGL_RED_SIZE", "EGL_DEPTH_SIZE", "EGL_STENCIL_SIZE", "EGL_CONFIG_CAVEAT", "EGL_CONFIG_ID", "EGL_LEVEL", "EGL_MAX_PBUFFER_HEIGHT", "EGL_MAX_PBUFFER_PIXELS", "EGL_MAX_PBUFFER_WIDTH", "EGL_NATIVE_RENDERABLE", "EGL_NATIVE_VISUAL_ID", "EGL_NATIVE_VISUAL_TYPE", "EGL_PRESERVED_RESOURCES", "EGL_SAMPLES", "EGL_SAMPLE_BUFFERS", "EGL_SURFACE_TYPE", "EGL_TRANSPARENT_TYPE", "EGL_TRANSPARENT_RED_VALUE", "EGL_TRANSPARENT_GREEN_VALUE", "EGL_TRANSPARENT_BLUE_VALUE", "EGL_BIND_TO_TEXTURE_RGB", "EGL_BIND_TO_TEXTURE_RGBA", "EGL_MIN_SWAP_INTERVAL", "EGL_MAX_SWAP_INTERVAL", "EGL_LUMINANCE_SIZE", "EGL_ALPHA_MASK_SIZE", "EGL_COLOR_BUFFER_TYPE", "EGL_RENDERABLE_TYPE", "EGL_CONFORMANT"};
            int[] value = new int[1];
            for (int i = 0; i < attributes.length; ++i) {
                int attribute = attributes[i];
                String name = names[i];
                if (egl.eglGetConfigAttrib(display, config, attribute, value)) {
                    Log.w((String)TAG, (String)String.format("  %s: %d\n", name, value[0]));
                    continue;
                }
                while (egl.eglGetError() != 12288) {
                }
            }
        }
    }

    private static class ContextFactory
    implements GLSurfaceView.EGLContextFactory {
        private static int EGL_CONTEXT_CLIENT_VERSION = 12440;

        private ContextFactory() {
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay display, EGLConfig eglConfig) {
            Log.w((String)TAG, (String)"creating OpenGL ES 2.0 context");
            GL2JNIView.checkEglError("Before eglCreateContext", egl);
            int[] attrib_list = new int[]{EGL_CONTEXT_CLIENT_VERSION, 2, 12344};
            EGLContext context = egl.eglCreateContext(display, eglConfig, EGL10.EGL_NO_CONTEXT, attrib_list);
            GL2JNIView.checkEglError("After eglCreateContext", egl);
            return context;
        }

        public void destroyContext(EGL10 egl, EGLDisplay display, EGLContext context) {
            egl.eglDestroyContext(display, context);
        }
    }

    public static enum FecType {
        NORMAL,
        GENERAL_180VR,
        GENERAL_360VR,
        FISHEYE_180VR,
        FISHEYE_360VR,
        NO_DEWARP;

    }
}

