/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter.handler;

import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiFieldError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiGlobalError;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ErrorHandlingProperties;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.handler.AbstractApiExceptionHandler;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import org.hibernate.validator.internal.engine.ConstraintViolationImpl;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public class BindApiExceptionHandler
extends AbstractApiExceptionHandler {
    private final ErrorHandlingProperties properties;

    public BindApiExceptionHandler(ErrorHandlingProperties properties, HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        super(httpStatusMapper, errorCodeMapper, errorMessageMapper);
        this.properties = properties;
    }

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof BindingResult;
    }

    @Override
    public ApiErrorResponse handle(Throwable exception) {
        BindingResult bindingResult = (BindingResult)exception;
        ApiErrorResponse response = new ApiErrorResponse(this.getHttpStatus(exception, HttpStatus.BAD_REQUEST), this.getErrorCode(exception), this.getMessage(bindingResult));
        if (bindingResult.hasFieldErrors()) {
            bindingResult.getFieldErrors().stream().map(fieldError -> new ApiFieldError(this.getCode((FieldError)fieldError), fieldError.getField(), this.getMessage((FieldError)fieldError), fieldError.getRejectedValue(), this.getPath((FieldError)fieldError))).forEach(response::addFieldError);
        }
        if (bindingResult.hasGlobalErrors()) {
            bindingResult.getGlobalErrors().stream().map(globalError -> new ApiGlobalError(this.errorCodeMapper.getErrorCode(globalError.getCode()), this.errorMessageMapper.getErrorMessage(globalError.getCode(), globalError.getDefaultMessage()))).forEach(response::addGlobalError);
        }
        return response;
    }

    private String getCode(FieldError fieldError) {
        String code = fieldError.getCode();
        String fieldSpecificCode = fieldError.getField() + "." + code;
        return this.errorCodeMapper.getErrorCode(fieldSpecificCode, code);
    }

    private String getMessage(FieldError fieldError) {
        String code = fieldError.getCode();
        String fieldSpecificCode = fieldError.getField() + "." + code;
        return this.errorMessageMapper.getErrorMessage(fieldSpecificCode, code, fieldError.getDefaultMessage());
    }

    private String getMessage(BindingResult bindingResult) {
        return "Validation failed for object='" + bindingResult.getObjectName() + "'. Error count: " + bindingResult.getErrorCount();
    }

    private String getPath(FieldError fieldError) {
        if (!this.properties.isAddPathToError()) {
            return null;
        }
        String path = null;
        try {
            path = ((ConstraintViolationImpl)fieldError.unwrap(ConstraintViolationImpl.class)).getPropertyPath().toString();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return path;
    }
}

