/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.errorhandlingspringbootstarter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.ApiErrorResponse;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorCodeMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.ErrorMessageMapper;
import io.github.wimdeblauwe.errorhandlingspringbootstarter.mapper.HttpStatusMapper;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class ApiErrorResponseAccessDeniedHandler
implements AccessDeniedHandler {
    private final ObjectMapper objectMapper;
    private final HttpStatusMapper httpStatusMapper;
    private final ErrorCodeMapper errorCodeMapper;
    private final ErrorMessageMapper errorMessageMapper;

    public ApiErrorResponseAccessDeniedHandler(ObjectMapper objectMapper, HttpStatusMapper httpStatusMapper, ErrorCodeMapper errorCodeMapper, ErrorMessageMapper errorMessageMapper) {
        this.objectMapper = objectMapper;
        this.httpStatusMapper = httpStatusMapper;
        this.errorCodeMapper = errorCodeMapper;
        this.errorMessageMapper = errorMessageMapper;
    }

    public void handle(HttpServletRequest request, HttpServletResponse response, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        ApiErrorResponse errorResponse = this.createResponse(accessDeniedException);
        response.setStatus(errorResponse.getHttpStatus().value());
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.toString());
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)errorResponse));
    }

    public ApiErrorResponse createResponse(AccessDeniedException exception) {
        HttpStatusCode httpStatus = this.httpStatusMapper.getHttpStatus((Throwable)exception, HttpStatus.FORBIDDEN);
        String code = this.errorCodeMapper.getErrorCode((Throwable)exception);
        String message = this.errorMessageMapper.getErrorMessage((Throwable)exception);
        return new ApiErrorResponse(httpStatus, code, message);
    }
}

