/*
 * Decompiled with CFR 0.152.
 */
package com.vbytsyuk.ahbottomnavigation;

import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.view.ViewGroup;
import com.vbytsyuk.ahbottomnavigation.AHBottomNavigation;

public class AHBottomNavigationFABBehavior
extends CoordinatorLayout.Behavior<FloatingActionButton> {
    private int navigationBarHeight = 0;
    private long lastSnackbarUpdate = 0L;

    public AHBottomNavigationFABBehavior(int navigationBarHeight) {
        this.navigationBarHeight = navigationBarHeight;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            return true;
        }
        if (dependency != null && dependency instanceof AHBottomNavigation) {
            return true;
        }
        return super.layoutDependsOn(parent, (View)child, dependency);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, FloatingActionButton child, View dependency) {
        this.updateFloatingActionButton(child, dependency);
        return super.onDependentViewChanged(parent, (View)child, dependency);
    }

    private void updateFloatingActionButton(FloatingActionButton child, View dependency) {
        if (child != null && dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.lastSnackbarUpdate = System.currentTimeMillis();
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int fabDefaultBottomMargin = p.bottomMargin;
            child.setY(dependency.getY() - (float)fabDefaultBottomMargin);
        } else if (child != null && dependency != null && dependency instanceof AHBottomNavigation) {
            if (System.currentTimeMillis() - this.lastSnackbarUpdate < 30L) {
                return;
            }
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int fabDefaultBottomMargin = p.bottomMargin;
            child.setY(dependency.getY() - (float)fabDefaultBottomMargin);
        }
    }
}

