/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import java.util.List;
import org.outerj.daisy.diff.output.TextDiffOutput;
import org.outerj.daisy.diff.tag.AtomList;
import org.outerj.eclipse.jgit.diff.Edit;
import org.outerj.eclipse.jgit.diff.EditList;

public class AtomFormat {
    public static final AtomFormat INSTANCE = new AtomFormat();
    private final int context = 3000000;

    public void format(EditList edits, AtomList a, AtomList b, TextDiffOutput output) throws Exception {
        int curIdx = 0;
        while (curIdx < edits.size()) {
            Edit curEdit = (Edit)edits.get(curIdx);
            int endIdx = this.findCombinedEnd(edits, curIdx);
            Edit endEdit = (Edit)edits.get(endIdx);
            int aCur = 0;
            int bCur = 0;
            int aEnd = a.size();
            int bEnd = b.size();
            while (aCur < aEnd || bCur < bEnd) {
                if (aCur < curEdit.getBeginA() || endIdx + 1 < curIdx) {
                    if (aCur < aEnd) {
                        output.addClearPart(a.getAtom(aCur).getFullText());
                    }
                    ++aCur;
                    ++bCur;
                } else if (aCur < curEdit.getEndA()) {
                    output.addRemovedPart(a.getAtom(aCur).getFullText());
                    ++aCur;
                } else if (bCur < curEdit.getEndB()) {
                    output.addAddedPart(b.getAtom(bCur).getFullText());
                    ++bCur;
                }
                if (!AtomFormat.end(curEdit, aCur, bCur) || ++curIdx >= edits.size()) continue;
                curEdit = (Edit)edits.get(curIdx);
            }
        }
    }

    private int findCombinedEnd(List<Edit> edits, int i) {
        int end;
        for (end = i + 1; end < edits.size() && (this.combineA(edits, end) || this.combineB(edits, end)); ++end) {
        }
        return end - 1;
    }

    private boolean combineA(List<Edit> e, int i) {
        return e.get(i).getBeginA() - e.get(i - 1).getEndA() <= 6000000;
    }

    private boolean combineB(List<Edit> e, int i) {
        return e.get(i).getBeginB() - e.get(i - 1).getEndB() <= 6000000;
    }

    private static boolean end(Edit edit, int a, int b) {
        return edit.getEndA() <= a && edit.getEndB() <= b;
    }
}

