/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.abi;

import java.util.List;
import java.util.stream.Collectors;
import org.tron.trident.abi.TypeReference;
import org.tron.trident.abi.Utils;
import org.tron.trident.abi.datatypes.Event;
import org.tron.trident.abi.datatypes.Type;
import org.tron.trident.crypto.Hash;
import org.tron.trident.utils.Numeric;

public class EventEncoder {
    private EventEncoder() {
    }

    public static String encode(Event event) {
        String methodSignature = EventEncoder.buildMethodSignature(event.getName(), event.getParameters());
        return EventEncoder.buildEventSignature(methodSignature);
    }

    static <T extends Type> String buildMethodSignature(String methodName, List<TypeReference<T>> parameters) {
        StringBuilder result = new StringBuilder();
        result.append(methodName);
        result.append("(");
        String params = parameters.stream().map(p -> Utils.getTypeName(p)).collect(Collectors.joining(","));
        result.append(params);
        result.append(")");
        return result.toString();
    }

    public static String buildEventSignature(String methodSignature) {
        byte[] input = methodSignature.getBytes();
        byte[] hash = Hash.sha3(input);
        return Numeric.toHexString(hash);
    }
}

