/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.InitializeException;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Consumer;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Strings;
import io.github.toolfactory.narcissus.Narcissus;
import java.util.Map;
import sun.misc.Unsafe;

public interface ThrowExceptionFunction
extends Consumer<Throwable> {
    public <T> T apply(Throwable var1);

    public <T> T apply(String var1, Object ... var2);

    public <T> T apply(int var1, String var2, Object ... var3);

    public static interface Native
    extends ThrowExceptionFunction {

        public static class ForJava7
        extends Abst
        implements Native {
            public ForJava7(Map<Object, Object> context) throws InitializeException {
                this.checkNativeEngine();
            }

            protected void checkNativeEngine() throws InitializeException {
                if (!Narcissus.libraryLoaded) {
                    throw new InitializeException(Strings.compile("Could not initialize the native engine {}", Narcissus.class.getName()));
                }
            }

            @Override
            public void accept(Throwable exception) {
                if (exception == null) {
                    throw new NullPointerException("Input exception is null");
                }
                Narcissus.sneakyThrow((Throwable)exception);
            }
        }
    }

    public static class ForJava7
    extends Abst {
        protected Unsafe unsafe;

        public ForJava7(Map<Object, Object> context) {
            this.unsafe = (Unsafe)ObjectProvider.get(context).getOrBuildObject(UnsafeSupplier.class, context).get();
        }

        @Override
        public void accept(Throwable exception) {
            this.unsafe.throwException(exception);
        }
    }

    public static abstract class Abst
    implements ThrowExceptionFunction {
        @Override
        public <T> T apply(Throwable exception) {
            if (exception == null) {
                throw new NullPointerException("Input exception is null");
            }
            this.accept(exception);
            return null;
        }

        @Override
        public <T> T apply(String message, Object ... placeHolderReplacements) {
            return this.apply(3, message, placeHolderReplacements);
        }

        @Override
        public <T> T apply(int stackTraceStartingLevel, String message, Object ... placeHolderReplacements) {
            Exception exception = null;
            StackTraceElement[] stackTraceOfException = null;
            exception = placeHolderReplacements == null || placeHolderReplacements.length == 0 ? new Exception(message) : new Exception(Strings.compile(message, placeHolderReplacements));
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            stackTraceOfException = new StackTraceElement[stackTrace.length - stackTraceStartingLevel];
            System.arraycopy(stackTrace, stackTraceStartingLevel, stackTraceOfException, 0, stackTraceOfException.length);
            exception.setStackTrace(stackTraceOfException);
            this.accept(exception);
            return null;
        }
    }
}

