/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "chunkEntries", "", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox$Entry;", "(Ljava/util/List;)V", "size", "", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "Entry", "core_release"})
@SourceDebugExtension(value={"SMAP\nSampleToChunkBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SampleToChunkBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1855#2,2:44\n*S KotlinDebug\n*F\n+ 1 SampleToChunkBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox\n*L\n27#1:44,2\n*E\n"})
public final class SampleToChunkBox
extends FullBox {
    @NotNull
    private final List<Entry> chunkEntries;
    private final int size;

    public SampleToChunkBox(@NotNull List<Entry> chunkEntries) {
        Intrinsics.checkNotNullParameter(chunkEntries, (String)"chunkEntries");
        super("stsc", (byte)0, 0, false, 8, null);
        this.chunkEntries = chunkEntries;
        this.size = super.getSize() + 4 + 12 * this.chunkEntries.size();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.putInt(this.chunkEntries.size());
        Iterable $this$forEach$iv = this.chunkEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            it.write(output);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/SampleToChunkBox$Entry;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "firstChunk", "", "samplesPerChunk", "sampleDescriptionId", "(III)V", "getSamplesPerChunk", "()I", "size", "getSize", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
    public static final class Entry
    extends ByteBufferWriter {
        private final int firstChunk;
        private final int samplesPerChunk;
        private final int sampleDescriptionId;
        private final int size;

        public Entry(int firstChunk, int samplesPerChunk, int sampleDescriptionId) {
            this.firstChunk = firstChunk;
            this.samplesPerChunk = samplesPerChunk;
            this.sampleDescriptionId = sampleDescriptionId;
            this.size = 12;
        }

        public final int getSamplesPerChunk() {
            return this.samplesPerChunk;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void write(@NotNull ByteBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            output.putInt(this.firstChunk);
            output.putInt(this.samplesPerChunk);
            output.putInt(this.sampleDescriptionId);
        }
    }
}

