/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.utils.TimeUtils;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/MediaHeaderBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "version", "", "creationTime", "", "modificationTime", "timescale", "", "duration", "language", "", "(BJJIJS)V", "size", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
public final class MediaHeaderBox
extends FullBox {
    private final long creationTime;
    private final long modificationTime;
    private final int timescale;
    private final long duration;
    private final short language;
    private final int size;

    public MediaHeaderBox(byte version, long creationTime, long modificationTime, int timescale, long duration, short language) {
        super("mdhd", version, 0, false, 8, null);
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.timescale = timescale;
        this.duration = duration;
        this.language = language;
        this.size = super.getSize() + (version == 1 ? 28 : 16) + 4;
    }

    public /* synthetic */ MediaHeaderBox(byte by, long l, long l2, int n, long l3, short s, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            l = TimeUtils.INSTANCE.getUtcNowIsom();
        }
        if ((n2 & 4) != 0) {
            l2 = TimeUtils.INSTANCE.getUtcNowIsom();
        }
        if ((n2 & 0x20) != 0) {
            s = 0;
        }
        this(by, l, l2, n, l3, s);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        byte by = this.getVersion();
        if (by == 1) {
            output.putLong(this.creationTime);
            output.putLong(this.modificationTime);
            output.putInt(this.timescale);
            output.putLong(this.duration);
        } else if (by == 0) {
            ByteBufferExtensionsKt.putInt(output, this.creationTime);
            ByteBufferExtensionsKt.putInt(output, this.modificationTime);
            output.putInt(this.timescale);
            ByteBufferExtensionsKt.putInt(output, this.duration);
        } else {
            throw new IllegalArgumentException("Version must be 0 or 1");
        }
        output.putShort(this.language);
        output.putShort((short)0);
    }
}

