/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.flv.tags;

import io.github.thibaultbee.streampack.internal.muxers.flv.tags.TagType;
import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H$J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H$R\u0012\u0010\t\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag;", "", "ts", "", "type", "Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/TagType;", "isEncrypted", "", "(JLio/github/thibaultbee/streampack/internal/muxers/flv/tags/TagType;Z)V", "bodySize", "", "getBodySize", "()I", "tagHeaderSize", "getTagHeaderSize", "write", "Ljava/nio/ByteBuffer;", "writeBody", "", "output", "writeTagHeader", "Companion", "core_release"})
public abstract class FlvTag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long ts;
    @NotNull
    private final TagType type;
    private final boolean isEncrypted;
    private static final int FLV_HEADER_TAG_SIZE = 11;

    public FlvTag(long ts, @NotNull TagType type, boolean isEncrypted) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.ts = ts;
        this.type = type;
        this.isEncrypted = isEncrypted;
    }

    public /* synthetic */ FlvTag(long l, TagType tagType, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(l, tagType, bl);
    }

    protected abstract void writeTagHeader(@NotNull ByteBuffer var1);

    protected abstract int getTagHeaderSize();

    protected abstract void writeBody(@NotNull ByteBuffer var1);

    protected abstract int getBodySize();

    @NotNull
    public final ByteBuffer write() {
        int dataSize = this.getTagHeaderSize() + this.getBodySize();
        int flvTagSize = 11 + dataSize;
        ByteBuffer buffer = ByteBuffer.allocateDirect(flvTagSize + 4);
        Intrinsics.checkNotNull((Object)buffer);
        ByteBufferExtensionsKt.put(buffer, BitOperationExtensionsKt.shl(this.isEncrypted, 5) | this.type.getValue());
        ByteBufferExtensionsKt.putInt24(buffer, dataSize);
        int tsInMs = (int)(this.ts / (long)1000);
        ByteBufferExtensionsKt.putInt24(buffer, tsInMs);
        buffer.put((byte)(tsInMs >> 24));
        ByteBufferExtensionsKt.putInt24(buffer, 0);
        this.writeTagHeader(buffer);
        if (this.isEncrypted) {
            throw new NotImplementedError("Filter/encryption is not implemented yet");
        }
        this.writeBody(buffer);
        buffer.putInt(flvTagSize);
        buffer.rewind();
        return buffer;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/flv/tags/FlvTag$Companion;", "", "()V", "FLV_HEADER_TAG_SIZE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

