/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.gl;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Size;
import io.github.thibaultbee.streampack.internal.gl.Texture2DProgram;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u001b"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/FullFrameRect;", "", "program", "Lio/github/thibaultbee/streampack/internal/gl/Texture2DProgram;", "(Lio/github/thibaultbee/streampack/internal/gl/Texture2DProgram;)V", "mvpMatrix", "", "getProgram", "()Lio/github/thibaultbee/streampack/internal/gl/Texture2DProgram;", "setProgram", "changeProgram", "", "createTextureObject", "", "drawFrame", "textureId", "texMatrix", "release", "doEglCleanup", "", "setMVPMatrixAndViewPort", "rotation", "", "resolution", "Landroid/util/Size;", "mirroredVertically", "Companion", "core_release"})
public final class FullFrameRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Texture2DProgram program;
    @NotNull
    private final float[] mvpMatrix;
    @NotNull
    private static final float[] FULL_RECTANGLE_COORDS;
    @NotNull
    private static final FloatBuffer FULL_RECTANGLE_BUF;
    @NotNull
    private static final float[] FULL_RECTANGLE_TEX_COORDS;
    @NotNull
    private static final FloatBuffer FULL_RECTANGLE_TEX_BUF;

    public FullFrameRect(@NotNull Texture2DProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        this.program = program;
        this.mvpMatrix = new float[16];
    }

    @NotNull
    public final Texture2DProgram getProgram() {
        return this.program;
    }

    public final void setProgram(@NotNull Texture2DProgram texture2DProgram) {
        Intrinsics.checkNotNullParameter((Object)texture2DProgram, (String)"<set-?>");
        this.program = texture2DProgram;
    }

    public final void release(boolean doEglCleanup) {
        if (doEglCleanup) {
            this.program.release();
        }
    }

    public final void changeProgram(@NotNull Texture2DProgram program) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        this.program.release();
        this.program = program;
    }

    public final int createTextureObject() {
        return this.program.createTextureObject();
    }

    public final void setMVPMatrixAndViewPort(float rotation, @NotNull Size resolution, boolean mirroredVertically) {
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        Matrix.setIdentityM((float[])this.mvpMatrix, (int)0);
        Matrix.scaleM((float[])this.mvpMatrix, (int)0, (float)(mirroredVertically ? -1.0f : 1.0f), (float)1.0f, (float)0.0f);
        Matrix.rotateM((float[])this.mvpMatrix, (int)0, (float)rotation, (float)0.0f, (float)0.0f, (float)-1.0f);
        GLES20.glViewport((int)0, (int)0, (int)resolution.getWidth(), (int)resolution.getHeight());
    }

    public final void drawFrame(int textureId, @NotNull float[] texMatrix) {
        Intrinsics.checkNotNullParameter((Object)texMatrix, (String)"texMatrix");
        this.program.draw(this.mvpMatrix, FULL_RECTANGLE_BUF, 0, 4, 2, 8, texMatrix, FULL_RECTANGLE_TEX_BUF, textureId, 8);
    }

    static {
        float[] fArray = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        FULL_RECTANGLE_COORDS = fArray;
        FULL_RECTANGLE_BUF = FullFrameRect.Companion.createFloatBuffer(FullFrameRect.FULL_RECTANGLE_COORDS);
        fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
        FULL_RECTANGLE_TEX_COORDS = fArray;
        FULL_RECTANGLE_TEX_BUF = FullFrameRect.Companion.createFloatBuffer(FullFrameRect.FULL_RECTANGLE_TEX_COORDS);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/github/thibaultbee/streampack/internal/gl/FullFrameRect$Companion;", "", "()V", "FULL_RECTANGLE_BUF", "Ljava/nio/FloatBuffer;", "FULL_RECTANGLE_COORDS", "", "FULL_RECTANGLE_TEX_BUF", "FULL_RECTANGLE_TEX_COORDS", "createFloatBuffer", "coords", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        private final FloatBuffer createFloatBuffer(float[] coords) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(coords.length * 4);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(...)");
            ByteBuffer bb = byteBuffer;
            bb.order(ByteOrder.nativeOrder());
            FloatBuffer floatBuffer = bb.asFloatBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)floatBuffer, (String)"asFloatBuffer(...)");
            FloatBuffer fb = floatBuffer;
            fb.put(coords);
            fb.position(0);
            return fb;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

