/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.DynamicRangeProfiles;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.util.Range;
import android.util.Rational;
import android.util.Size;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\u001a\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001e\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001a0\u0001*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a0\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001\"\b\b\u0000\u0010\u001d*\u00020\u001e*\u00020\u00032\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0010\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u0003\u001a\"\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0001*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00022\b\b\u0002\u0010\"\u001a\u00020\u0014\u001a\u0019\u0010#\u001a\u0004\u0018\u00010\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0002\u0010$\u001a\"\u0010%\u001a\u0012\u0012\f\u0012\n &*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u001a*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0014\u0010'\u001a\u0004\u0018\u00010(*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0019\u0010)\u001a\u0004\u0018\u00010\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0002\u0010$\u001a\u0019\u0010*\u001a\u0004\u0018\u00010\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0002\u0010$\u001a \u0010+\u001a\u0010\u0012\f\u0012\n &*\u0004\u0018\u00010,0,0\u001a*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0012\u0010-\u001a\u00020,*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\"\u0010.\u001a\u0012\u0012\f\u0012\n &*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u001a*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0019\u0010/\u001a\u0004\u0018\u00010\u0014*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0002\u0010$\u001a\u001c\u00100\u001a\n\u0012\u0004\u0012\u00020,\u0018\u00010\u001a*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0007\u001a\u0012\u00101\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0012\u00103\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001c\u00104\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u00105\u001a\u00020\u0014H\u0002\u001a\u0012\u00106\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0012\u00107\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u001a\u00108\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u00109\u001a\u00020\u0014\u001a\u0012\u0010:\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\u001a\u0012\u0010;\u001a\u000202*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\b\u001a\u00020\u0002*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0005\"\u001b\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\u00a8\u0006<"}, d2={"backCameraList", "", "", "Landroid/content/Context;", "getBackCameraList", "(Landroid/content/Context;)Ljava/util/List;", "cameraList", "getCameraList", "defaultCameraId", "getDefaultCameraId", "(Landroid/content/Context;)Ljava/lang/String;", "externalCameraList", "getExternalCameraList", "frontCameraList", "getFrontCameraList", "get10BitSupportedProfiles", "", "", "cameraId", "getAutoExposureModes", "", "getAutoFocusModes", "getAutoWhiteBalanceModes", "getCameraCharacteristics", "Landroid/hardware/camera2/CameraCharacteristics;", "getCameraFpsList", "Landroid/util/Range;", "getCameraOutputSizes", "Landroid/util/Size;", "T", "", "klass", "Ljava/lang/Class;", "getCameraOutputStreamSizes", "imageFormat", "getExposureMaxMeteringRegionsSupported", "(Landroid/content/Context;Ljava/lang/String;)Ljava/lang/Integer;", "getExposureRange", "kotlin.jvm.PlatformType", "getExposureStep", "Landroid/util/Rational;", "getFacingDirection", "getFocusMaxMeteringRegionsSupported", "getLensDistanceRange", "", "getScalerMaxZoom", "getSensitivityRange", "getWhiteBalanceMeteringRegionsSupported", "getZoomRatioRange", "is10BitProfileSupported", "", "isBackCamera", "isCapabilitiesSupported", "capability", "isExternalCamera", "isFlashAvailable", "isFrameRateSupported", "fps", "isFrontCamera", "isOpticalStabilizationAvailable", "core_release"})
@SourceDebugExtension(value={"SMAP\nContextExtensionsForCamera.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContextExtensionsForCamera.kt\nio/github/thibaultbee/streampack/utils/ContextExtensionsForCameraKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,396:1\n766#2:397\n857#2,2:398\n766#2:400\n857#2,2:401\n766#2:403\n857#2,2:404\n1747#2,3:406\n1855#2,2:409\n*S KotlinDebug\n*F\n+ 1 ContextExtensionsForCamera.kt\nio/github/thibaultbee/streampack/utils/ContextExtensionsForCameraKt\n*L\n81#1:397\n81#1:398,2\n89#1:400\n89#1:401,2\n99#1:403\n99#1:404,2\n163#1:406,3\n319#1:409,2\n*E\n"})
public final class ContextExtensionsForCameraKt {
    @NotNull
    public static final CameraCharacteristics getCameraCharacteristics(@NotNull Context $this$getCameraCharacteristics, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraCharacteristics, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Object object = $this$getCameraCharacteristics.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        CameraCharacteristics cameraCharacteristics = cameraManager.getCameraCharacteristics(cameraId2);
        Intrinsics.checkNotNullExpressionValue((Object)cameraCharacteristics, (String)"getCameraCharacteristics(...)");
        return cameraCharacteristics;
    }

    @NotNull
    public static final String getDefaultCameraId(@NotNull Context $this$defaultCameraId) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultCameraId, (String)"<this>");
        List<String> cameraList = ContextExtensionsForCameraKt.getCameraList($this$defaultCameraId);
        if (cameraList.isEmpty()) {
            throw new IllegalStateException("No camera available");
        }
        List<String> backCameraList = ContextExtensionsForCameraKt.getBackCameraList($this$defaultCameraId);
        return backCameraList.isEmpty() ? (String)CollectionsKt.first(cameraList) : (String)CollectionsKt.first(backCameraList);
    }

    @NotNull
    public static final List<String> getCameraList(@NotNull Context $this$cameraList) {
        Intrinsics.checkNotNullParameter((Object)$this$cameraList, (String)"<this>");
        Object object = $this$cameraList.getSystemService("camera");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.camera2.CameraManager");
        CameraManager cameraManager = (CameraManager)object;
        String[] stringArray = cameraManager.getCameraIdList();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getCameraIdList(...)");
        return ArraysKt.toList((Object[])stringArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getBackCameraList(@NotNull Context $this$backCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$backCameraList, (String)"<this>");
        Iterable $this$filter$iv = ContextExtensionsForCameraKt.getCameraList($this$backCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$backCameraList, it);
            int n2 = 1;
            if (!(n != null && n == n2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getFrontCameraList(@NotNull Context $this$frontCameraList) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$frontCameraList, (String)"<this>");
        Iterable $this$filter$iv = ContextExtensionsForCameraKt.getCameraList($this$frontCameraList);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$frontCameraList, it);
            if (!(n != null && n == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> getExternalCameraList(@NotNull Context $this$externalCameraList) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$externalCameraList, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 23) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = ContextExtensionsForCameraKt.getCameraList($this$externalCameraList);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$externalCameraList, it);
                int n2 = 2;
                if (!(n != null && n == n2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public static final boolean isBackCamera(@NotNull Context $this$isBackCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$isBackCamera, cameraId2);
        int n2 = 1;
        return n != null && n == n2;
    }

    public static final boolean isFrontCamera(@NotNull Context $this$isFrontCamera, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFrontCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$isFrontCamera, cameraId2);
        return n != null && n == 0;
    }

    public static final boolean isExternalCamera(@NotNull Context $this$isExternalCamera, @NotNull String cameraId2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isExternalCamera, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        if (Build.VERSION.SDK_INT >= 23) {
            Integer n = ContextExtensionsForCameraKt.getFacingDirection($this$isExternalCamera, cameraId2);
            int n2 = 2;
            bl = n != null && n == n2;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final Integer getFacingDirection(@NotNull Context $this$getFacingDirection, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFacingDirection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getFacingDirection, cameraId2).get(CameraCharacteristics.LENS_FACING);
    }

    @NotNull
    public static final <T> List<Size> getCameraOutputSizes(@NotNull Context $this$getCameraOutputSizes, @NotNull Class<T> klass, @NotNull String cameraId2) {
        List list;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputSizes, (String)"<this>");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getCameraOutputSizes, cameraId2).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        return streamConfigurationMap != null && (objectArray = streamConfigurationMap.getOutputSizes(klass)) != null && (list = ArraysKt.toList((Object[])objectArray)) != null ? list : CollectionsKt.emptyList();
    }

    public static final boolean isFrameRateSupported(@NotNull Context $this$isFrameRateSupported, @NotNull String cameraId2, int fps) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isFrameRateSupported, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
            Iterable $this$any$iv = ContextExtensionsForCameraKt.getCameraFpsList($this$isFrameRateSupported, cameraId2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Range it = (Range)element$iv;
                    boolean bl2 = false;
                    if (!it.contains((Comparable)Integer.valueOf(fps))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isFlashAvailable(@NotNull Context $this$isFlashAvailable, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isFlashAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Boolean bl = (Boolean)ContextExtensionsForCameraKt.getCameraCharacteristics($this$isFlashAvailable, cameraId2).get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        if (bl == null) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final List<Integer> getAutoWhiteBalanceModes(@NotNull Context $this$getAutoWhiteBalanceModes, @NotNull String cameraId2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getAutoWhiteBalanceModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$getAutoWhiteBalanceModes, cameraId2).get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        return nArray != null && (list = ArraysKt.toList((int[])nArray)) != null ? list : CollectionsKt.emptyList();
    }

    @Nullable
    public static final Range<Integer> getSensitivityRange(@NotNull Context $this$getSensitivityRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getSensitivityRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Range)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getSensitivityRange, cameraId2).get(CameraCharacteristics.SENSOR_INFO_SENSITIVITY_RANGE);
    }

    @Nullable
    public static final Integer getWhiteBalanceMeteringRegionsSupported(@NotNull Context $this$getWhiteBalanceMeteringRegionsSupported, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getWhiteBalanceMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getWhiteBalanceMeteringRegionsSupported, cameraId2).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB);
    }

    @NotNull
    public static final List<Integer> getAutoExposureModes(@NotNull Context $this$getAutoExposureModes, @NotNull String cameraId2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getAutoExposureModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$getAutoExposureModes, cameraId2).get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        return nArray != null && (list = ArraysKt.toList((int[])nArray)) != null ? list : CollectionsKt.emptyList();
    }

    @Nullable
    public static final Range<Integer> getExposureRange(@NotNull Context $this$getExposureRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Range)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getExposureRange, cameraId2).get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
    }

    @Nullable
    public static final Rational getExposureStep(@NotNull Context $this$getExposureStep, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureStep, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Rational)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getExposureStep, cameraId2).get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
    }

    @Nullable
    public static final Integer getExposureMaxMeteringRegionsSupported(@NotNull Context $this$getExposureMaxMeteringRegionsSupported, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getExposureMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getExposureMaxMeteringRegionsSupported, cameraId2).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
    }

    @RequiresApi(value=30)
    @Nullable
    public static final Range<Float> getZoomRatioRange(@NotNull Context $this$getZoomRatioRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getZoomRatioRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Range)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getZoomRatioRange, cameraId2).get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
    }

    public static final float getScalerMaxZoom(@NotNull Context $this$getScalerMaxZoom, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getScalerMaxZoom, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Float f = (Float)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getScalerMaxZoom, cameraId2).get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM);
        return f == null ? 1.0f : f.floatValue();
    }

    @NotNull
    public static final List<Integer> getAutoFocusModes(@NotNull Context $this$getAutoFocusModes, @NotNull String cameraId2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$getAutoFocusModes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$getAutoFocusModes, cameraId2).get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
        return nArray != null && (list = ArraysKt.toList((int[])nArray)) != null ? list : CollectionsKt.emptyList();
    }

    @NotNull
    public static final Range<Float> getLensDistanceRange(@NotNull Context $this$getLensDistanceRange, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getLensDistanceRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Comparable comparable = Float.valueOf(0.0f);
        Float f = (Float)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getLensDistanceRange, cameraId2).get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        if (f == null) {
            f = Float.valueOf(0.0f);
        }
        return new Range(comparable, (Comparable)f);
    }

    @Nullable
    public static final Integer getFocusMaxMeteringRegionsSupported(@NotNull Context $this$getFocusMaxMeteringRegionsSupported, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getFocusMaxMeteringRegionsSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return (Integer)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getFocusMaxMeteringRegionsSupported, cameraId2).get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
    }

    public static final boolean isOpticalStabilizationAvailable(@NotNull Context $this$isOpticalStabilizationAvailable, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$isOpticalStabilizationAvailable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        int[] nArray = (int[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$isOpticalStabilizationAvailable, cameraId2).get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
        return nArray != null ? ArraysKt.contains((int[])nArray, (int)1) : false;
    }

    @NotNull
    public static final List<Size> getCameraOutputStreamSizes(@NotNull Context $this$getCameraOutputStreamSizes) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputStreamSizes, (String)"<this>");
        List<String> cameraIdList = ContextExtensionsForCameraKt.getCameraList($this$getCameraOutputStreamSizes);
        Set resolutionSet = new LinkedHashSet();
        Iterable $this$forEach$iv = cameraIdList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String cameraId2 = (String)element$iv;
            boolean bl = false;
            resolutionSet.addAll(ContextExtensionsForCameraKt.getCameraOutputStreamSizes$default($this$getCameraOutputStreamSizes, cameraId2, 0, 2, null));
        }
        return CollectionsKt.toList((Iterable)resolutionSet);
    }

    @NotNull
    public static final List<Size> getCameraOutputStreamSizes(@NotNull Context $this$getCameraOutputStreamSizes, @NotNull String cameraId2, int imageFormat) {
        List list;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCameraOutputStreamSizes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)ContextExtensionsForCameraKt.getCameraCharacteristics($this$getCameraOutputStreamSizes, cameraId2).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        return streamConfigurationMap != null && (objectArray = streamConfigurationMap.getOutputSizes(imageFormat)) != null && (list = ArraysKt.toList((Object[])objectArray)) != null ? list : CollectionsKt.emptyList();
    }

    public static /* synthetic */ List getCameraOutputStreamSizes$default(Context context, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 35;
        }
        return ContextExtensionsForCameraKt.getCameraOutputStreamSizes(context, string2, n);
    }

    @NotNull
    public static final List<Range<Integer>> getCameraFpsList(@NotNull Context $this$getCameraFpsList, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$getCameraFpsList, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        Object object = (Range[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$getCameraFpsList, cameraId2).get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean isCapabilitiesSupported(Context $this$isCapabilitiesSupported, String cameraId2, int capability) {
        int[] availableCapabilities = (int[])ContextExtensionsForCameraKt.getCameraCharacteristics($this$isCapabilitiesSupported, cameraId2).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        return availableCapabilities != null ? ArraysKt.contains((int[])availableCapabilities, (int)capability) : false;
    }

    public static final boolean is10BitProfileSupported(@NotNull Context $this$is10BitProfileSupported, @NotNull String cameraId2) {
        Intrinsics.checkNotNullParameter((Object)$this$is10BitProfileSupported, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        return Build.VERSION.SDK_INT >= 33 ? ContextExtensionsForCameraKt.isCapabilitiesSupported($this$is10BitProfileSupported, cameraId2, 18) : false;
    }

    @NotNull
    public static final Set<Long> get10BitSupportedProfiles(@NotNull Context $this$get10BitSupportedProfiles, @NotNull String cameraId2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)$this$get10BitSupportedProfiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cameraId2, (String)"cameraId");
        if (Build.VERSION.SDK_INT >= 33) {
            Set set2;
            DynamicRangeProfiles dynamicRangeProfiles = (DynamicRangeProfiles)ContextExtensionsForCameraKt.getCameraCharacteristics($this$get10BitSupportedProfiles, cameraId2).get(CameraCharacteristics.REQUEST_AVAILABLE_DYNAMIC_RANGE_PROFILES);
            Set set3 = set2 = dynamicRangeProfiles != null ? dynamicRangeProfiles.getSupportedProfiles() : null;
            set = set2 == null ? SetsKt.setOf((Object)1L) : set2;
        } else {
            set = SetsKt.setOf((Object)1L);
        }
        return set;
    }
}

