/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers.helpers;

import android.os.Build;
import android.util.Range;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.muxers.IVideoMuxerHelper;
import io.github.thibaultbee.streampack.internal.utils.av.video.DynamicRangeProfile;
import io.github.thibaultbee.streampack.streamers.helpers.IVideoConfigurationHelper;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u00122\u0006\u0010\u0010\u001a\u00020\u000bJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u000bH\u0007J(\u0010\u0016\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00120\u00172\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0010\u001a\u00020\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/thibaultbee/streampack/streamers/helpers/VideoStreamerConfigurationHelper;", "Lio/github/thibaultbee/streampack/streamers/helpers/IVideoConfigurationHelper;", "videoMuxerHelper", "Lio/github/thibaultbee/streampack/internal/muxers/IVideoMuxerHelper;", "(Lio/github/thibaultbee/streampack/internal/muxers/IVideoMuxerHelper;)V", "av1Profiles", "", "", "avcProfiles", "hevcProfiles", "supportedEncoders", "", "getSupportedEncoders", "()Ljava/util/List;", "vp9Profiles", "getSupportedAllProfiles", "mimeType", "getSupportedBitrates", "Landroid/util/Range;", "getSupportedFramerate", "getSupportedHdrProfiles", "getSupportedProfiles", "getSupportedResolutions", "Lkotlin/Pair;", "getSupportedSdrProfiles", "core_release"})
@SourceDebugExtension(value={"SMAP\nStreamerConfigurationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamerConfigurationHelper.kt\nio/github/thibaultbee/streampack/streamers/helpers/VideoStreamerConfigurationHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,304:1\n766#2:305\n857#2,2:306\n766#2:308\n857#2,2:309\n766#2:311\n857#2,2:312\n766#2:314\n857#2,2:315\n*S KotlinDebug\n*F\n+ 1 StreamerConfigurationHelper.kt\nio/github/thibaultbee/streampack/streamers/helpers/VideoStreamerConfigurationHelper\n*L\n152#1:305\n152#1:306,2\n204#1:308\n204#1:309,2\n231#1:311\n231#1:312,2\n261#1:314\n261#1:315,2\n*E\n"})
public class VideoStreamerConfigurationHelper
implements IVideoConfigurationHelper {
    @NotNull
    private final IVideoMuxerHelper videoMuxerHelper;
    @NotNull
    private final List<String> supportedEncoders;
    @NotNull
    private final List<Integer> avcProfiles;
    @NotNull
    private final List<Integer> hevcProfiles;
    @NotNull
    private final List<Integer> vp9Profiles;
    @NotNull
    private final List<Integer> av1Profiles;

    /*
     * WARNING - void declaration
     */
    public VideoStreamerConfigurationHelper(@NotNull IVideoMuxerHelper videoMuxerHelper) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)videoMuxerHelper, (String)"videoMuxerHelper");
        this.videoMuxerHelper = videoMuxerHelper;
        Object[] objectArray = (Object[])MediaCodecHelper.Video.INSTANCE.getSupportedEncoders();
        VideoStreamerConfigurationHelper videoStreamerConfigurationHelper = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.videoMuxerHelper.getSupportedEncoders().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        videoStreamerConfigurationHelper.supportedEncoders = (List)destination$iv$iv;
        objectArray = new Integer[]{1, 65536, 524288, 4, 8, 16, 2};
        this.avcProfiles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{1, 2, 4096, 8192};
        this.hevcProfiles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{1, 4, 4096, 16384};
        this.vp9Profiles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{1, 2, 4096, 8192};
        this.av1Profiles = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getSupportedEncoders() {
        return this.supportedEncoders;
    }

    @Override
    @NotNull
    public Range<Integer> getSupportedBitrates(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Video.INSTANCE.getBitrateRange(mimeType);
    }

    @NotNull
    public Pair<Range<Integer>, Range<Integer>> getSupportedResolutions(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Range<Integer> codecSupportedWidths = MediaCodecHelper.Video.INSTANCE.getSupportedWidths(mimeType);
        Range<Integer> codecSupportedHeights = MediaCodecHelper.Video.INSTANCE.getSupportedHeights(mimeType);
        return new Pair(codecSupportedWidths, codecSupportedHeights);
    }

    @NotNull
    public final Range<Integer> getSupportedFramerate(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return MediaCodecHelper.Video.INSTANCE.getFramerateRange(mimeType);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final List<Integer> getSupportedAllProfiles(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        var3_2 = mimeType;
        tmp = -1;
        switch (var3_2.hashCode()) {
            case 1331836730: {
                if (var3_2.equals("video/avc")) {
                    tmp = 1;
                }
                break;
            }
            case -1662541442: {
                if (var3_2.equals("video/hevc")) {
                    tmp = 2;
                }
                break;
            }
            case 1599127257: {
                if (var3_2.equals("video/x-vnd.on2.vp9")) {
                    tmp = 3;
                }
                break;
            }
            case -1662735862: {
                if (var3_2.equals("video/av01")) {
                    tmp = 4;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v0 = this.avcProfiles;
                break;
            }
            case 2: {
                v0 = this.hevcProfiles;
                break;
            }
            case 3: {
                v0 = this.vp9Profiles;
                break;
            }
            case 4: {
                v0 = this.av1Profiles;
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown mimetype " + mimeType);
            }
        }
        profiles = v0;
        supportedProfiles = MediaCodecHelper.INSTANCE.getProfiles(mimeType);
        $this$filter$iv = profiles;
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            $i$a$-filter-VideoStreamerConfigurationHelper$getSupportedAllProfiles$1 = false;
            if (!supportedProfiles.contains(it)) ** GOTO lbl-1000
            v1 = Build.VERSION.SDK_INT >= 33 ? (DynamicRangeProfile.Companion.fromProfile(mimeType, it).isHdr() ? MediaCodecHelper.INSTANCE.isFeatureSupported(mimeType, "hdr-editing") : true) : true;
            if (v1) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getSupportedHdrProfiles(@NotNull String mimeType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        List<Integer> supportedProfiles = this.getSupportedAllProfiles(mimeType);
        Iterable $this$filter$iv = supportedProfiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!DynamicRangeProfile.Companion.fromProfile(mimeType, it).isHdr()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use [getSdrProfilesSupported] instead", replaceWith=@ReplaceWith(expression="getSdrProfilesSupported(mimeType)", imports={}))
    @NotNull
    public final List<Integer> getSupportedProfiles(@NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return this.getSupportedSdrProfiles(mimeType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getSupportedSdrProfiles(@NotNull String mimeType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        List<Integer> supportedProfiles = this.getSupportedAllProfiles(mimeType);
        Iterable $this$filter$iv = supportedProfiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            boolean bl2 = !DynamicRangeProfile.Companion.fromProfile(mimeType, it).isHdr();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

