/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils.av.video.hevc;

import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import io.github.thibaultbee.streampack.internal.utils.av.video.ChromaFormat;
import io.github.thibaultbee.streampack.internal.utils.av.video.hevc.HEVCProfile;
import io.github.thibaultbee.streampack.internal.utils.av.video.hevc.SequenceParameterSets;
import io.github.thibaultbee.streampack.internal.utils.extensions.BitOperationExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.extensions.ByteBufferExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 >2\u00020\u0001:\u0002>?B\u00b1\u0001\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0005\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0002\u0010\u001dJ\t\u0010!\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\"\u001a\u00020\u0011H\u00c2\u0003J\t\u0010#\u001a\u00020\u0005H\u00c2\u0003J\t\u0010$\u001a\u00020\u0005H\u00c2\u0003J\t\u0010%\u001a\u00020\u0015H\u00c2\u0003J\t\u0010&\u001a\u00020\u0005H\u00c2\u0003J\t\u0010'\u001a\u00020\u0005H\u00c2\u0003J\t\u0010(\u001a\u00020\u0007H\u00c2\u0003J\t\u0010)\u001a\u00020\u0005H\u00c2\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u00c2\u0003J\t\u0010+\u001a\u00020\u0005H\u00c2\u0003J\t\u0010,\u001a\u00020\u0007H\u00c2\u0003J\t\u0010-\u001a\u00020\tH\u00c2\u0003J\t\u0010.\u001a\u00020\u0003H\u00c2\u0003J\t\u0010/\u001a\u00020\fH\u00c2\u0003J\t\u00100\u001a\u00020\u0005H\u00c2\u0003J\t\u00101\u001a\u00020\u0003H\u00c2\u0003J\t\u00102\u001a\u00020\u0005H\u00c2\u0003J\u00c3\u0001\u00103\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00052\b\b\u0002\u0010\u0017\u001a\u00020\u00052\b\b\u0002\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00052\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u00c6\u0001J\u0013\u00104\u001a\u00020\u00072\b\u00105\u001a\u0004\u0018\u000106H\u00d6\u0003J\t\u00107\u001a\u00020\u0003H\u00d6\u0001J\t\u00108\u001a\u000209H\u00d6\u0001J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "configurationVersion", "", "generalProfileSpace", "", "generalTierFlag", "", "generalProfileIdc", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCProfile;", "generalProfileCompatibilityFlags", "generalConstraintIndicatorFlags", "", "generalLevelIdc", "minSpatialSegmentationIdc", "parallelismType", "chromaFormat", "Lio/github/thibaultbee/streampack/internal/utils/av/video/ChromaFormat;", "bitDepthLumaMinus8", "bitDepthChromaMinus8", "averageFrameRate", "", "constantFrameRate", "numTemporalLayers", "temporalIdNested", "lengthSizeMinusOne", "parameterSets", "", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit;", "(IBZLio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCProfile;IJBIBLio/github/thibaultbee/streampack/internal/utils/av/video/ChromaFormat;BBSBBZBLjava/util/List;)V", "size", "getSize", "()I", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "toString", "", "write", "", "output", "Ljava/nio/ByteBuffer;", "Companion", "NalUnit", "core_release"})
@SourceDebugExtension(value={"SMAP\nHEVCDecoderConfigurationRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1855#2,2:223\n1855#2,2:225\n1855#2,2:227\n1855#2,2:229\n1855#2,2:231\n1855#2,2:233\n1855#2,2:235\n*S KotlinDebug\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord\n*L\n88#1:223,2\n98#1:225,2\n99#1:227,2\n100#1:229,2\n101#1:231,2\n102#1:233,2\n103#1:235,2\n*E\n"})
public final class HEVCDecoderConfigurationRecord
extends ByteBufferWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int configurationVersion;
    private final byte generalProfileSpace;
    private final boolean generalTierFlag;
    @NotNull
    private final HEVCProfile generalProfileIdc;
    private final int generalProfileCompatibilityFlags;
    private final long generalConstraintIndicatorFlags;
    private final byte generalLevelIdc;
    private final int minSpatialSegmentationIdc;
    private final byte parallelismType;
    @NotNull
    private final ChromaFormat chromaFormat;
    private final byte bitDepthLumaMinus8;
    private final byte bitDepthChromaMinus8;
    private final short averageFrameRate;
    private final byte constantFrameRate;
    private final byte numTemporalLayers;
    private final boolean temporalIdNested;
    private final byte lengthSizeMinusOne;
    @NotNull
    private final List<NalUnit> parameterSets;
    private final int size;
    private static final int HEVC_DECODER_CONFIGURATION_RECORD_SIZE = 23;
    private static final int HEVC_PARAMETER_SET_HEADER_SIZE = 5;

    public HEVCDecoderConfigurationRecord(int configurationVersion, byte generalProfileSpace, boolean generalTierFlag, @NotNull HEVCProfile generalProfileIdc, int generalProfileCompatibilityFlags, long generalConstraintIndicatorFlags, byte generalLevelIdc, int minSpatialSegmentationIdc, byte parallelismType, @NotNull ChromaFormat chromaFormat, byte bitDepthLumaMinus8, byte bitDepthChromaMinus8, short averageFrameRate, byte constantFrameRate, byte numTemporalLayers, boolean temporalIdNested, byte lengthSizeMinusOne, @NotNull List<NalUnit> parameterSets) {
        Intrinsics.checkNotNullParameter((Object)((Object)generalProfileIdc), (String)"generalProfileIdc");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaFormat), (String)"chromaFormat");
        Intrinsics.checkNotNullParameter(parameterSets, (String)"parameterSets");
        this.configurationVersion = configurationVersion;
        this.generalProfileSpace = generalProfileSpace;
        this.generalTierFlag = generalTierFlag;
        this.generalProfileIdc = generalProfileIdc;
        this.generalProfileCompatibilityFlags = generalProfileCompatibilityFlags;
        this.generalConstraintIndicatorFlags = generalConstraintIndicatorFlags;
        this.generalLevelIdc = generalLevelIdc;
        this.minSpatialSegmentationIdc = minSpatialSegmentationIdc;
        this.parallelismType = parallelismType;
        this.chromaFormat = chromaFormat;
        this.bitDepthLumaMinus8 = bitDepthLumaMinus8;
        this.bitDepthChromaMinus8 = bitDepthChromaMinus8;
        this.averageFrameRate = averageFrameRate;
        this.constantFrameRate = constantFrameRate;
        this.numTemporalLayers = numTemporalLayers;
        this.temporalIdNested = temporalIdNested;
        this.lengthSizeMinusOne = lengthSizeMinusOne;
        this.parameterSets = parameterSets;
        this.size = Companion.getSize(this.parameterSets);
    }

    public /* synthetic */ HEVCDecoderConfigurationRecord(int n, byte by, boolean bl, HEVCProfile hEVCProfile, int n2, long l, byte by2, int n3, byte by3, ChromaFormat chromaFormat, byte by4, byte by5, short s, byte by6, byte by7, boolean bl2, byte by8, List list, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 1;
        }
        if ((n4 & 0x80) != 0) {
            n3 = 0;
        }
        if ((n4 & 0x100) != 0) {
            by3 = 0;
        }
        if ((n4 & 0x200) != 0) {
            chromaFormat = ChromaFormat.YUV420;
        }
        if ((n4 & 0x400) != 0) {
            by4 = 0;
        }
        if ((n4 & 0x800) != 0) {
            by5 = 0;
        }
        if ((n4 & 0x1000) != 0) {
            s = 0;
        }
        if ((n4 & 0x2000) != 0) {
            by6 = 0;
        }
        if ((n4 & 0x4000) != 0) {
            by7 = 0;
        }
        if ((n4 & 0x8000) != 0) {
            bl2 = false;
        }
        if ((n4 & 0x10000) != 0) {
            by8 = (byte)3;
        }
        this(n, by, bl, hEVCProfile, n2, l, by2, n3, by3, chromaFormat, by4, by5, s, by6, by7, bl2, by8, list);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        NalUnit it;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        ByteBufferExtensionsKt.put(output, this.configurationVersion);
        ByteBufferExtensionsKt.put(output, BitOperationExtensionsKt.shl(this.generalProfileSpace, 6) | BitOperationExtensionsKt.shl(this.generalTierFlag, 5) | this.generalProfileIdc.getValue());
        output.putInt(this.generalProfileCompatibilityFlags);
        ByteBufferExtensionsKt.putLong48(output, this.generalConstraintIndicatorFlags);
        output.put(this.generalLevelIdc);
        ByteBufferExtensionsKt.putShort(output, 0xF000 | this.minSpatialSegmentationIdc);
        ByteBufferExtensionsKt.put(output, 0xFC | this.parallelismType);
        ByteBufferExtensionsKt.put(output, 0xFC | this.chromaFormat.getValue());
        ByteBufferExtensionsKt.put(output, 0xF8 | this.bitDepthLumaMinus8);
        ByteBufferExtensionsKt.put(output, 0xF8 | this.bitDepthChromaMinus8);
        output.putShort(this.averageFrameRate);
        ByteBufferExtensionsKt.put(output, BitOperationExtensionsKt.shl(this.constantFrameRate, 6) | BitOperationExtensionsKt.shl((byte)(this.numTemporalLayers & 7), 3) | BitOperationExtensionsKt.shl(this.temporalIdNested, 2) | this.lengthSizeMinusOne & 3);
        ByteBufferExtensionsKt.put(output, this.parameterSets.size());
        List vpsSets = new ArrayList();
        List spsSets = new ArrayList();
        List ppsSets = new ArrayList();
        List prefixSeiSets = new ArrayList();
        List suffixSeiSets = new ArrayList();
        List otherSets = new ArrayList();
        Iterable $this$forEach$iv = this.parameterSets;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getType().ordinal()]) {
                case 1: {
                    vpsSets.add(it);
                    break;
                }
                case 2: {
                    spsSets.add(it);
                    break;
                }
                case 3: {
                    ppsSets.add(it);
                    break;
                }
                case 4: {
                    prefixSeiSets.add(it);
                    break;
                }
                case 5: {
                    suffixSeiSets.add(it);
                    break;
                }
                default: {
                    otherSets.add(it);
                }
            }
        }
        $this$forEach$iv = vpsSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
        $this$forEach$iv = spsSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
        $this$forEach$iv = ppsSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
        $this$forEach$iv = prefixSeiSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
        $this$forEach$iv = suffixSeiSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
        $this$forEach$iv = otherSets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (NalUnit)element$iv;
            boolean bl = false;
            it.write(output);
        }
    }

    private final int component1() {
        return this.configurationVersion;
    }

    private final byte component2() {
        return this.generalProfileSpace;
    }

    private final boolean component3() {
        return this.generalTierFlag;
    }

    private final HEVCProfile component4() {
        return this.generalProfileIdc;
    }

    private final int component5() {
        return this.generalProfileCompatibilityFlags;
    }

    private final long component6() {
        return this.generalConstraintIndicatorFlags;
    }

    private final byte component7() {
        return this.generalLevelIdc;
    }

    private final int component8() {
        return this.minSpatialSegmentationIdc;
    }

    private final byte component9() {
        return this.parallelismType;
    }

    private final ChromaFormat component10() {
        return this.chromaFormat;
    }

    private final byte component11() {
        return this.bitDepthLumaMinus8;
    }

    private final byte component12() {
        return this.bitDepthChromaMinus8;
    }

    private final short component13() {
        return this.averageFrameRate;
    }

    private final byte component14() {
        return this.constantFrameRate;
    }

    private final byte component15() {
        return this.numTemporalLayers;
    }

    private final boolean component16() {
        return this.temporalIdNested;
    }

    private final byte component17() {
        return this.lengthSizeMinusOne;
    }

    private final List<NalUnit> component18() {
        return this.parameterSets;
    }

    @NotNull
    public final HEVCDecoderConfigurationRecord copy(int configurationVersion, byte generalProfileSpace, boolean generalTierFlag, @NotNull HEVCProfile generalProfileIdc, int generalProfileCompatibilityFlags, long generalConstraintIndicatorFlags, byte generalLevelIdc, int minSpatialSegmentationIdc, byte parallelismType, @NotNull ChromaFormat chromaFormat, byte bitDepthLumaMinus8, byte bitDepthChromaMinus8, short averageFrameRate, byte constantFrameRate, byte numTemporalLayers, boolean temporalIdNested, byte lengthSizeMinusOne, @NotNull List<NalUnit> parameterSets) {
        Intrinsics.checkNotNullParameter((Object)((Object)generalProfileIdc), (String)"generalProfileIdc");
        Intrinsics.checkNotNullParameter((Object)((Object)chromaFormat), (String)"chromaFormat");
        Intrinsics.checkNotNullParameter(parameterSets, (String)"parameterSets");
        return new HEVCDecoderConfigurationRecord(configurationVersion, generalProfileSpace, generalTierFlag, generalProfileIdc, generalProfileCompatibilityFlags, generalConstraintIndicatorFlags, generalLevelIdc, minSpatialSegmentationIdc, parallelismType, chromaFormat, bitDepthLumaMinus8, bitDepthChromaMinus8, averageFrameRate, constantFrameRate, numTemporalLayers, temporalIdNested, lengthSizeMinusOne, parameterSets);
    }

    public static /* synthetic */ HEVCDecoderConfigurationRecord copy$default(HEVCDecoderConfigurationRecord hEVCDecoderConfigurationRecord, int n, byte by, boolean bl, HEVCProfile hEVCProfile, int n2, long l, byte by2, int n3, byte by3, ChromaFormat chromaFormat, byte by4, byte by5, short s, byte by6, byte by7, boolean bl2, byte by8, List list, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = hEVCDecoderConfigurationRecord.configurationVersion;
        }
        if ((n4 & 2) != 0) {
            by = hEVCDecoderConfigurationRecord.generalProfileSpace;
        }
        if ((n4 & 4) != 0) {
            bl = hEVCDecoderConfigurationRecord.generalTierFlag;
        }
        if ((n4 & 8) != 0) {
            hEVCProfile = hEVCDecoderConfigurationRecord.generalProfileIdc;
        }
        if ((n4 & 0x10) != 0) {
            n2 = hEVCDecoderConfigurationRecord.generalProfileCompatibilityFlags;
        }
        if ((n4 & 0x20) != 0) {
            l = hEVCDecoderConfigurationRecord.generalConstraintIndicatorFlags;
        }
        if ((n4 & 0x40) != 0) {
            by2 = hEVCDecoderConfigurationRecord.generalLevelIdc;
        }
        if ((n4 & 0x80) != 0) {
            n3 = hEVCDecoderConfigurationRecord.minSpatialSegmentationIdc;
        }
        if ((n4 & 0x100) != 0) {
            by3 = hEVCDecoderConfigurationRecord.parallelismType;
        }
        if ((n4 & 0x200) != 0) {
            chromaFormat = hEVCDecoderConfigurationRecord.chromaFormat;
        }
        if ((n4 & 0x400) != 0) {
            by4 = hEVCDecoderConfigurationRecord.bitDepthLumaMinus8;
        }
        if ((n4 & 0x800) != 0) {
            by5 = hEVCDecoderConfigurationRecord.bitDepthChromaMinus8;
        }
        if ((n4 & 0x1000) != 0) {
            s = hEVCDecoderConfigurationRecord.averageFrameRate;
        }
        if ((n4 & 0x2000) != 0) {
            by6 = hEVCDecoderConfigurationRecord.constantFrameRate;
        }
        if ((n4 & 0x4000) != 0) {
            by7 = hEVCDecoderConfigurationRecord.numTemporalLayers;
        }
        if ((n4 & 0x8000) != 0) {
            bl2 = hEVCDecoderConfigurationRecord.temporalIdNested;
        }
        if ((n4 & 0x10000) != 0) {
            by8 = hEVCDecoderConfigurationRecord.lengthSizeMinusOne;
        }
        if ((n4 & 0x20000) != 0) {
            list = hEVCDecoderConfigurationRecord.parameterSets;
        }
        return hEVCDecoderConfigurationRecord.copy(n, by, bl, hEVCProfile, n2, l, by2, n3, by3, chromaFormat, by4, by5, s, by6, by7, bl2, by8, list);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("HEVCDecoderConfigurationRecord(configurationVersion=").append(this.configurationVersion).append(", generalProfileSpace=").append(this.generalProfileSpace).append(", generalTierFlag=").append(this.generalTierFlag).append(", generalProfileIdc=").append((Object)this.generalProfileIdc).append(", generalProfileCompatibilityFlags=").append(this.generalProfileCompatibilityFlags).append(", generalConstraintIndicatorFlags=").append(this.generalConstraintIndicatorFlags).append(", generalLevelIdc=").append(this.generalLevelIdc).append(", minSpatialSegmentationIdc=").append(this.minSpatialSegmentationIdc).append(", parallelismType=").append(this.parallelismType).append(", chromaFormat=").append((Object)this.chromaFormat).append(", bitDepthLumaMinus8=").append(this.bitDepthLumaMinus8).append(", bitDepthChromaMinus8=");
        stringBuilder.append(this.bitDepthChromaMinus8).append(", averageFrameRate=").append(this.averageFrameRate).append(", constantFrameRate=").append(this.constantFrameRate).append(", numTemporalLayers=").append(this.numTemporalLayers).append(", temporalIdNested=").append(this.temporalIdNested).append(", lengthSizeMinusOne=").append(this.lengthSizeMinusOne).append(", parameterSets=").append(this.parameterSets).append(')');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int result = Integer.hashCode(this.configurationVersion);
        result = result * 31 + Byte.hashCode(this.generalProfileSpace);
        result = result * 31 + Boolean.hashCode(this.generalTierFlag);
        result = result * 31 + this.generalProfileIdc.hashCode();
        result = result * 31 + Integer.hashCode(this.generalProfileCompatibilityFlags);
        result = result * 31 + Long.hashCode(this.generalConstraintIndicatorFlags);
        result = result * 31 + Byte.hashCode(this.generalLevelIdc);
        result = result * 31 + Integer.hashCode(this.minSpatialSegmentationIdc);
        result = result * 31 + Byte.hashCode(this.parallelismType);
        result = result * 31 + this.chromaFormat.hashCode();
        result = result * 31 + Byte.hashCode(this.bitDepthLumaMinus8);
        result = result * 31 + Byte.hashCode(this.bitDepthChromaMinus8);
        result = result * 31 + Short.hashCode(this.averageFrameRate);
        result = result * 31 + Byte.hashCode(this.constantFrameRate);
        result = result * 31 + Byte.hashCode(this.numTemporalLayers);
        result = result * 31 + Boolean.hashCode(this.temporalIdNested);
        result = result * 31 + Byte.hashCode(this.lengthSizeMinusOne);
        result = result * 31 + ((Object)this.parameterSets).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HEVCDecoderConfigurationRecord)) {
            return false;
        }
        HEVCDecoderConfigurationRecord hEVCDecoderConfigurationRecord = (HEVCDecoderConfigurationRecord)other;
        if (this.configurationVersion != hEVCDecoderConfigurationRecord.configurationVersion) {
            return false;
        }
        if (this.generalProfileSpace != hEVCDecoderConfigurationRecord.generalProfileSpace) {
            return false;
        }
        if (this.generalTierFlag != hEVCDecoderConfigurationRecord.generalTierFlag) {
            return false;
        }
        if (this.generalProfileIdc != hEVCDecoderConfigurationRecord.generalProfileIdc) {
            return false;
        }
        if (this.generalProfileCompatibilityFlags != hEVCDecoderConfigurationRecord.generalProfileCompatibilityFlags) {
            return false;
        }
        if (this.generalConstraintIndicatorFlags != hEVCDecoderConfigurationRecord.generalConstraintIndicatorFlags) {
            return false;
        }
        if (this.generalLevelIdc != hEVCDecoderConfigurationRecord.generalLevelIdc) {
            return false;
        }
        if (this.minSpatialSegmentationIdc != hEVCDecoderConfigurationRecord.minSpatialSegmentationIdc) {
            return false;
        }
        if (this.parallelismType != hEVCDecoderConfigurationRecord.parallelismType) {
            return false;
        }
        if (this.chromaFormat != hEVCDecoderConfigurationRecord.chromaFormat) {
            return false;
        }
        if (this.bitDepthLumaMinus8 != hEVCDecoderConfigurationRecord.bitDepthLumaMinus8) {
            return false;
        }
        if (this.bitDepthChromaMinus8 != hEVCDecoderConfigurationRecord.bitDepthChromaMinus8) {
            return false;
        }
        if (this.averageFrameRate != hEVCDecoderConfigurationRecord.averageFrameRate) {
            return false;
        }
        if (this.constantFrameRate != hEVCDecoderConfigurationRecord.constantFrameRate) {
            return false;
        }
        if (this.numTemporalLayers != hEVCDecoderConfigurationRecord.numTemporalLayers) {
            return false;
        }
        if (this.temporalIdNested != hEVCDecoderConfigurationRecord.temporalIdNested) {
            return false;
        }
        if (this.lengthSizeMinusOne != hEVCDecoderConfigurationRecord.lengthSizeMinusOne) {
            return false;
        }
        return Intrinsics.areEqual(this.parameterSets, hEVCDecoderConfigurationRecord.parameterSets);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rJ0\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\rJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tJ\u0014\u0010\u000e\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000f0\rJ0\u0010\u000e\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\r2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$Companion;", "", "()V", "HEVC_DECODER_CONFIGURATION_RECORD_SIZE", "", "HEVC_PARAMETER_SET_HEADER_SIZE", "fromParameterSets", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord;", "sps", "Ljava/nio/ByteBuffer;", "pps", "vps", "parameterSets", "", "getSize", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit;", "core_release"})
    @SourceDebugExtension(value={"SMAP\nHEVCDecoderConfigurationRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n1549#2:223\n1620#2,3:224\n223#2,2:227\n1855#2,2:229\n1855#2,2:231\n1855#2,2:233\n1855#2,2:235\n*S KotlinDebug\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$Companion\n*L\n129#1:223\n129#1:224,3\n136#1:227,2\n172#1:229,2\n175#1:231,2\n178#1:233,2\n188#1:235,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HEVCDecoderConfigurationRecord fromParameterSets(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @NotNull ByteBuffer vps) {
            Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
            Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
            return this.fromParameterSets(CollectionsKt.listOf((Object)sps), CollectionsKt.listOf((Object)pps), CollectionsKt.listOf((Object)vps));
        }

        @NotNull
        public final HEVCDecoderConfigurationRecord fromParameterSets(@NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps, @NotNull List<? extends ByteBuffer> vps) {
            Intrinsics.checkNotNullParameter(sps, (String)"sps");
            Intrinsics.checkNotNullParameter(pps, (String)"pps");
            Intrinsics.checkNotNullParameter(vps, (String)"vps");
            return this.fromParameterSets(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)sps, (Iterable)pps), (Iterable)vps));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final HEVCDecoderConfigurationRecord fromParameterSets(@NotNull List<? extends ByteBuffer> parameterSets) {
            Object element$iv2;
            List nalUnitParameterSets;
            block2: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(parameterSets, (String)"parameterSets");
                Iterable $this$map$iv = parameterSets;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ByteBuffer byteBuffer = (ByteBuffer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    byte nalType = (byte)(BitOperationExtensionsKt.shr(it.get(ByteBufferExtensionsKt.getStartCodeSize((ByteBuffer)it)), 1) & 0x3F);
                    NalUnit.Type type = NalUnit.Type.Companion.fromValue(nalType);
                    collection.add(new NalUnit(type, (ByteBuffer)it, false, 4, null));
                }
                nalUnitParameterSets = (List)destination$iv$iv;
                Iterable $this$first$iv = nalUnitParameterSets;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    NalUnit it = (NalUnit)element$iv2;
                    boolean bl = false;
                    if (!(it.getType() == NalUnit.Type.SPS)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ByteBuffer noStartCodeSps = ((NalUnit)element$iv2).getNoStartCodeData();
            SequenceParameterSets parsedSps = SequenceParameterSets.Companion.parse(noStartCodeSps);
            noStartCodeSps.rewind();
            return new HEVCDecoderConfigurationRecord(0, parsedSps.getProfileTierLevel().getGeneralProfileSpace(), parsedSps.getProfileTierLevel().getGeneralTierFlag(), parsedSps.getProfileTierLevel().getGeneralProfileIdc(), parsedSps.getProfileTierLevel().getGeneralProfileCompatibilityFlags(), parsedSps.getProfileTierLevel().getGeneralConstraintIndicatorFlags(), parsedSps.getProfileTierLevel().getGeneralLevelIdc(), 0, 0, parsedSps.getChromaFormat(), parsedSps.getBitDepthLumaMinus8(), parsedSps.getBitDepthChromaMinus8(), 0, 0, 0, false, 0, nalUnitParameterSets, 127361, null);
        }

        public final int getSize(@NotNull ByteBuffer sps, @NotNull ByteBuffer pps, @NotNull ByteBuffer vps) {
            Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
            Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
            Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
            return this.getSize(CollectionsKt.listOf((Object)sps), CollectionsKt.listOf((Object)pps), CollectionsKt.listOf((Object)vps));
        }

        public final int getSize(@NotNull List<? extends ByteBuffer> sps, @NotNull List<? extends ByteBuffer> pps, @NotNull List<? extends ByteBuffer> vps) {
            ByteBuffer it;
            Intrinsics.checkNotNullParameter(sps, (String)"sps");
            Intrinsics.checkNotNullParameter(pps, (String)"pps");
            Intrinsics.checkNotNullParameter(vps, (String)"vps");
            int size2 = 0;
            size2 = 23;
            Iterable $this$forEach$iv = sps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ByteBuffer)element$iv;
                boolean bl = false;
                size2 += it.remaining() - ByteBufferExtensionsKt.getStartCodeSize(it) + 5;
            }
            $this$forEach$iv = pps;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ByteBuffer)element$iv;
                boolean bl = false;
                size2 += it.remaining() - ByteBufferExtensionsKt.getStartCodeSize(it) + 5;
            }
            $this$forEach$iv = vps;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ByteBuffer)element$iv;
                boolean bl = false;
                size2 += it.remaining() - ByteBufferExtensionsKt.getStartCodeSize(it) + 5;
            }
            return size2;
        }

        public final int getSize(@NotNull List<NalUnit> parameterSets) {
            Intrinsics.checkNotNullParameter(parameterSets, (String)"parameterSets");
            int size2 = 0;
            size2 = 23;
            Iterable $this$forEach$iv = parameterSets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                NalUnit it = (NalUnit)element$iv;
                boolean bl = false;
                size2 += it.getNoStartCodeData().remaining() + 5;
            }
            return size2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001eB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit;", "", "type", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type;", "data", "Ljava/nio/ByteBuffer;", "completeness", "", "(Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type;Ljava/nio/ByteBuffer;Z)V", "getCompleteness", "()Z", "getData", "()Ljava/nio/ByteBuffer;", "noStartCodeData", "getNoStartCodeData", "getType", "()Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "write", "", "buffer", "Type", "core_release"})
    public static final class NalUnit {
        @NotNull
        private final Type type;
        @NotNull
        private final ByteBuffer data;
        private final boolean completeness;
        @NotNull
        private final ByteBuffer noStartCodeData;

        public NalUnit(@NotNull Type type, @NotNull ByteBuffer data, boolean completeness) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.type = type;
            this.data = data;
            this.completeness = completeness;
            this.noStartCodeData = ByteBufferExtensionsKt.removeStartCode(this.data);
        }

        public /* synthetic */ NalUnit(Type type, ByteBuffer byteBuffer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(type, byteBuffer, bl);
        }

        @NotNull
        public final Type getType() {
            return this.type;
        }

        @NotNull
        public final ByteBuffer getData() {
            return this.data;
        }

        public final boolean getCompleteness() {
            return this.completeness;
        }

        @NotNull
        public final ByteBuffer getNoStartCodeData() {
            return this.noStartCodeData;
        }

        public final void write(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            ByteBufferExtensionsKt.put(buffer, BitOperationExtensionsKt.shl(this.completeness, 7) | this.type.getValue());
            buffer.putShort((short)1);
            buffer.putShort((short)this.noStartCodeData.remaining());
            buffer.put(this.noStartCodeData);
        }

        @NotNull
        public final Type component1() {
            return this.type;
        }

        @NotNull
        public final ByteBuffer component2() {
            return this.data;
        }

        public final boolean component3() {
            return this.completeness;
        }

        @NotNull
        public final NalUnit copy(@NotNull Type type, @NotNull ByteBuffer data, boolean completeness) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new NalUnit(type, data, completeness);
        }

        public static /* synthetic */ NalUnit copy$default(NalUnit nalUnit, Type type, ByteBuffer byteBuffer, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                type = nalUnit.type;
            }
            if ((n & 2) != 0) {
                byteBuffer = nalUnit.data;
            }
            if ((n & 4) != 0) {
                bl = nalUnit.completeness;
            }
            return nalUnit.copy(type, byteBuffer, bl);
        }

        @NotNull
        public String toString() {
            return "NalUnit(type=" + (Object)((Object)this.type) + ", data=" + this.data + ", completeness=" + this.completeness + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.data.hashCode();
            result = result * 31 + Boolean.hashCode(this.completeness);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NalUnit)) {
                return false;
            }
            NalUnit nalUnit = (NalUnit)other;
            if (this.type != nalUnit.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.data, (Object)nalUnit.data)) {
                return false;
            }
            return this.completeness == nalUnit.completeness;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type;", "", "value", "", "(Ljava/lang/String;IB)V", "getValue", "()B", "VPS", "SPS", "PPS", "AUD", "EOS", "EOB", "FD", "PREFIX_SEI", "SUFFIX_SEI", "Companion", "core_release"})
        public static final class Type
        extends Enum<Type> {
            @NotNull
            public static final Companion Companion;
            private final byte value;
            public static final /* enum */ Type VPS;
            public static final /* enum */ Type SPS;
            public static final /* enum */ Type PPS;
            public static final /* enum */ Type AUD;
            public static final /* enum */ Type EOS;
            public static final /* enum */ Type EOB;
            public static final /* enum */ Type FD;
            public static final /* enum */ Type PREFIX_SEI;
            public static final /* enum */ Type SUFFIX_SEI;
            private static final /* synthetic */ Type[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Type(byte value) {
                this.value = value;
            }

            public final byte getValue() {
                return this.value;
            }

            public static Type[] values() {
                return (Type[])$VALUES.clone();
            }

            public static Type valueOf(String value) {
                return Enum.valueOf(Type.class, value);
            }

            @NotNull
            public static EnumEntries<Type> getEntries() {
                return $ENTRIES;
            }

            static {
                VPS = new Type(32);
                SPS = new Type(33);
                PPS = new Type(34);
                AUD = new Type(35);
                EOS = new Type(36);
                EOB = new Type(37);
                FD = new Type(38);
                PREFIX_SEI = new Type(39);
                SUFFIX_SEI = new Type(40);
                $VALUES = typeArray = new Type[]{Type.VPS, Type.SPS, Type.PPS, Type.AUD, Type.EOS, Type.EOB, Type.FD, Type.PREFIX_SEI, Type.SUFFIX_SEI};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type$Companion;", "", "()V", "fromValue", "Lio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type;", "value", "", "core_release"})
            @SourceDebugExtension(value={"SMAP\nHEVCDecoderConfigurationRecord.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n223#2,2:223\n*S KotlinDebug\n*F\n+ 1 HEVCDecoderConfigurationRecord.kt\nio/github/thibaultbee/streampack/internal/utils/av/video/hevc/HEVCDecoderConfigurationRecord$NalUnit$Type$Companion\n*L\n217#1:223,2\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Type fromValue(byte value) {
                    Object element$iv2;
                    block1: {
                        Iterable $this$first$iv = (Iterable)Type.getEntries();
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            Type it = (Type)((Object)element$iv2);
                            boolean bl = false;
                            if (!(it.getValue() == value)) continue;
                            break block1;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    return (Type)((Object)element$iv2);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NalUnit.Type.values().length];
            try {
                nArray[NalUnit.Type.VPS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NalUnit.Type.SPS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NalUnit.Type.PPS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NalUnit.Type.PREFIX_SEI.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NalUnit.Type.SUFFIX_SEI.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

