/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4.boxes;

import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FullBox;
import io.github.thibaultbee.streampack.internal.utils.av.buffer.ByteBufferWriter;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentRandomAccessBox;", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/FullBox;", "id", "", "entries", "", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentRandomAccessBox$Entry;", "(ILjava/util/List;)V", "size", "getSize", "()I", "write", "", "output", "Ljava/nio/ByteBuffer;", "Entry", "core_release"})
@SourceDebugExtension(value={"SMAP\nTrackFragmentRandomAccessBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrackFragmentRandomAccessBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentRandomAccessBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1855#2:74\n1856#2:76\n1855#2,2:77\n1#3:75\n*S KotlinDebug\n*F\n+ 1 TrackFragmentRandomAccessBox.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentRandomAccessBox\n*L\n32#1:74\n32#1:76\n44#1:77,2\n*E\n"})
public final class TrackFragmentRandomAccessBox
extends FullBox {
    private final int id;
    @NotNull
    private final List<Entry> entries;
    private final int size;

    public TrackFragmentRandomAccessBox(int id, @NotNull List<Entry> entries) {
        byte by;
        Number number;
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Entry entry = (Entry)CollectionsKt.firstOrNull(entries);
        Number number2 = number = entry != null ? entry.getTime() : null;
        if (number instanceof Integer) {
            by = 0;
        } else if (number instanceof Long) {
            by = 1;
        } else {
            throw new IllegalArgumentException("time and moofOffset must be both Int or Long");
        }
        super("tfra", by, 0, false, 8, null);
        this.id = id;
        this.entries = entries;
        this.size = super.getSize() + 12 + this.entries.size() * 19;
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            if (it.getMoofOffset() instanceof Integer && it.getTime() instanceof Integer || it.getMoofOffset() instanceof Long && it.getTime() instanceof Long) continue;
            boolean bl2 = false;
            String string2 = "time and moofOffset must be both Int or Long";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void write(@NotNull ByteBuffer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        super.write(output);
        output.putInt(this.id);
        output.putInt(0);
        output.putInt(this.entries.size());
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl = false;
            it.write(output);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c2\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\rH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/boxes/TrackFragmentRandomAccessBox$Entry;", "Lio/github/thibaultbee/streampack/internal/utils/av/buffer/ByteBufferWriter;", "time", "", "moofOffset", "trafNumber", "", "trunNumber", "sampleNumber", "(Ljava/lang/Number;Ljava/lang/Number;BBB)V", "getMoofOffset", "()Ljava/lang/Number;", "size", "", "getSize", "()I", "getTime", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write", "", "output", "Ljava/nio/ByteBuffer;", "core_release"})
    public static final class Entry
    extends ByteBufferWriter {
        @NotNull
        private final Number time;
        @NotNull
        private final Number moofOffset;
        private final byte trafNumber;
        private final byte trunNumber;
        private final byte sampleNumber;
        private final int size;

        public Entry(@NotNull Number time, @NotNull Number moofOffset, byte trafNumber, byte trunNumber, byte sampleNumber) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)moofOffset, (String)"moofOffset");
            this.time = time;
            this.moofOffset = moofOffset;
            this.trafNumber = trafNumber;
            this.trunNumber = trunNumber;
            this.sampleNumber = sampleNumber;
            this.size = 19;
        }

        public /* synthetic */ Entry(Number number, Number number2, byte by, byte by2, byte by3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                by = 1;
            }
            if ((n & 8) != 0) {
                by2 = 1;
            }
            if ((n & 0x10) != 0) {
                by3 = 1;
            }
            this(number, number2, by, by2, by3);
        }

        @NotNull
        public final Number getTime() {
            return this.time;
        }

        @NotNull
        public final Number getMoofOffset() {
            return this.moofOffset;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public void write(@NotNull ByteBuffer output) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            if (this.time instanceof Long && this.moofOffset instanceof Long) {
                output.putLong(this.time.longValue());
                output.putLong(this.moofOffset.longValue());
            } else if (this.time instanceof Integer && this.moofOffset instanceof Integer) {
                output.putInt(this.time.intValue());
                output.putInt(this.moofOffset.intValue());
            } else {
                throw new IllegalArgumentException("time and moofOffset must be both Int or Long");
            }
            output.put(this.trafNumber);
            output.put(this.trunNumber);
            output.put(this.sampleNumber);
        }

        @NotNull
        public final Number component1() {
            return this.time;
        }

        @NotNull
        public final Number component2() {
            return this.moofOffset;
        }

        private final byte component3() {
            return this.trafNumber;
        }

        private final byte component4() {
            return this.trunNumber;
        }

        private final byte component5() {
            return this.sampleNumber;
        }

        @NotNull
        public final Entry copy(@NotNull Number time, @NotNull Number moofOffset, byte trafNumber, byte trunNumber, byte sampleNumber) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            Intrinsics.checkNotNullParameter((Object)moofOffset, (String)"moofOffset");
            return new Entry(time, moofOffset, trafNumber, trunNumber, sampleNumber);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Number number, Number number2, byte by, byte by2, byte by3, int n, Object object) {
            if ((n & 1) != 0) {
                number = entry.time;
            }
            if ((n & 2) != 0) {
                number2 = entry.moofOffset;
            }
            if ((n & 4) != 0) {
                by = entry.trafNumber;
            }
            if ((n & 8) != 0) {
                by2 = entry.trunNumber;
            }
            if ((n & 0x10) != 0) {
                by3 = entry.sampleNumber;
            }
            return entry.copy(number, number2, by, by2, by3);
        }

        @NotNull
        public String toString() {
            return "Entry(time=" + this.time + ", moofOffset=" + this.moofOffset + ", trafNumber=" + this.trafNumber + ", trunNumber=" + this.trunNumber + ", sampleNumber=" + this.sampleNumber + ')';
        }

        public int hashCode() {
            int result = this.time.hashCode();
            result = result * 31 + this.moofOffset.hashCode();
            result = result * 31 + Byte.hashCode(this.trafNumber);
            result = result * 31 + Byte.hashCode(this.trunNumber);
            result = result * 31 + Byte.hashCode(this.sampleNumber);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual((Object)this.time, (Object)entry.time)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.moofOffset, (Object)entry.moofOffset)) {
                return false;
            }
            if (this.trafNumber != entry.trafNumber) {
                return false;
            }
            if (this.trunNumber != entry.trunNumber) {
                return false;
            }
            return this.sampleNumber == entry.sampleNumber;
        }
    }
}

