/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.muxers.mp4;

import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.data.Packet;
import io.github.thibaultbee.streampack.internal.muxers.IMuxer;
import io.github.thibaultbee.streampack.internal.muxers.IMuxerListener;
import io.github.thibaultbee.streampack.internal.muxers.mp4.MP4MuxerHelper;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.FileTypeBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.MovieFragmentRandomAccessBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.boxes.TrackFragmentRandomAccessBox;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.AbstractMovieBoxFactory;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.DefaultMP4SegmenterFactory;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.MP4Segmenter;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.MP4SegmenterFactory;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.MovieBoxFactory;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.MovieFragmentBoxFactory;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.Segment;
import io.github.thibaultbee.streampack.internal.muxers.mp4.models.Track;
import io.github.thibaultbee.streampack.internal.orientation.ISourceOrientationProvider;
import io.github.thibaultbee.streampack.internal.utils.extensions.StringExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B%\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00050)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,H\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0005H\u0016J\b\u00105\u001a\u00020\u0005H\u0002J\b\u00106\u001a\u000201H\u0016J\b\u00107\u001a\u000201H\u0016J\b\u00108\u001a\u000201H\u0016J\u0010\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;H\u0002J\b\u0010<\u001a\u000201H\u0002J\u0012\u0010=\u001a\u0002012\b\b\u0002\u0010>\u001a\u00020\u000eH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/MP4Muxer;", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxer;", "initialListener", "Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "timescale", "", "segmenterFactory", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/MP4SegmenterFactory;", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;ILio/github/thibaultbee/streampack/internal/muxers/mp4/models/MP4SegmenterFactory;)V", "currentSegment", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Segment;", "dataOffset", "", "hasAudio", "", "getHasAudio", "()Z", "hasVideo", "getHasVideo", "helper", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/MP4MuxerHelper;", "getHelper", "()Lio/github/thibaultbee/streampack/internal/muxers/mp4/MP4MuxerHelper;", "listener", "getListener", "()Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;", "setListener", "(Lio/github/thibaultbee/streampack/internal/muxers/IMuxerListener;)V", "segmenter", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/MP4Segmenter;", "sequenceNumber", "sourceOrientationProvider", "Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "getSourceOrientationProvider", "()Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;", "setSourceOrientationProvider", "(Lio/github/thibaultbee/streampack/internal/orientation/ISourceOrientationProvider;)V", "tracks", "", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/Track;", "addStreams", "", "Lio/github/thibaultbee/streampack/data/Config;", "streamsConfig", "", "createNewSegment", "movieBoxFactory", "Lio/github/thibaultbee/streampack/internal/muxers/mp4/models/AbstractMovieBoxFactory;", "encode", "", "frame", "Lio/github/thibaultbee/streampack/internal/data/Frame;", "streamPid", "getNewId", "release", "startStream", "stopStream", "writeBuffer", "buffer", "Ljava/nio/ByteBuffer;", "writeMfraIfNeeded", "writeSegment", "createNewFragment", "Companion", "core_release"})
@SourceDebugExtension(value={"SMAP\nMP4Muxer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MP4Muxer.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/MP4Muxer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1747#2,3:182\n1747#2,3:185\n1855#2,2:188\n1855#2,2:190\n1549#2:192\n1620#2,3:193\n1855#2,2:196\n1855#2,2:198\n766#2:200\n857#2,2:201\n1549#2:203\n1620#2,2:204\n1549#2:206\n1620#2,3:207\n1622#2:210\n*S KotlinDebug\n*F\n+ 1 MP4Muxer.kt\nio/github/thibaultbee/streampack/internal/muxers/mp4/MP4Muxer\n*L\n51#1:182,3\n53#1:185,3\n72#1:188,2\n79#1:190,2\n103#1:192\n103#1:193,3\n104#1:196,2\n131#1:198,2\n148#1:200\n148#1:201,2\n150#1:203\n150#1:204,2\n153#1:206\n153#1:207,3\n150#1:210\n*E\n"})
public final class MP4Muxer
implements IMuxer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timescale;
    @NotNull
    private final MP4SegmenterFactory segmenterFactory;
    @NotNull
    private final MP4MuxerHelper helper;
    @Nullable
    private ISourceOrientationProvider sourceOrientationProvider;
    @Nullable
    private IMuxerListener listener;
    @NotNull
    private final List<Track> tracks;
    @Nullable
    private Segment currentSegment;
    @Nullable
    private MP4Segmenter segmenter;
    private long dataOffset;
    private int sequenceNumber;
    private static final int DEFAULT_SEQUENCE_NUMBER = 1;
    private static final int DEFAULT_TIMESCALE = 1000000;

    public MP4Muxer(@Nullable IMuxerListener initialListener, int timescale, @NotNull MP4SegmenterFactory segmenterFactory) {
        Intrinsics.checkNotNullParameter((Object)segmenterFactory, (String)"segmenterFactory");
        this.timescale = timescale;
        this.segmenterFactory = segmenterFactory;
        this.helper = new MP4MuxerHelper();
        this.listener = initialListener;
        this.tracks = new ArrayList();
        this.sequenceNumber = 1;
    }

    public /* synthetic */ MP4Muxer(IMuxerListener iMuxerListener, int n, MP4SegmenterFactory mP4SegmenterFactory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            iMuxerListener = null;
        }
        if ((n2 & 2) != 0) {
            n = 1000000;
        }
        if ((n2 & 4) != 0) {
            mP4SegmenterFactory = new DefaultMP4SegmenterFactory();
        }
        this(iMuxerListener, n, mP4SegmenterFactory);
    }

    @Override
    @NotNull
    public MP4MuxerHelper getHelper() {
        return this.helper;
    }

    @Override
    @Nullable
    public ISourceOrientationProvider getSourceOrientationProvider() {
        return this.sourceOrientationProvider;
    }

    @Override
    public void setSourceOrientationProvider(@Nullable ISourceOrientationProvider iSourceOrientationProvider) {
        this.sourceOrientationProvider = iSourceOrientationProvider;
    }

    @Override
    @Nullable
    public IMuxerListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(@Nullable IMuxerListener iMuxerListener) {
        this.listener = iMuxerListener;
    }

    private final boolean getHasAudio() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.tracks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Track it = (Track)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isAudio(it.getConfig().getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean getHasVideo() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.tracks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Track it = (Track)element$iv;
                    boolean bl2 = false;
                    if (!StringExtensionsKt.isVideo(it.getConfig().getMimeType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(@NotNull Frame frame, int streamPid) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        MP4Muxer mP4Muxer = this;
        synchronized (mP4Muxer) {
            boolean bl = false;
            MP4Segmenter mP4Segmenter = this.segmenter;
            Intrinsics.checkNotNull((Object)mP4Segmenter);
            if (mP4Segmenter.mustWriteSegment(frame)) {
                MP4Muxer.writeSegment$default(this, false, 1, null);
            }
            Segment segment = this.currentSegment;
            Intrinsics.checkNotNull((Object)segment);
            segment.add(frame, streamPid);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Map<Config, Integer> addStreams(@NotNull List<? extends Config> streamsConfig) {
        Intrinsics.checkNotNullParameter(streamsConfig, (String)"streamsConfig");
        List newTracks = new ArrayList();
        Iterable $this$forEach$iv = streamsConfig;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Config config = (Config)element$iv;
            boolean bl = false;
            Track track = new Track(this.getNewId(), config, this.timescale);
            newTracks.add(track);
            this.tracks.add(track);
        }
        Map streamMap = new LinkedHashMap();
        Iterable $this$forEach$iv2 = newTracks;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Track it = (Track)element$iv;
            boolean bl = false;
            streamMap.put(it.getConfig(), it.getId());
        }
        return streamMap;
    }

    @Override
    public void startStream() {
        this.writeBuffer(new FileTypeBox(null, 0, null, 7, null).toByteBuffer());
        this.currentSegment = this.createNewSegment(new MovieBoxFactory(this.timescale));
        this.segmenter = this.segmenterFactory.build(this.getHasAudio(), this.getHasVideo());
    }

    @Override
    public void stopStream() {
        this.writeSegment(false);
        this.writeMfraIfNeeded();
        this.sequenceNumber = 1;
        this.dataOffset = 0L;
        this.currentSegment = null;
        this.segmenter = null;
        this.tracks.clear();
    }

    @Override
    public void release() {
    }

    /*
     * WARNING - void declaration
     */
    private final int getNewId() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tracks;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Track track = (Track)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List currentIds = (List)destination$iv$iv;
        Iterable $this$forEach$iv = (Iterable)new IntRange(1, Integer.MAX_VALUE);
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)object).nextInt();
            boolean bl = false;
            if (currentIds.contains(it)) continue;
            return it;
        }
        throw new IndexOutOfBoundsException("No empty ID left");
    }

    private final Segment createNewSegment(AbstractMovieBoxFactory movieBoxFactory) {
        return new Segment(this.tracks, movieBoxFactory, (Function1<? super ByteBuffer, Unit>)((Function1)new Function1<ByteBuffer, Unit>(this){
            final /* synthetic */ MP4Muxer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ByteBuffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                MP4Muxer.access$writeBuffer(this.this$0, buffer);
            }
        }));
    }

    private final void writeSegment(boolean createNewFragment) {
        Segment segment = this.currentSegment;
        if (segment != null) {
            Segment it = segment;
            boolean bl = false;
            if (!it.getHasData()) {
                return;
            }
            it.write(this.dataOffset);
            if (it.isFragment()) {
                Iterable $this$forEach$iv = this.tracks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Track track = (Track)element$iv;
                    boolean bl2 = false;
                    track.getSyncSamples().add(new Track.SyncSample(it.getFirstTimestamp(track.getId()), this.dataOffset));
                }
            }
        }
        if (createNewFragment) {
            int n = this.sequenceNumber;
            this.sequenceNumber = n + 1;
            this.currentSegment = this.createNewSegment(new MovieFragmentBoxFactory(n));
        }
    }

    static /* synthetic */ void writeSegment$default(MP4Muxer mP4Muxer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        mP4Muxer.writeSegment(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeMfraIfNeeded() {
        void $this$mapTo$iv$iv;
        Track it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.tracks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Track)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !((Collection)it.getSyncSamples()).isEmpty();
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<TrackFragmentRandomAccessBox.Entry> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            it = (Track)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = it.getSyncSamples();
            int n = it.getId();
            boolean $i$f$map2 = false;
            void var14_13 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                Track.SyncSample syncSample = (Track.SyncSample)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(new TrackFragmentRandomAccessBox.Entry(it2.getTime(), it2.getMoofOffset(), 0, 0, 0, 28, null));
            }
            collection = (List)destination$iv$iv2;
            List list = collection;
            int n2 = n;
            collection2.add(new TrackFragmentRandomAccessBox(n2, list));
        }
        List tfras = (List)destination$iv$iv;
        if (tfras.isEmpty()) {
            return;
        }
        MovieFragmentRandomAccessBox mfra = new MovieFragmentRandomAccessBox(tfras);
        this.writeBuffer(mfra.toByteBuffer());
    }

    private final void writeBuffer(ByteBuffer buffer) {
        block0: {
            int size2 = buffer.remaining();
            Packet packet = new Packet(buffer, 0L, null, 4, null);
            IMuxerListener iMuxerListener = this.getListener();
            if (iMuxerListener == null) break block0;
            IMuxerListener it = iMuxerListener;
            boolean bl = false;
            it.onOutputFrame(packet);
            this.dataOffset += (long)size2;
        }
    }

    public MP4Muxer() {
        this(null, 0, null, 7, null);
    }

    public static final /* synthetic */ void access$writeBuffer(MP4Muxer $this, ByteBuffer buffer) {
        $this.writeBuffer(buffer);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/thibaultbee/streampack/internal/muxers/mp4/MP4Muxer$Companion;", "", "()V", "DEFAULT_SEQUENCE_NUMBER", "", "DEFAULT_TIMESCALE", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

