/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.encoders.IEncoder;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.events.EventHandler;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u0010\b&\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004:\u00015B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0002H\u0016J\u0018\u0010)\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0017H\u0002J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020#H\u0002J\u0018\u0010-\u001a\u00020.2\u0006\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\u0017H\u0016J\u0018\u0010/\u001a\u00020'2\u0006\u0010(\u001a\u00020\u00022\u0006\u00100\u001a\u00020.H\u0016J\u0010\u00101\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020'H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00066"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "T", "Lio/github/thibaultbee/streampack/data/Config;", "Lio/github/thibaultbee/streampack/internal/events/EventHandler;", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoder;", "encoderListener", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "(Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;)V", "_bitrate", "", "bitrate", "getBitrate", "()I", "callbackThread", "Landroid/os/HandlerThread;", "encoderCallback", "io/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder$encoderCallback$1", "Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder$encoderCallback$1;", "getEncoderListener", "()Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "handler", "Landroid/os/Handler;", "isOnError", "", "isStopped", "lock", "Ljava/lang/Object;", "value", "Landroid/media/MediaCodec;", "mediaCodec", "getMediaCodec", "()Landroid/media/MediaCodec;", "setMediaCodec", "(Landroid/media/MediaCodec;)V", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "configure", "", "config", "createCodec", "withProfileLevel", "createHandler", "name", "createMediaFormat", "Landroid/media/MediaFormat;", "extendMediaFormat", "format", "onNewMediaCodec", "release", "startStream", "stopStream", "Companion", "core_release"})
public abstract class MediaCodecEncoder<T extends Config>
extends EventHandler
implements IEncoder<Config> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IEncoderListener encoderListener;
    @Nullable
    private MediaCodec mediaCodec;
    @Nullable
    private HandlerThread callbackThread;
    @Nullable
    private Handler handler;
    @NotNull
    private final Object lock;
    private boolean isStopped;
    private boolean isOnError;
    private int _bitrate;
    @NotNull
    private final encoderCallback.1<T> encoderCallback;
    @NotNull
    private static final String TAG = "MediaCodecEncoder";

    public MediaCodecEncoder(@NotNull IEncoderListener encoderListener) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        this.encoderListener = encoderListener;
        this.lock = new Object();
        this.isStopped = true;
        this.encoderCallback = new MediaCodec.Callback(this){
            final /* synthetic */ MediaCodecEncoder<T> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOutputBufferAvailable(@NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    if (MediaCodecEncoder.access$isOnError$p(mediaCodecEncoder)) {
                        return;
                    }
                    try {
                        Unit unit;
                        Object object3 = mediaCodecEncoder.getMediaCodec();
                        if (object3 != null && (object3 = object3.getOutputBuffer(index)) != null) {
                            boolean isKeyFrame;
                            Object buffer = object3;
                            boolean bl2 = false;
                            MediaFormat mediaFormat = codec.getOutputFormat();
                            Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"getOutputFormat(...)");
                            MediaFormat format = mediaFormat;
                            boolean bl3 = isKeyFrame = info.flags == 1;
                            if (info.flags != 2) {
                                Intrinsics.checkNotNull((Object)buffer);
                                Frame frame = new Frame((ByteBuffer)buffer, info.presentationTimeUs, null, isKeyFrame, format);
                                boolean bl4 = false;
                                mediaCodecEncoder.getEncoderListener().onOutputFrame(frame);
                            }
                            MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                            if (mediaCodec != null) {
                                mediaCodec.releaseOutputBuffer(index, false);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                        } else {
                            unit = null;
                        }
                        if (unit == null) {
                            mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get output buffer")));
                        }
                    }
                    catch (IllegalStateException e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        ILogger.DefaultImpls.w$default(Logger.INSTANCE, "MediaCodecEncoder", "onOutputBufferAvailable called while stopped", null, 4, null);
                    }
                    catch (StreamPackError e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        mediaCodecEncoder.reportError(e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onInputBufferAvailable(@NotNull MediaCodec codec, int index) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    if (MediaCodecEncoder.access$isOnError$p(mediaCodecEncoder)) {
                        return;
                    }
                    try {
                        Unit unit;
                        Object object3 = mediaCodecEncoder.getMediaCodec();
                        if (object3 != null && (object3 = object3.getInputBuffer(index)) != null) {
                            Object buffer = object3;
                            boolean bl2 = false;
                            IEncoderListener iEncoderListener = mediaCodecEncoder.getEncoderListener();
                            Intrinsics.checkNotNull((Object)buffer);
                            Frame frame = iEncoderListener.onInputFrame((ByteBuffer)buffer);
                            boolean bl3 = false;
                            MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                            if (mediaCodec != null) {
                                mediaCodec.queueInputBuffer(index, 0, frame.getBuffer().remaining(), frame.getPts(), 0);
                                unit = Unit.INSTANCE;
                            } else {
                                unit = null;
                            }
                        } else {
                            unit = null;
                        }
                        if (unit == null) {
                            mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get input buffer")));
                        }
                    }
                    catch (IllegalStateException e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        ILogger.DefaultImpls.w$default(Logger.INSTANCE, "MediaCodecEncoder", "onInputBufferAvailable called while stopped", null, 4, null);
                    }
                    catch (StreamPackError e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        mediaCodecEncoder.reportError(e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            public void onOutputFormatChanged(@NotNull MediaCodec codec, @NotNull MediaFormat format) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, "MediaCodecEncoder", "Format changed : " + format, null, 4, null);
            }

            public void onError(@NotNull MediaCodec codec, @NotNull MediaCodec.CodecException e) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.reportError(new StreamPackError((Throwable)e));
            }
        };
    }

    @Override
    @NotNull
    public IEncoderListener getEncoderListener() {
        return this.encoderListener;
    }

    @Nullable
    protected final MediaCodec getMediaCodec() {
        return this.mediaCodec;
    }

    protected final void setMediaCodec(@Nullable MediaCodec value) {
        if (value != null) {
            this.onNewMediaCodec(value);
        }
        this.mediaCodec = value;
    }

    public int getBitrate() {
        return this._bitrate;
    }

    /*
     * WARNING - void declaration
     */
    private final void createHandler(String name) {
        Handler handler;
        this.callbackThread = new HandlerThread(name);
        MediaCodecEncoder mediaCodecEncoder = this;
        HandlerThread handlerThread = this.callbackThread;
        if (handlerThread != null) {
            void handlerThread2;
            HandlerThread handlerThread3 = handlerThread;
            MediaCodecEncoder mediaCodecEncoder2 = mediaCodecEncoder;
            boolean bl = false;
            handlerThread2.start();
            handler = new Handler(handlerThread2.getLooper());
            mediaCodecEncoder = mediaCodecEncoder2;
        } else {
            handler = null;
        }
        mediaCodecEncoder.handler = handler;
    }

    public void onNewMediaCodec(@NotNull MediaCodec mediaCodec) {
        Intrinsics.checkNotNullParameter((Object)mediaCodec, (String)"mediaCodec");
    }

    @NotNull
    public MediaFormat createMediaFormat(@NotNull Config config, boolean withProfileLevel) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config.getFormat$core_release(withProfileLevel);
    }

    public void extendMediaFormat(@NotNull Config config, @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
    }

    private final MediaCodec createCodec(Config config, boolean withProfileLevel) {
        MediaFormat format = this.createMediaFormat(config, withProfileLevel);
        String encoderName2 = MediaCodecHelper.INSTANCE.findEncoder(format);
        ILogger.DefaultImpls.i$default(Logger.INSTANCE, TAG, "Selected encoder " + encoderName2, null, 4, null);
        MediaCodec mediaCodec = MediaCodec.createByCodecName((String)encoderName2);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createByCodecName(...)");
        MediaCodec codec = mediaCodec;
        this.extendMediaFormat(config, format);
        if (Build.VERSION.SDK_INT >= 23) {
            this.createHandler(encoderName2 + ".thread");
            codec.setCallback((MediaCodec.Callback)this.encoderCallback, this.handler);
        } else {
            codec.setCallback((MediaCodec.Callback)this.encoderCallback);
        }
        try {
            codec.configure(format, null, null, 1);
        }
        catch (Exception e) {
            codec.release();
            throw e;
        }
        return codec;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configure(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this._bitrate = config.getStartBitrate();
        try {
            MediaCodec mediaCodec;
            MediaCodecEncoder mediaCodecEncoder;
            MediaCodecEncoder mediaCodecEncoder2 = this;
            try {
                mediaCodecEncoder = mediaCodecEncoder2;
                mediaCodec = this.createCodec(config, true);
            }
            catch (Exception exception) {
                void e;
                mediaCodecEncoder = mediaCodecEncoder2;
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, TAG, "Fallback without profile and level (reason: " + e + ')', null, 4, null);
                mediaCodec = this.createCodec(config, false);
            }
            mediaCodecEncoder.setMediaCodec(mediaCodec);
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, TAG, "Failed to create encoder for " + config, null, 4, null);
            throw e;
        }
    }

    @Override
    @Nullable
    public String getMimeType() {
        Object object = this.mediaCodec;
        if (object == null || (object = object.getOutputFormat()) == null || (object = object.getString("mime")) == null) {
            throw new IllegalStateException("Can't get MimeType without configuration");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStream() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            this.isOnError = false;
            this.isStopped = false;
            MediaCodec mediaCodec = this.mediaCodec;
            if (mediaCodec != null) {
                mediaCodec.start();
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit == null) {
                throw new IllegalStateException("Can't start without configuration");
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStream() {
        try {
            Object object = this.lock;
            synchronized (object) {
                Unit unit;
                boolean bl = false;
                this.isStopped = true;
                MediaCodec mediaCodec = this.mediaCodec;
                if (mediaCodec != null) {
                    mediaCodec.setCallback(null);
                }
                MediaCodec mediaCodec2 = this.mediaCodec;
                if (mediaCodec2 != null) {
                    mediaCodec2.signalEndOfInputStream();
                }
                MediaCodec mediaCodec3 = this.mediaCodec;
                if (mediaCodec3 != null) {
                    mediaCodec3.flush();
                }
                MediaCodec mediaCodec4 = this.mediaCodec;
                if (mediaCodec4 != null) {
                    mediaCodec4.stop();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                Unit unit2 = unit;
            }
        }
        catch (IllegalStateException e) {
            ILogger.DefaultImpls.d$default(Logger.INSTANCE, TAG, "Not running", null, 4, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        try {
            MediaCodec mediaCodec = this.mediaCodec;
            if (mediaCodec != null) {
                mediaCodec.release();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.setMediaCodec(null);
        }
    }

    public static final /* synthetic */ Object access$getLock$p(MediaCodecEncoder $this) {
        return $this.lock;
    }

    public static final /* synthetic */ boolean access$isStopped$p(MediaCodecEncoder $this) {
        return $this.isStopped;
    }

    public static final /* synthetic */ boolean access$isOnError$p(MediaCodecEncoder $this) {
        return $this.isOnError;
    }

    public static final /* synthetic */ void access$setOnError$p(MediaCodecEncoder $this, boolean bl) {
        $this.isOnError = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder$Companion;", "", "()V", "TAG", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

