/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.streamers;

import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.streamers.interfaces.ILiveStreamer;
import io.github.thibaultbee.streampack.streamers.interfaces.IStreamer;
import io.github.thibaultbee.streampack.utils.StreamerExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\r"}, d2={"Lio/github/thibaultbee/streampack/streamers/StreamerLifeCycleObserver;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "streamer", "Lio/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "(Lio/github/thibaultbee/streampack/streamers/interfaces/IStreamer;)V", "getStreamer", "()Lio/github/thibaultbee/streampack/streamers/interfaces/IStreamer;", "setStreamer", "onDestroy", "", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onPause", "core_release"})
public class StreamerLifeCycleObserver
implements DefaultLifecycleObserver {
    @NotNull
    private IStreamer streamer;

    public StreamerLifeCycleObserver(@NotNull IStreamer streamer) {
        Intrinsics.checkNotNullParameter((Object)streamer, (String)"streamer");
        this.streamer = streamer;
    }

    @NotNull
    public final IStreamer getStreamer() {
        return this.streamer;
    }

    public final void setStreamer(@NotNull IStreamer iStreamer) {
        Intrinsics.checkNotNullParameter((Object)iStreamer, (String)"<set-?>");
        this.streamer = iStreamer;
    }

    public void onPause(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        ICameraStreamer iCameraStreamer = StreamerExtensionsKt.getCameraStreamer(this.streamer);
        if (iCameraStreamer != null) {
            iCameraStreamer.stopPreview();
        }
        this.streamer.stopStream();
        ILiveStreamer iLiveStreamer = StreamerExtensionsKt.getLiveStreamer(this.streamer);
        if (iLiveStreamer != null) {
            ILiveStreamer it = iLiveStreamer;
            boolean bl = false;
            if (it.isConnected()) {
                it.disconnect();
            }
        }
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.streamer.release();
    }
}

