/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.utils;

import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.MeteringRectangle;
import io.github.thibaultbee.streampack.internal.sources.camera.CameraController;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R$\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR0\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lio/github/thibaultbee/streampack/utils/WhiteBalance;", "", "context", "Landroid/content/Context;", "cameraController", "Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;", "(Landroid/content/Context;Lio/github/thibaultbee/streampack/internal/sources/camera/CameraController;)V", "value", "", "autoMode", "getAutoMode", "()I", "setAutoMode", "(I)V", "availableAutoModes", "", "getAvailableAutoModes", "()Ljava/util/List;", "maxNumOfMeteringRegions", "getMaxNumOfMeteringRegions", "Landroid/hardware/camera2/params/MeteringRectangle;", "meteringRegions", "getMeteringRegions", "setMeteringRegions", "(Ljava/util/List;)V", "core_release"})
public final class WhiteBalance {
    @NotNull
    private final Context context;
    @NotNull
    private final CameraController cameraController;

    public WhiteBalance(@NotNull Context context, @NotNull CameraController cameraController) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cameraController, (String)"cameraController");
        this.context = context;
        this.cameraController = cameraController;
    }

    @NotNull
    public final List<Integer> getAvailableAutoModes() {
        List<Integer> list;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            list = null;
        } else {
            String it = string2;
            boolean bl = false;
            list = CameraExtensionsKt.getAutoWhiteBalanceModes(this.context, it);
        }
        List<Integer> list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    public final int getAutoMode() {
        Integer n = (Integer)this.cameraController.getSetting(CaptureRequest.CONTROL_AWB_MODE);
        return n == null ? 0 : n;
    }

    public final void setAutoMode(int value) {
        CaptureRequest.Key key = CaptureRequest.CONTROL_AWB_MODE;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_MODE");
        this.cameraController.setRepeatingSetting(key, value);
    }

    public final int getMaxNumOfMeteringRegions() {
        int n;
        String string2 = this.cameraController.getCameraId();
        if (string2 == null) {
            n = 0;
        } else {
            int n2;
            String it = string2;
            boolean bl = false;
            n = n2 = CameraExtensionsKt.getWhiteBalanceMeteringRegionsSupported(this.context, it);
        }
        return n;
    }

    @NotNull
    public final List<MeteringRectangle> getMeteringRegions() {
        Object[] objectArray = (MeteringRectangle[])this.cameraController.getSetting(CaptureRequest.CONTROL_AWB_REGIONS);
        List list = objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        return list == null ? CollectionsKt.emptyList() : list;
    }

    public final void setMeteringRegions(@NotNull List<MeteringRectangle> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        CaptureRequest.Key key = CaptureRequest.CONTROL_AWB_REGIONS;
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CONTROL_AWB_REGIONS");
        Collection $this$toTypedArray$iv = value;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MeteringRectangle[] meteringRectangleArray = thisCollection$iv.toArray(new MeteringRectangle[0]);
        if (meteringRectangleArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        this.cameraController.setRepeatingSetting(key, meteringRectangleArray);
    }
}

