/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import io.github.thibaultbee.streampack.data.Config;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.internal.data.Frame;
import io.github.thibaultbee.streampack.internal.encoders.IEncoder;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecHelper;
import io.github.thibaultbee.streampack.internal.events.EventHandler;
import io.github.thibaultbee.streampack.internal.utils.ByteBufferExtensionsKt;
import io.github.thibaultbee.streampack.internal.utils.StringExtensionsKt;
import io.github.thibaultbee.streampack.logger.ILogger;
import io.github.thibaultbee.streampack.logger.Logger;
import io.github.thibaultbee.streampack.utils.ExtensionsKt;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0013\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u00020\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0002H\u0016J\u0018\u0010+\u001a\u00020\u001e2\u0006\u0010*\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020%H\u0002J\u0018\u0010/\u001a\u0002002\u0006\u0010*\u001a\u00020\u00022\u0006\u0010,\u001a\u00020\u001aH\u0016J\u0018\u00101\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00022\u0006\u00102\u001a\u000200H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u000205042\u0006\u00102\u001a\u000200H\u0002J\b\u00106\u001a\u00020)H\u0016J\b\u00107\u001a\u00020)H\u0016J\b\u00108\u001a\u00020)H\u0016J\b\u00109\u001a\u00020)H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\b\u0010\n\u001a\u0004\u0018\u00010\u001e@DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006:"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "T", "Lio/github/thibaultbee/streampack/data/Config;", "Lio/github/thibaultbee/streampack/internal/events/EventHandler;", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoder;", "encoderListener", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "(Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;)V", "_bitrate", "", "value", "bitrate", "getBitrate", "()I", "setBitrate", "(I)V", "callbackThread", "Landroid/os/HandlerThread;", "encoderCallback", "io/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder$encoderCallback$1", "Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder$encoderCallback$1;", "getEncoderListener", "()Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "handler", "Landroid/os/Handler;", "isOnError", "", "isStopped", "lock", "Ljava/lang/Object;", "Landroid/media/MediaCodec;", "mediaCodec", "getMediaCodec", "()Landroid/media/MediaCodec;", "setMediaCodec", "(Landroid/media/MediaCodec;)V", "mimeType", "", "getMimeType", "()Ljava/lang/String;", "configure", "", "config", "createCodec", "withProfileLevel", "createHandler", "name", "createMediaFormat", "Landroid/media/MediaFormat;", "extendMediaFormat", "format", "generateExtra", "", "Ljava/nio/ByteBuffer;", "onNewMediaCodec", "release", "startStream", "stopStream", "core_release"})
public abstract class MediaCodecEncoder<T extends Config>
extends EventHandler
implements IEncoder<Config> {
    @NotNull
    private final IEncoderListener encoderListener;
    @Nullable
    private MediaCodec mediaCodec;
    @Nullable
    private HandlerThread callbackThread;
    @Nullable
    private Handler handler;
    @NotNull
    private final Object lock;
    private boolean isStopped;
    private boolean isOnError;
    private int _bitrate;
    private int bitrate;
    @NotNull
    private final encoderCallback.1 encoderCallback;

    public MediaCodecEncoder(@NotNull IEncoderListener encoderListener) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        this.encoderListener = encoderListener;
        this.lock = new Object();
        this.isStopped = true;
        this.encoderCallback = new MediaCodec.Callback(this){
            final /* synthetic */ MediaCodecEncoder<T> this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOutputBufferAvailable(@NotNull MediaCodec codec, int index, @NotNull MediaCodec.BufferInfo info) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    if (MediaCodecEncoder.access$isOnError$p(mediaCodecEncoder)) {
                        return;
                    }
                    try {
                        Unit unit;
                        MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                        if (mediaCodec == null) {
                            unit = null;
                        } else {
                            ByteBuffer byteBuffer = mediaCodec.getOutputBuffer(index);
                            if (byteBuffer == null) {
                                unit = null;
                            } else {
                                boolean isKeyFrame;
                                ByteBuffer buffer = byteBuffer;
                                boolean bl2 = false;
                                String string = codec.getOutputFormat().getString("mime");
                                Intrinsics.checkNotNull((Object)string);
                                String string2 = string;
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"codec.outputFormat.getSt\u2026g(MediaFormat.KEY_MIME)!!");
                                String mimeType = string2;
                                boolean bl3 = isKeyFrame = info.flags == 1;
                                if (info.flags != 2) {
                                    List list;
                                    if (isKeyFrame || StringExtensionsKt.isAudio(mimeType)) {
                                        MediaFormat mediaFormat = codec.getOutputFormat();
                                        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"codec.outputFormat");
                                        list = MediaCodecEncoder.access$generateExtra(mediaCodecEncoder, mediaFormat);
                                    } else {
                                        list = null;
                                    }
                                    List extra = list;
                                    ByteBuffer frameBuffer = null;
                                    frameBuffer = buffer;
                                    List list2 = extra;
                                    if (list2 != null) {
                                        List it = list2;
                                        boolean bl4 = false;
                                        byte[] prefix = null;
                                        prefix = new byte[]{};
                                        Iterable $this$forEach$iv = it;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            ByteBuffer csd = (ByteBuffer)element$iv;
                                            boolean bl5 = false;
                                            prefix = ArraysKt.plus((byte[])prefix, (byte[])ByteBufferExtensionsKt.extractArray(csd));
                                        }
                                        if (ByteBufferExtensionsKt.startsWith(buffer, prefix)) {
                                            buffer.position(prefix.length);
                                            ByteBuffer byteBuffer2 = buffer.slice();
                                            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"buffer.slice()");
                                            frameBuffer = byteBuffer2;
                                        }
                                    }
                                    Frame frame = new Frame(frameBuffer, mimeType, info.presentationTimeUs, null, isKeyFrame, extra);
                                    boolean bl6 = false;
                                    mediaCodecEncoder.getEncoderListener().onOutputFrame(frame);
                                }
                                MediaCodec mediaCodec2 = mediaCodecEncoder.getMediaCodec();
                                if (mediaCodec2 == null) {
                                    unit = null;
                                } else {
                                    mediaCodec2.releaseOutputBuffer(index, false);
                                    unit = Unit.INSTANCE;
                                }
                            }
                        }
                        Unit unit2 = unit;
                        if (unit2 == null) {
                            mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get output buffer")));
                        }
                    }
                    catch (IllegalStateException e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        ILogger.DefaultImpls.w$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)((Object)this)), "onOutputBufferAvailable called while stopped", null, 4, null);
                    }
                    catch (StreamPackError e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        mediaCodecEncoder.reportError(e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onInputBufferAvailable(@NotNull MediaCodec codec, int index) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Object object = MediaCodecEncoder.access$getLock$p(this.this$0);
                MediaCodecEncoder<T> mediaCodecEncoder = this.this$0;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    if (MediaCodecEncoder.access$isStopped$p(mediaCodecEncoder)) {
                        return;
                    }
                    if (MediaCodecEncoder.access$isOnError$p(mediaCodecEncoder)) {
                        return;
                    }
                    try {
                        Unit unit;
                        MediaCodec mediaCodec = mediaCodecEncoder.getMediaCodec();
                        if (mediaCodec == null) {
                            unit = null;
                        } else {
                            ByteBuffer byteBuffer = mediaCodec.getInputBuffer(index);
                            if (byteBuffer == null) {
                                unit = null;
                            } else {
                                ByteBuffer buffer = byteBuffer;
                                boolean bl2 = false;
                                Frame frame = mediaCodecEncoder.getEncoderListener().onInputFrame(buffer);
                                boolean bl3 = false;
                                MediaCodec mediaCodec2 = mediaCodecEncoder.getMediaCodec();
                                if (mediaCodec2 == null) {
                                    unit = null;
                                } else {
                                    mediaCodec2.queueInputBuffer(index, 0, frame.getBuffer().remaining(), frame.getPts(), 0);
                                    unit = Unit.INSTANCE;
                                }
                            }
                        }
                        Unit unit2 = unit;
                        if (unit2 == null) {
                            mediaCodecEncoder.reportError(new StreamPackError(new UnsupportedOperationException("MediaCodecEncoder: can't get input buffer")));
                        }
                    }
                    catch (IllegalStateException e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        ILogger.DefaultImpls.w$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)((Object)this)), "onInputBufferAvailable called while stopped", null, 4, null);
                    }
                    catch (StreamPackError e) {
                        MediaCodecEncoder.access$setOnError$p(mediaCodecEncoder, true);
                        mediaCodecEncoder.reportError(e);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }

            public void onOutputFormatChanged(@NotNull MediaCodec codec, @NotNull MediaFormat format) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)format, (String)"format");
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG((Object)((Object)this)), Intrinsics.stringPlus((String)"Format changed : ", (Object)format), null, 4, null);
            }

            public void onError(@NotNull MediaCodec codec, @NotNull MediaCodec.CodecException e) {
                Intrinsics.checkNotNullParameter((Object)codec, (String)"codec");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.reportError(new StreamPackError((Throwable)e));
            }
        };
    }

    @Override
    @NotNull
    public IEncoderListener getEncoderListener() {
        return this.encoderListener;
    }

    @Nullable
    protected final MediaCodec getMediaCodec() {
        return this.mediaCodec;
    }

    protected final void setMediaCodec(@Nullable MediaCodec value) {
        this.mediaCodec = value;
        this.onNewMediaCodec();
    }

    public final int getBitrate() {
        return this._bitrate;
    }

    public final void setBitrate(int value) {
        Bundle bundle = new Bundle();
        bundle.putInt("video-bitrate", value);
        MediaCodec mediaCodec = this.mediaCodec;
        if (mediaCodec != null) {
            mediaCodec.setParameters(bundle);
        }
        this.bitrate = value;
        this._bitrate = value;
    }

    /*
     * WARNING - void declaration
     */
    private final void createHandler(String name) {
        Handler handler;
        this.callbackThread = new HandlerThread(name);
        MediaCodecEncoder mediaCodecEncoder = this;
        HandlerThread handlerThread = this.callbackThread;
        if (handlerThread == null) {
            handler = null;
        } else {
            void handlerThread2;
            HandlerThread handlerThread3 = handlerThread;
            MediaCodecEncoder mediaCodecEncoder2 = mediaCodecEncoder;
            boolean bl = false;
            handlerThread2.start();
            handler = new Handler(handlerThread2.getLooper());
            mediaCodecEncoder = mediaCodecEncoder2;
        }
        mediaCodecEncoder.handler = handler;
    }

    public void onNewMediaCodec() {
    }

    @NotNull
    public MediaFormat createMediaFormat(@NotNull Config config, boolean withProfileLevel) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return config.getFormat$core_release(withProfileLevel);
    }

    public void extendMediaFormat(@NotNull Config config, @NotNull MediaFormat format) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
    }

    private final MediaCodec createCodec(Config config, boolean withProfileLevel) {
        MediaFormat format = this.createMediaFormat(config, withProfileLevel);
        String encoderName2 = MediaCodecHelper.INSTANCE.findEncoder(format);
        ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Selected encoder ", (Object)encoderName2), null, 4, null);
        MediaCodec mediaCodec = MediaCodec.createByCodecName((String)encoderName2);
        Intrinsics.checkNotNullExpressionValue((Object)mediaCodec, (String)"createByCodecName(encoderName)");
        MediaCodec codec = mediaCodec;
        this.extendMediaFormat(config, format);
        if (Build.VERSION.SDK_INT >= 23) {
            this.createHandler(Intrinsics.stringPlus((String)encoderName2, (Object)".thread"));
            codec.setCallback((MediaCodec.Callback)this.encoderCallback, this.handler);
        } else {
            codec.setCallback((MediaCodec.Callback)this.encoderCallback);
        }
        try {
            codec.configure(format, null, null, 1);
        }
        catch (Exception e) {
            codec.release();
            throw e;
        }
        return codec;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configure(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this._bitrate = config.getStartBitrate();
        try {
            MediaCodec mediaCodec;
            MediaCodecEncoder mediaCodecEncoder;
            MediaCodecEncoder mediaCodecEncoder2 = this;
            try {
                mediaCodecEncoder = mediaCodecEncoder2;
                mediaCodec = this.createCodec(config, true);
            }
            catch (Exception exception) {
                void e;
                mediaCodecEncoder = mediaCodecEncoder2;
                ILogger.DefaultImpls.i$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), "Fallback without profile and level (reason: " + e + ')', null, 4, null);
                mediaCodec = this.createCodec(config, false);
            }
            mediaCodecEncoder.setMediaCodec(mediaCodec);
        }
        catch (Exception e) {
            ILogger.DefaultImpls.e$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), Intrinsics.stringPlus((String)"Failed to create encoder for ", (Object)config), null, 4, null);
            throw e;
        }
    }

    @Override
    @Nullable
    public String getMimeType() {
        String string;
        String string2;
        MediaCodec mediaCodec = this.mediaCodec;
        if (mediaCodec == null) {
            string2 = null;
        } else {
            MediaFormat mediaFormat = mediaCodec.getOutputFormat();
            string2 = string = mediaFormat == null ? null : mediaFormat.getString("mime");
        }
        if (string == null) {
            throw new IllegalStateException("Can't get MimeType without configuration");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startStream() {
        Object object = this.lock;
        synchronized (object) {
            Unit unit;
            boolean bl = false;
            this.isOnError = false;
            this.isStopped = false;
            MediaCodec mediaCodec = this.getMediaCodec();
            if (mediaCodec == null) {
                unit = null;
            } else {
                mediaCodec.start();
                unit = Unit.INSTANCE;
            }
            if (unit == null) {
                throw new IllegalStateException("Can't start without configuration");
            }
            Unit unit2 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStream() {
        try {
            Object object = this.lock;
            synchronized (object) {
                Unit unit;
                boolean bl = false;
                this.isStopped = true;
                MediaCodec mediaCodec = this.getMediaCodec();
                if (mediaCodec != null) {
                    mediaCodec.setCallback(null);
                }
                MediaCodec mediaCodec2 = this.getMediaCodec();
                if (mediaCodec2 != null) {
                    mediaCodec2.signalEndOfInputStream();
                }
                MediaCodec mediaCodec3 = this.getMediaCodec();
                if (mediaCodec3 != null) {
                    mediaCodec3.flush();
                }
                MediaCodec mediaCodec4 = this.getMediaCodec();
                if (mediaCodec4 == null) {
                    unit = null;
                } else {
                    mediaCodec4.stop();
                    unit = Unit.INSTANCE;
                }
                Unit unit2 = unit;
            }
        }
        catch (IllegalStateException e) {
            ILogger.DefaultImpls.d$default(Logger.INSTANCE, ExtensionsKt.getTAG(this), "Not running", null, 4, null);
        }
    }

    @Override
    public void release() {
        MediaCodec mediaCodec = this.mediaCodec;
        if (mediaCodec != null) {
            mediaCodec.release();
        }
        this.setMediaCodec(null);
    }

    private final List<ByteBuffer> generateExtra(MediaFormat format) {
        Object object;
        ByteBuffer it;
        List extra = new ArrayList();
        ByteBuffer byteBuffer = format.getByteBuffer("csd-0");
        if (byteBuffer != null) {
            boolean bl;
            it = byteBuffer;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)format.getString("mime"), (Object)"video/hevc")) {
                object = new byte[]{0, 0, 0, 1};
                List<ByteBuffer> parameterSets = ByteBufferExtensionsKt.slices(it, object);
                extra.add(parameterSets.get(1));
                extra.add(parameterSets.get(0));
                bl = extra.add(parameterSets.get(2));
            } else {
                ByteBuffer byteBuffer2 = it.duplicate();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"it.duplicate()");
                bl = extra.add(byteBuffer2);
            }
        }
        ByteBuffer byteBuffer3 = format.getByteBuffer("csd-1");
        if (byteBuffer3 != null) {
            it = byteBuffer3;
            boolean bl = false;
            object = it.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.duplicate()");
            extra.add(object);
        }
        ByteBuffer byteBuffer4 = format.getByteBuffer("csd-2");
        if (byteBuffer4 != null) {
            it = byteBuffer4;
            boolean bl = false;
            object = it.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.duplicate()");
            extra.add(object);
        }
        return extra;
    }

    public static final /* synthetic */ Object access$getLock$p(MediaCodecEncoder $this) {
        return $this.lock;
    }

    public static final /* synthetic */ List access$generateExtra(MediaCodecEncoder $this, MediaFormat format) {
        return $this.generateExtra(format);
    }

    public static final /* synthetic */ boolean access$isStopped$p(MediaCodecEncoder $this) {
        return $this.isStopped;
    }

    public static final /* synthetic */ boolean access$isOnError$p(MediaCodecEncoder $this) {
        return $this.isOnError;
    }

    public static final /* synthetic */ void access$setOnError$p(MediaCodecEncoder $this, boolean bl) {
        $this.isOnError = bl;
    }
}

