/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.utils;

import android.content.Context;
import android.util.Range;
import io.github.thibaultbee.streampack.R;
import io.github.thibaultbee.streampack.internal.muxers.ts.data.TsServiceInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0000\u001a/\u0010\u0005\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007*\u0002H\u00062\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u0002H\u0006\u00a2\u0006\u0002\u0010\n\u001a-\u0010\u0005\u001a\u0002H\u0006\"\u000e\b\u0000\u0010\u0006*\b\u0012\u0004\u0012\u0002H\u00060\u0007*\u0002H\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00060\f\u00a2\u0006\u0002\u0010\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0011"}, d2={"defaultTsServiceInfo", "Lio/github/thibaultbee/streampack/internal/muxers/ts/data/TsServiceInfo;", "Landroid/content/Context;", "getDefaultTsServiceInfo", "(Landroid/content/Context;)Lio/github/thibaultbee/streampack/internal/muxers/ts/data/TsServiceInfo;", "clamp", "T", "", "min", "max", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;)Ljava/lang/Comparable;", "range", "Landroid/util/Range;", "(Ljava/lang/Comparable;Landroid/util/Range;)Ljava/lang/Comparable;", "numOfBits", "", "", "core_release"})
public final class ExtensionsKt {
    public static final int numOfBits(@NotNull Object $this$numOfBits) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$numOfBits, (String)"<this>");
        Object object = $this$numOfBits;
        if (object instanceof Byte) {
            n = 8;
        } else if (object instanceof Short) {
            n = 16;
        } else if (object instanceof Integer) {
            n = 32;
        } else if (object instanceof Long) {
            n = 64;
        } else if (object instanceof Float) {
            n = 32;
        } else if (object instanceof Double) {
            n = 64;
        } else if (object instanceof Boolean) {
            n = 1;
        } else if (object instanceof Character) {
            n = 16;
        } else if (object instanceof String) {
            n = 8 * ((String)$this$numOfBits).length();
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported type: ", (Object)$this$numOfBits.getClass().getName()));
        }
        return n;
    }

    @NotNull
    public static final TsServiceInfo getDefaultTsServiceInfo(@NotNull Context $this$defaultTsServiceInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultTsServiceInfo, (String)"<this>");
        String string2 = $this$defaultTsServiceInfo.getString(R.string.ts_service_default_name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.ts_service_default_name)");
        String string3 = string2;
        string2 = $this$defaultTsServiceInfo.getString(R.string.ts_service_default_provider_name);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.ts_se\u2026ce_default_provider_name)");
        return new TsServiceInfo(TsServiceInfo.ServiceType.DIGITAL_TV, 18072, string3, string2);
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T clamp(@NotNull T $this$clamp, @NotNull T min, @NotNull T max) {
        Intrinsics.checkNotNullParameter($this$clamp, (String)"<this>");
        Intrinsics.checkNotNullParameter(min, (String)"min");
        Intrinsics.checkNotNullParameter(max, (String)"max");
        return $this$clamp.compareTo(min) < 0 ? min : ($this$clamp.compareTo(max) > 0 ? max : $this$clamp);
    }

    @NotNull
    public static final <T extends Comparable<? super T>> T clamp(@NotNull T $this$clamp, @NotNull Range<T> range) {
        Intrinsics.checkNotNullParameter($this$clamp, (String)"<this>");
        Intrinsics.checkNotNullParameter(range, (String)"range");
        Comparable comparable = range.getLower();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"range.lower");
        Comparable comparable2 = comparable;
        comparable = range.getUpper();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"range.upper");
        return (T)ExtensionsKt.clamp($this$clamp, comparable2, comparable);
    }
}

