/*
 * Decompiled with CFR 0.152.
 */
package io.github.thibaultbee.streampack.internal.encoders;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Size;
import android.view.Surface;
import io.github.thibaultbee.streampack.data.VideoConfig;
import io.github.thibaultbee.streampack.internal.encoders.IEncoderListener;
import io.github.thibaultbee.streampack.internal.encoders.MediaCodecEncoder;
import io.github.thibaultbee.streampack.internal.gl.EGlSurface;
import io.github.thibaultbee.streampack.internal.gl.FullFrameRect;
import io.github.thibaultbee.streampack.internal.gl.Texture2DProgram;
import io.github.thibaultbee.streampack.internal.utils.DeviceExtensionsKt;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.logger.ILogger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\nH\u0002J\b\u0010\"\u001a\u00020\u001cH\u0016J\b\u0010#\u001a\u00020\u001cH\u0016R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder;", "Lio/github/thibaultbee/streampack/internal/encoders/MediaCodecEncoder;", "Lio/github/thibaultbee/streampack/data/VideoConfig;", "encoderListener", "Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;", "onInternalErrorListener", "Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "context", "Landroid/content/Context;", "useSurfaceMode", "", "manageVideoOrientation", "logger", "Lio/github/thibaultbee/streampack/logger/ILogger;", "(Lio/github/thibaultbee/streampack/internal/encoders/IEncoderListener;Lio/github/thibaultbee/streampack/listeners/OnErrorListener;Landroid/content/Context;ZZLio/github/thibaultbee/streampack/logger/ILogger;)V", "codecSurface", "Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "getCodecSurface", "()Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "setCodecSurface", "(Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;)V", "inputSurface", "Landroid/view/Surface;", "getInputSurface", "()Landroid/view/Surface;", "getOnInternalErrorListener", "()Lio/github/thibaultbee/streampack/listeners/OnErrorListener;", "configure", "", "config", "createVideoCodec", "Landroid/media/MediaCodec;", "videoConfig", "useConfigProfileLevel", "startStream", "stopStream", "CodecSurface", "core_release"})
public final class VideoMediaCodecEncoder
extends MediaCodecEncoder<VideoConfig> {
    @NotNull
    private final OnErrorListener onInternalErrorListener;
    @NotNull
    private final Context context;
    private final boolean useSurfaceMode;
    private final boolean manageVideoOrientation;
    @Nullable
    private CodecSurface codecSurface;

    public VideoMediaCodecEncoder(@NotNull IEncoderListener encoderListener, @NotNull OnErrorListener onInternalErrorListener2, @NotNull Context context, boolean useSurfaceMode, boolean manageVideoOrientation, @NotNull ILogger logger) {
        Intrinsics.checkNotNullParameter((Object)encoderListener, (String)"encoderListener");
        Intrinsics.checkNotNullParameter((Object)onInternalErrorListener2, (String)"onInternalErrorListener");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(encoderListener, logger);
        this.onInternalErrorListener = onInternalErrorListener2;
        this.context = context;
        this.useSurfaceMode = useSurfaceMode;
        this.manageVideoOrientation = manageVideoOrientation;
        this.codecSurface = this.useSurfaceMode ? new CodecSurface(this.context, this.manageVideoOrientation) : (CodecSurface)null;
    }

    @Override
    @NotNull
    protected OnErrorListener getOnInternalErrorListener() {
        return this.onInternalErrorListener;
    }

    @Nullable
    public final CodecSurface getCodecSurface() {
        return this.codecSurface;
    }

    public final void setCodecSurface(@Nullable CodecSurface codecSurface) {
        this.codecSurface = codecSurface;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void configure(@NotNull VideoConfig config) {
        MediaCodec mediaCodec;
        VideoMediaCodecEncoder videoMediaCodecEncoder;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        VideoMediaCodecEncoder videoMediaCodecEncoder2 = this;
        try {
            videoMediaCodecEncoder = videoMediaCodecEncoder2;
            mediaCodec = this.createVideoCodec(config, true);
        }
        catch (MediaCodec.CodecException codecException) {
            videoMediaCodecEncoder = videoMediaCodecEncoder2;
            mediaCodec = this.createVideoCodec(config, false);
        }
        MediaCodec e = mediaCodec;
        videoMediaCodecEncoder2 = videoMediaCodecEncoder;
        boolean bl = false;
        CodecSurface codecSurface = this.getCodecSurface();
        if (codecSurface != null) {
            void $this$configure_u24lambda_u2d0;
            codecSurface.setSurface($this$configure_u24lambda_u2d0.createInputSurface());
        }
        videoMediaCodecEncoder2.setMediaCodec(mediaCodec);
    }

    private final MediaCodec createVideoCodec(VideoConfig videoConfig, boolean useConfigProfileLevel) {
        Size resolution = this.manageVideoOrientation ? videoConfig.getOrientedResolution(this.context) : videoConfig.getResolution();
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)videoConfig.getMimeType(), (int)resolution.getWidth(), (int)resolution.getHeight());
        Intrinsics.checkNotNullExpressionValue((Object)mediaFormat, (String)"createVideoFormat(\n     \u2026solution.height\n        )");
        MediaFormat videoFormat = mediaFormat;
        MediaCodec codec = this.createCodec(videoFormat);
        videoFormat.setInteger("bitrate", videoConfig.getStartBitrate());
        this.set_bitrate(videoConfig.getStartBitrate());
        videoFormat.setInteger("frame-rate", videoConfig.getFps());
        videoFormat.setInteger("color-format", 2130708361);
        videoFormat.setInteger("i-frame-interval", 1);
        if (useConfigProfileLevel) {
            videoFormat.setInteger("profile", videoConfig.getProfile());
            if (Build.VERSION.SDK_INT >= 23) {
                videoFormat.setInteger("level", videoConfig.getLevel());
            }
        }
        this.configureCodec(codec, videoFormat, "VMediaCodecThread");
        return codec;
    }

    @Override
    public void startStream() {
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.startStream();
        }
        super.startStream();
    }

    @Override
    public void stopStream() {
        CodecSurface codecSurface = this.codecSurface;
        if (codecSurface != null) {
            codecSurface.stopStream();
        }
        super.stopStream();
    }

    @Nullable
    public final Surface getInputSurface() {
        CodecSurface codecSurface = this.codecSurface;
        return codecSurface == null ? null : codecSurface.getInputSurface();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u001c\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001eJ(\u0010 \u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001e0\"H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010%\u001a\u00020\u001eJ\u0006\u0010&\u001a\u00020\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lio/github/thibaultbee/streampack/internal/encoders/VideoMediaCodecEncoder$CodecSurface;", "Landroid/graphics/SurfaceTexture$OnFrameAvailableListener;", "context", "Landroid/content/Context;", "manageVideoOrientation", "", "(Landroid/content/Context;Z)V", "eglSurface", "Lio/github/thibaultbee/streampack/internal/gl/EGlSurface;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "fullFrameRect", "Lio/github/thibaultbee/streampack/internal/gl/FullFrameRect;", "inputSurface", "Landroid/view/Surface;", "getInputSurface", "()Landroid/view/Surface;", "isRunning", "value", "surface", "getSurface", "setSurface", "(Landroid/view/Surface;)V", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "textureId", "", "attachOrBuildSurfaceTexture", "detachSurfaceTexture", "", "dispose", "ensureGlContext", "action", "Lkotlin/Function1;", "initOrUpdateSurfaceTexture", "onFrameAvailable", "startStream", "stopStream", "core_release"})
    public static final class CodecSurface
    implements SurfaceTexture.OnFrameAvailableListener {
        @NotNull
        private final Context context;
        private final boolean manageVideoOrientation;
        @Nullable
        private EGlSurface eglSurface;
        @Nullable
        private FullFrameRect fullFrameRect;
        private int textureId;
        private final ExecutorService executor;
        private boolean isRunning;
        @Nullable
        private SurfaceTexture surfaceTexture;
        @Nullable
        private Surface surface;

        public CodecSurface(@NotNull Context context, boolean manageVideoOrientation) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.context = context;
            this.manageVideoOrientation = manageVideoOrientation;
            this.textureId = -1;
            this.executor = Executors.newSingleThreadExecutor();
        }

        @Nullable
        public final Surface getInputSurface() {
            Surface surface;
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture == null) {
                surface = null;
            } else {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                surface = new Surface(this.surfaceTexture);
            }
            return surface;
        }

        @Nullable
        public final Surface getSurface() {
            return this.surface;
        }

        public final void setSurface(@Nullable Surface value) {
            this.executor.submit(() -> CodecSurface._set_surface_$lambda-3(this, value)).get();
            this.surface = value;
        }

        private final void initOrUpdateSurfaceTexture(Surface surface) {
            this.eglSurface = this.ensureGlContext(new EGlSurface(surface), (Function1<? super EGlSurface, Unit>)((Function1)new Function1<EGlSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull EGlSurface it) {
                    void $this$invoke_u24lambda_u2d1;
                    FullFrameRect $this$invoke_u24lambda_u2d0;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int width = it.getWidth();
                    int height = it.getHeight();
                    FullFrameRect fullFrameRect = new FullFrameRect(new Texture2DProgram());
                    CodecSurface codecSurface = this.this$0;
                    FullFrameRect fullFrameRect2 = fullFrameRect;
                    CodecSurface codecSurface2 = this.this$0;
                    boolean bl = false;
                    CodecSurface.access$setTextureId$p(codecSurface, $this$invoke_u24lambda_u2d0.createTextureObject());
                    $this$invoke_u24lambda_u2d0.setMVPMatrixAndViewPort(DeviceExtensionsKt.getOrientation(CodecSurface.access$getContext$p(codecSurface)), new Size(width, height));
                    CodecSurface.access$setFullFrameRect$p(codecSurface2, fullFrameRect);
                    fullFrameRect = CodecSurface.access$attachOrBuildSurfaceTexture(this.this$0, CodecSurface.access$getSurfaceTexture$p(this.this$0));
                    codecSurface = this.this$0;
                    $this$invoke_u24lambda_u2d0 = fullFrameRect;
                    codecSurface2 = this.this$0;
                    boolean bl2 = false;
                    if (CodecSurface.access$getManageVideoOrientation$p(codecSurface)) {
                        if (DeviceExtensionsKt.isPortrait(CodecSurface.access$getContext$p(codecSurface))) {
                            $this$invoke_u24lambda_u2d1.setDefaultBufferSize(height, width);
                        } else {
                            $this$invoke_u24lambda_u2d1.setDefaultBufferSize(width, height);
                        }
                    } else {
                        $this$invoke_u24lambda_u2d1.setDefaultBufferSize(width, height);
                    }
                    $this$invoke_u24lambda_u2d1.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)codecSurface);
                    CodecSurface.access$setSurfaceTexture$p(codecSurface2, (SurfaceTexture)fullFrameRect);
                }
            }));
        }

        @SuppressLint(value={"Recycle"})
        private final SurfaceTexture attachOrBuildSurfaceTexture(SurfaceTexture surfaceTexture) {
            SurfaceTexture surfaceTexture2;
            if (surfaceTexture == null) {
                surfaceTexture2 = new SurfaceTexture(this.textureId);
            } else {
                surfaceTexture.attachToGLContext(this.textureId);
                surfaceTexture2 = surfaceTexture;
            }
            return surfaceTexture2;
        }

        private final EGlSurface ensureGlContext(EGlSurface surface, Function1<? super EGlSurface, Unit> action) {
            EGlSurface eGlSurface = surface;
            if (eGlSurface != null) {
                EGlSurface it = eGlSurface;
                boolean bl = false;
                it.makeCurrent();
                action.invoke((Object)it);
                it.makeUnCurrent();
            }
            return surface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFrameAvailable(@NotNull SurfaceTexture surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
            synchronized (this) {
                boolean bl = false;
                if (!this.isRunning) {
                    return;
                }
                this.executor.execute(() -> CodecSurface.onFrameAvailable$lambda-7$lambda-6(this, surfaceTexture));
                Unit unit = Unit.INSTANCE;
            }
        }

        public final void startStream() {
            this.ensureGlContext(this.eglSurface, (Function1<? super EGlSurface, Unit>)((Function1)new Function1<EGlSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EGlSurface it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SurfaceTexture surfaceTexture = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                    if (surfaceTexture != null) {
                        surfaceTexture.updateTexImage();
                    }
                }
            }));
            this.isRunning = true;
        }

        private final void detachSurfaceTexture() {
            this.ensureGlContext(this.eglSurface, (Function1<? super EGlSurface, Unit>)((Function1)new Function1<EGlSurface, Unit>(this){
                final /* synthetic */ CodecSurface this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull EGlSurface it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    SurfaceTexture surfaceTexture = CodecSurface.access$getSurfaceTexture$p(this.this$0);
                    if (surfaceTexture != null) {
                        surfaceTexture.detachFromGLContext();
                    }
                    FullFrameRect fullFrameRect = CodecSurface.access$getFullFrameRect$p(this.this$0);
                    if (fullFrameRect != null) {
                        fullFrameRect.release(true);
                    }
                }
            }));
            EGlSurface eGlSurface = this.eglSurface;
            if (eGlSurface != null) {
                eGlSurface.release();
            }
            this.eglSurface = null;
            this.fullFrameRect = null;
        }

        public final void stopStream() {
            this.executor.submit(() -> CodecSurface.stopStream$lambda-9(this)).get();
        }

        public final void dispose() {
            this.stopStream();
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                surfaceTexture.release();
            }
            this.surfaceTexture = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void _set_surface_$lambda-3(CodecSurface this$0, Surface $value) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (this$0.eglSurface != null) {
                this$0.detachSurfaceTexture();
            }
            synchronized (this$0) {
                boolean bl = false;
                Surface surface = $value;
                if (surface != null) {
                    Surface it = surface;
                    boolean bl2 = false;
                    this$0.initOrUpdateSurfaceTexture(it);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private static final void onFrameAvailable$lambda-7$lambda-6(CodecSurface this$0, SurfaceTexture $surfaceTexture) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$surfaceTexture, (String)"$surfaceTexture");
            EGlSurface eGlSurface = this$0.eglSurface;
            if (eGlSurface != null) {
                EGlSurface it = eGlSurface;
                boolean bl = false;
                it.makeCurrent();
                $surfaceTexture.updateTexImage();
                float[] stMatrix = new float[16];
                $surfaceTexture.getTransformMatrix(stMatrix);
                FullFrameRect fullFrameRect = this$0.fullFrameRect;
                if (fullFrameRect != null) {
                    fullFrameRect.drawFrame(this$0.textureId, stMatrix);
                }
                it.setPresentationTime($surfaceTexture.getTimestamp());
                it.swapBuffers();
                $surfaceTexture.releaseTexImage();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void stopStream$lambda-9(CodecSurface this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            synchronized (this$0) {
                boolean bl = false;
                this$0.isRunning = false;
                this$0.detachSurfaceTexture();
                Unit unit = Unit.INSTANCE;
            }
        }

        public static final /* synthetic */ void access$setFullFrameRect$p(CodecSurface $this, FullFrameRect fullFrameRect) {
            $this.fullFrameRect = fullFrameRect;
        }

        public static final /* synthetic */ void access$setSurfaceTexture$p(CodecSurface $this, SurfaceTexture surfaceTexture) {
            $this.surfaceTexture = surfaceTexture;
        }

        public static final /* synthetic */ SurfaceTexture access$attachOrBuildSurfaceTexture(CodecSurface $this, SurfaceTexture surfaceTexture) {
            return $this.attachOrBuildSurfaceTexture(surfaceTexture);
        }

        public static final /* synthetic */ SurfaceTexture access$getSurfaceTexture$p(CodecSurface $this) {
            return $this.surfaceTexture;
        }

        public static final /* synthetic */ void access$setTextureId$p(CodecSurface $this, int n) {
            $this.textureId = n;
        }

        public static final /* synthetic */ Context access$getContext$p(CodecSurface $this) {
            return $this.context;
        }

        public static final /* synthetic */ boolean access$getManageVideoOrientation$p(CodecSurface $this) {
            return $this.manageVideoOrientation;
        }

        public static final /* synthetic */ FullFrameRect access$getFullFrameRect$p(CodecSurface $this) {
            return $this.fullFrameRect;
        }
    }
}

