/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.lnurl.auth;

import java.util.Objects;
import org.tbk.lnurl.auth.InMemoryK1Cache;
import org.tbk.lnurl.auth.K1;
import org.tbk.lnurl.auth.K1Cache;
import org.tbk.lnurl.auth.K1Factory;
import org.tbk.lnurl.auth.K1Manager;
import org.tbk.lnurl.auth.SimpleK1Factory;

public final class SimpleK1Manager
implements K1Manager {
    private final K1Factory factory;
    private final K1Cache cache;

    public SimpleK1Manager() {
        this(new SimpleK1Factory(), new InMemoryK1Cache());
    }

    public SimpleK1Manager(K1Factory factory, K1Cache cache) {
        this.factory = Objects.requireNonNull(factory);
        this.cache = Objects.requireNonNull(cache);
    }

    public K1 create() {
        K1 k1 = this.factory.create();
        this.cache.put(k1);
        return k1;
    }

    public boolean isValid(K1 k1) {
        return this.cache.isPresent(k1);
    }

    public void invalidate(K1 k1) {
        this.cache.remove(k1);
    }
}

