/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.lnurl.auth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tbk.lnurl.auth.K1;
import org.tbk.lnurl.auth.LinkingKey;
import org.tbk.lnurl.auth.LnurlAuthPairingService;

public final class InMemoryLnurlAuthPairingService
implements LnurlAuthPairingService {
    private static final Logger log = LoggerFactory.getLogger(InMemoryLnurlAuthPairingService.class);
    private static final RemovalListener<K1, LinkingKey> LOG_REMOVAL_LISTENER = new RemovalListener<K1, LinkingKey>(){

        public void onRemoval(RemovalNotification<K1, LinkingKey> notification) {
            log.debug("Remove k1 '{}' from in-memory pairing cache: {}", notification.getKey(), (Object)notification.getCause());
        }
    };
    public final Cache<K1, LinkingKey> cache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(5L)).maximumSize(100000L).removalListener(LOG_REMOVAL_LISTENER).build();

    public Optional<LinkingKey> findPairedLinkingKeyByK1(K1 k1) {
        return Optional.ofNullable((LinkingKey)this.cache.getIfPresent((Object)k1));
    }

    public boolean pairK1WithLinkingKey(K1 k1, LinkingKey linkingKey) {
        this.cache.put((Object)k1, (Object)linkingKey);
        return true;
    }
}

