/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.config;

import java.util.List;
import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.tbk.bitcoin.tool.fee.CompositeFeeProvider;
import org.tbk.bitcoin.tool.fee.FeeProvider;
import org.tbk.bitcoin.tool.fee.config.BitcoinFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BitcoinFeeClientAutoConfigProperties.class})
@ConditionalOnProperty(value={"org.tbk.bitcoin.tool.fee.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={CompositeFeeProvider.class})
public class BitcoinFeeClientAutoConfiguration {
    public BitcoinFeeClientAutoConfiguration(BitcoinFeeClientAutoConfigProperties properties) {
        Objects.requireNonNull(properties);
    }

    @Primary
    @Bean
    @ConditionalOnMissingBean(value={CompositeFeeProvider.class})
    public FeeProvider compositeFeeProvider(List<FeeProvider> feeProviders) {
        return new CompositeFeeProvider(feeProviders);
    }
}

