/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.blockstreaminfo.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.blockstreaminfo.BlockstreamInfoFeeApiClient;
import org.tbk.bitcoin.tool.fee.blockstreaminfo.BlockstreamInfoFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.blockstreaminfo.BlockstreamInfoFeeProvider;
import org.tbk.bitcoin.tool.fee.blockstreaminfo.config.BlockstreamInfoFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BlockstreamInfoFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BlockstreamInfoFeeApiClient.class, BlockstreamInfoFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.blockstreaminfo.enabled"}, havingValue="true", matchIfMissing=true)
public class BlockstreamInfoFeeClientAutoConfiguration {
    private final BlockstreamInfoFeeClientAutoConfigProperties properties;

    public BlockstreamInfoFeeClientAutoConfiguration(BlockstreamInfoFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockstreamInfoFeeApiClient.class})
    public BlockstreamInfoFeeApiClient blockstreamInfoFeeApiClient() {
        return new BlockstreamInfoFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockstreamInfoFeeProvider.class})
    public BlockstreamInfoFeeProvider blockstreamInfoFeeProvider(BlockstreamInfoFeeApiClient blockstreamInfoFeeApiClient) {
        return new BlockstreamInfoFeeProvider(blockstreamInfoFeeApiClient);
    }
}

