/*
 * Decompiled with CFR 0.152.
 */
package org.tbk.bitcoin.tool.fee.blockchaininfo.config;

import java.util.Objects;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.tbk.bitcoin.tool.fee.blockchaininfo.BlockchainInfoFeeApiClient;
import org.tbk.bitcoin.tool.fee.blockchaininfo.BlockchainInfoFeeApiClientImpl;
import org.tbk.bitcoin.tool.fee.blockchaininfo.BlockchainInfoFeeProvider;
import org.tbk.bitcoin.tool.fee.blockchaininfo.config.BlockchainInfoFeeClientAutoConfigProperties;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={BlockchainInfoFeeClientAutoConfigProperties.class})
@ConditionalOnClass(value={BlockchainInfoFeeApiClient.class, BlockchainInfoFeeProvider.class})
@ConditionalOnProperty(name={"org.tbk.bitcoin.tool.fee.enabled", "org.tbk.bitcoin.tool.fee.blockchaininfo.enabled"}, havingValue="true", matchIfMissing=true)
public class BlockchainInfoFeeClientAutoConfiguration {
    private final BlockchainInfoFeeClientAutoConfigProperties properties;

    public BlockchainInfoFeeClientAutoConfiguration(BlockchainInfoFeeClientAutoConfigProperties properties) {
        this.properties = Objects.requireNonNull(properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockchainInfoFeeApiClient.class})
    public BlockchainInfoFeeApiClient blockchainInfoFeeApiClient() {
        return new BlockchainInfoFeeApiClientImpl(this.properties.getBaseUrl(), (String)this.properties.getToken().orElse(null));
    }

    @Bean
    @ConditionalOnMissingBean(value={BlockchainInfoFeeProvider.class})
    public BlockchainInfoFeeProvider blockchainInfoFeeProvider(BlockchainInfoFeeApiClient blockchainInfoFeeApiClient) {
        return new BlockchainInfoFeeProvider(blockchainInfoFeeApiClient);
    }
}

